/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.servlet;

import com.sas.framework.config.SiteConfiguration;
import com.sas.framework.config.dao.ApplicationDAOInterface;
import com.sas.framework.config.dao.PropertiesApplicationDAO;
import com.sas.framework.config.impl.ConfigurationService;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BootstrapServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String CONTAINER_HOST = "j2ee.container.host";
    private static final String CONTAINER_INFO = "j2ee.container.info";
    private static final Logger LOGGER = LogManager.getLogger(BootstrapServlet.class);

    public void init() throws ServletException {
        super.init();
        this.loadConfiguration();
    }

    protected void loadConfiguration() throws ServletException {
        String hostname = this.getContainerHost();
        String hostinfo = this.getContainerInfo();
        LOGGER.info("Boostrapping on " + hostname + " : " + hostinfo + "... ");
        Properties p = new Properties();
        ServletConfig config = this.getServletConfig();
        Enumeration parameters = config.getInitParameterNames();
        while (parameters.hasMoreElements()) {
            String next = (String)parameters.nextElement();
            String value = config.getInitParameter(next);
            p.setProperty(next, value);
        }
        p.setProperty(CONTAINER_HOST, hostname);
        p.setProperty(CONTAINER_INFO, hostinfo);
        SiteConfiguration site = new SiteConfiguration();
        site.setConfiguration(p);
        Properties applicationProperties = new Properties();
        String props = site.getConfigurationProperty("application.dao");
        try {
            applicationProperties.load(new URL(props).openStream());
        }
        catch (IOException ioe) {
            throw new ServletException(ioe.getMessage(), (Throwable)ioe);
        }
        ConfigurationService configService = new ConfigurationService();
        PropertiesApplicationDAO dao = new PropertiesApplicationDAO();
        dao.setProperties(applicationProperties);
        configService.setApplicationDAO((ApplicationDAOInterface)dao);
    }

    private String getContainerHost() {
        String hostname = "UNKNOWN";
        try {
            InetAddress me = InetAddress.getLocalHost();
            hostname = me.getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hostname;
    }

    private String getContainerInfo() {
        return this.getServletContext().getServerInfo();
    }
}

