/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.resolvers;

import com.sas.framework.commons.AbstractEnum;
import com.sas.framework.commons.resolvers.PreferenceResolverInterface;
import com.sas.framework.personalization.HelpSetting;
import com.sas.framework.personalization.LongDateFormat;
import com.sas.framework.personalization.ShortDateFormat;
import com.sas.framework.personalization.TimeDateFormat;
import com.sas.framework.personalization.TimeFormat;
import com.sas.framework.webapp.holders.RequestHolder;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class BasicPreferenceResolver
implements PreferenceResolverInterface {
    protected Object getPreference(String name) {
        ServletContext context;
        Properties settings;
        HttpServletRequest request = (HttpServletRequest)RequestHolder.getRequest();
        HttpSession session = request.getSession();
        String prefValue = (String)session.getAttribute(name);
        if (null == prefValue && null != (settings = (Properties)(context = session.getServletContext()).getAttribute("_sas_ApplicationSettings"))) {
            prefValue = settings.getProperty(name);
        }
        return prefValue;
    }

    public List getPreferences(String name) {
        String prefValue;
        ServletContext context;
        Properties settings;
        HttpServletRequest request = (HttpServletRequest)RequestHolder.getRequest();
        HttpSession session = request.getSession();
        ArrayList<String> value = (ArrayList<String>)session.getAttribute(name);
        if (null == value && null != (settings = (Properties)(context = session.getServletContext()).getAttribute("_sas_ApplicationSettings")) && null != (prefValue = settings.getProperty(name))) {
            value = new ArrayList<String>();
            value.add(prefValue);
        }
        return value;
    }

    public String getStringPreference(String name) {
        return (String)this.getPreference(name);
    }

    public AbstractEnum getEnumPreference(String name, AbstractEnum[] enums) {
        if (null == name || enums.length < 1) {
            return null;
        }
        return AbstractEnum.getInstance((String)this.getStringPreference(name), (AbstractEnum[])enums);
    }

    public Object getObjectPreference(String name) {
        return this.getPreference(name);
    }

    public boolean getBooleanPreference(String name) {
        String value = this.getStringPreference(name);
        return Boolean.valueOf(value);
    }

    public int getIntPreference(String name) {
        String value = this.getStringPreference(name);
        Integer i = null;
        try {
            i = Integer.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("The value [" + value + "] is not an integer.", nfe);
        }
        return i;
    }

    public void setPreference(String name, Object value) {
        HttpServletRequest request = (HttpServletRequest)RequestHolder.getRequest();
        HttpSession session = request.getSession();
        session.setAttribute(name, value);
    }

    public HelpSetting getHelpSetting() {
        String preference = this.getStringPreference("Help.DisplayQuickHelp");
        if (Boolean.parseBoolean(preference)) {
            return HelpSetting.ON;
        }
        return (HelpSetting)this.getEnumPreference("Help.DisplayQuickHelp", (AbstractEnum[])HelpSetting.OPTIONS);
    }

    public ShortDateFormat getShortDateFormat() {
        String value = this.getStringPreference("Format.ShortDate");
        return ShortDateFormat.getInstance((String)value);
    }

    public LongDateFormat getLongDateFormat() {
        String value = this.getStringPreference("Format.LongDate");
        return LongDateFormat.getInstance((String)value);
    }

    public TimeDateFormat getTimeDateFormat() {
        String value = this.getStringPreference("Format.TimeDate");
        return TimeDateFormat.getInstance((String)value);
    }

    public TimeFormat getTimeFormat() {
        String value = this.getStringPreference("Format.Time");
        return TimeFormat.getInstance((String)value);
    }

    public Boolean getBoolPreference(String name) {
        String value = this.getStringPreference(name);
        return null == value ? null : Boolean.valueOf(value);
    }

    public Integer getIntegerPreference(String name) {
        String value = this.getStringPreference(name);
        return null == value ? null : Integer.valueOf(value);
    }
}

