/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.helpers;

import com.sas.framework.commons.util.BackToLink;
import com.sas.framework.commons.util.Breadcrumbs;
import com.sas.framework.webapp.helpers.FrameworkHelper;
import com.sas.framework.webapp.i18n.RB;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Stack;

public class NavigationHelper {
    private NavigationHelper() {
    }

    public static void addBackToLink(HttpServletRequest request, String link, String label, boolean intraApplication) {
        NavigationHelper.addBackToLink(request, link, label, intraApplication, true);
    }

    public static void addBackToLink(HttpServletRequest request, String link, String theLabel, boolean intraApplication, boolean includeOnExisting) {
        String label;
        Stack<Breadcrumbs> backToStack = NavigationHelper.getStack(request);
        if (null == backToStack) {
            backToStack = new Stack<Breadcrumbs>();
            HttpSession session = request.getSession();
            session.setAttribute("sas.framework.BackURLStack", backToStack);
        }
        if (null == (label = theLabel) || "".equals(label.trim())) {
            label = RB.getString("NavigationUtility.BackLink.txt", FrameworkHelper.getUserLocale(request));
        }
        BackToLink back = new BackToLink(link, label);
        back.setIntraApplication(intraApplication);
        if (includeOnExisting) {
            Breadcrumbs crumbs;
            Breadcrumbs breadcrumbs = crumbs = backToStack.isEmpty() ? null : (Breadcrumbs)backToStack.peek();
            if (null != crumbs) {
                crumbs.add(back);
            } else {
                crumbs = new Breadcrumbs();
                crumbs.add(back);
                backToStack.push(crumbs);
            }
        } else {
            Breadcrumbs crumbs = new Breadcrumbs();
            crumbs.add(back);
            backToStack.push(crumbs);
        }
    }

    public static void removeLastBreadcrumb(HttpServletRequest request) {
        Stack backToStack = NavigationHelper.getStack(request);
        if (null != backToStack) {
            backToStack.pop();
        }
    }

    public static void removeLastLinkFromLastBreadcrumb(HttpServletRequest request) {
        Stack backToStack = NavigationHelper.getStack(request);
        if (null != backToStack) {
            Breadcrumbs crumbs = (Breadcrumbs)backToStack.peek();
            crumbs.getLinks().remove(crumbs.size() - 1);
        }
    }

    private static Stack getStack(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Stack backToStack = (Stack)session.getAttribute("sas.framework.BackURLStack");
        return backToStack;
    }
}

