/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.helpers;

import com.sas.framework.commons.resolvers.LocaleResolverInterface;
import com.sas.framework.commons.resolvers.PreferenceResolverInterface;
import com.sas.framework.commons.resolvers.UserResolverInterface;
import com.sas.framework.config.ApplicationConfiguration;
import com.sas.framework.config.ConfigurationServiceInterface;
import com.sas.framework.config.UrlGeneratorInterface;
import com.sas.framework.webapp.util.URLEncodeUtils;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FrameworkHelper {
    private static final String EQUALS = "=";
    private static final String AMPERSAND = "&";
    private static final Logger LOGGER = LogManager.getLogger(FrameworkHelper.class);
    private static ConfigurationServiceInterface configService;
    private static String compName;

    public static void setConfigurationService(ConfigurationServiceInterface c) {
        configService = c;
    }

    private FrameworkHelper() {
    }

    public static boolean isPortlet(HttpServletRequest request) {
        return null != request.getParameter("sasportal_portletid");
    }

    public static boolean isIncluded(HttpServletRequest request) {
        return FrameworkHelper.isPortlet(request);
    }

    public static boolean isMobile(HttpServletRequest request) {
        return null != request.getAttribute("mobile.device.request");
    }

    public static boolean isAbsolute(HttpServletRequest request) {
        return FrameworkHelper.isPortlet(request) || FrameworkHelper.isIncluded(request);
    }

    public static void setHelpTopic(String topic, HttpServletRequest request) {
        if (null != topic) {
            request.setAttribute("sas.framework.helpTopic", (Object)topic.trim());
        }
    }

    public static void disableAutoLogoff(HttpServletRequest request) {
        request.setAttribute("sas.framework.meta_refresh", (Object)Boolean.FALSE);
    }

    public static void setMetaRefreshInterval(HttpServletRequest request, int i) {
        request.setAttribute("sas.framework.meta_refresh_int", (Object)i);
    }

    public static void setMetaRefreshUrl(HttpServletRequest request, String url) {
        request.setAttribute("sas.framework.meta_refresh_url", (Object)url);
    }

    public static String appendParms(Map map, List invalidList) {
        StringBuilder sb = new StringBuilder();
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (null != invalidList && invalidList.contains(key)) continue;
            sb.append(key).append(EQUALS);
            Object value = map.get(key);
            if (value instanceof String) {
                sb.append(URLEncodeUtils.encodeURL((String)value));
            } else if (value instanceof String[]) {
                String[] values = (String[])value;
                for (int i = 0; i < values.length; ++i) {
                    if (0 != i) {
                        sb.append(AMPERSAND).append(key).append(EQUALS);
                    }
                    sb.append(URLEncodeUtils.encodeURL(values[i]));
                }
            } else {
                sb.append(URLEncodeUtils.encodeURL(String.valueOf(value)));
            }
            if (!it.hasNext()) continue;
            sb.append(AMPERSAND);
        }
        return sb.toString();
    }

    public static void saveAttribute(String key, HttpServletRequest request) {
        FrameworkHelper.saveAttribute(key, null, request);
    }

    public static void saveAttribute(String key, Object theAttribute, HttpServletRequest request) {
        Object attribute = theAttribute;
        HttpSession session = request.getSession();
        if (null == attribute) {
            attribute = request.getAttribute(key);
        }
        session.removeAttribute(key);
        session.setAttribute(key, attribute);
    }

    public static void setLocale(HttpServletRequest request, Locale locale) {
        request.setAttribute("sas.framework.Locale", (Object)locale);
    }

    public static String getApplicationKey(HttpServletRequest request) {
        HttpSession session = request.getSession();
        ServletContext context = session.getServletContext();
        return context.getInitParameter("application-name");
    }

    public static PreferenceResolverInterface getPreferenceResolver(HttpServletRequest request) {
        HttpSession session = request.getSession();
        ServletContext context = session.getServletContext();
        return (PreferenceResolverInterface)context.getAttribute("sas_preference_resolver");
    }

    public static UrlGeneratorInterface getUrlGenerator(HttpServletRequest request) {
        HttpSession session = request.getSession();
        ServletContext context = session.getServletContext();
        return (UrlGeneratorInterface)context.getAttribute("sas_url_generator");
    }

    public static Locale getUserLocale(HttpServletRequest request) {
        HttpSession session = request.getSession();
        ServletContext context = session.getServletContext();
        LocaleResolverInterface lri = (LocaleResolverInterface)context.getAttribute("sas_locale_resolver");
        if (null == lri) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Unable to find locale resolver interface, defaulting to request based locale.");
            }
            return request.getLocale();
        }
        return lri.getUserLocale();
    }

    public static UserResolverInterface getUserResolver(HttpServletRequest request) {
        HttpSession session = request.getSession();
        ServletContext context = session.getServletContext();
        return FrameworkHelper.getUserResolver(context);
    }

    public static UserResolverInterface getUserResolver(ServletContext context) {
        return (UserResolverInterface)context.getAttribute("sas_user_resolver");
    }

    public static Properties getApplicationSettings(HttpServletRequest request) {
        if (null == request) {
            return FrameworkHelper.getApplicationSettings((ServletContext)null);
        }
        return FrameworkHelper.getApplicationSettings(request.getSession().getServletContext());
    }

    public static Properties getApplicationSettings(ServletContext context) {
        if (null != context) {
            Properties settings = (Properties)context.getAttribute("_sas_ApplicationSettings");
            if (null == settings) {
                compName = context.getInitParameter("application-name");
                if (null != compName) {
                    settings = configService.getSettings(compName);
                } else {
                    compName = "this application";
                }
                if (null == settings) {
                    LOGGER.error("Missing configured application settings for " + compName + ".");
                }
            }
            return settings;
        }
        if (null == compName) {
            return new Properties();
        }
        return configService.getSettings(compName);
    }

    public static ApplicationConfiguration getApplicationConfiguration(HttpServletRequest request) {
        return FrameworkHelper.getApplicationConfiguration(request.getSession().getServletContext());
    }

    public static ApplicationConfiguration getApplicationConfiguration(ServletContext context) {
        ApplicationConfiguration config = (ApplicationConfiguration)context.getAttribute("_sas_ApplicationConfiguration");
        if (null == config) {
            String compName = context.getInitParameter("application-name");
            if (null != compName) {
                config = configService.getConfiguration(compName);
            } else {
                compName = "this application";
            }
            if (null == config) {
                LOGGER.error("Missing ApplicationConfiguration for " + compName + ".");
            }
        }
        return config;
    }

    public static String getBaseUrl(HttpServletRequest request) {
        String scheme = request.getScheme();
        String server = request.getServerName();
        int port = request.getServerPort();
        StringBuilder sb = new StringBuilder();
        sb.append(scheme);
        sb.append("://");
        sb.append(server);
        if (port != -1 && 80 != port) {
            sb.append(":").append(port);
        }
        return sb.toString();
    }

    public static String getPath(HttpServletRequest request) {
        return request.getContextPath();
    }

    public static String getContextPath(HttpServletRequest request, boolean requiresBaseUrl) {
        StringBuilder sb = new StringBuilder();
        if (FrameworkHelper.isAbsolute(request) || requiresBaseUrl) {
            sb.append(FrameworkHelper.getBaseUrl(request));
        }
        sb.append(FrameworkHelper.getPath(request));
        if (!FrameworkHelper.getPath(request).endsWith("/")) {
            sb.append("/");
        }
        return sb.toString();
    }

    public static String getContextPath(HttpServletRequest request) {
        return FrameworkHelper.getContextPath(request, false);
    }

    public static String getHelpId(HttpServletRequest request) {
        ArrayList<String> helpids = (ArrayList<String>)request.getAttribute("sas.framework.taglib.HelpTag.ids");
        if (null == helpids) {
            helpids = new ArrayList<String>();
        }
        String id = "help" + Integer.toString(helpids.size());
        helpids.add(id);
        request.setAttribute("sas.framework.taglib.HelpTag.ids", helpids);
        return id;
    }

    public static List getHelpIds(HttpServletRequest request) {
        return (List)request.getAttribute("sas.framework.taglib.HelpTag.ids");
    }
}

