/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.helpers;

import com.sas.framework.themes.client.BrowserType;
import com.sas.servlet.util.ClientInfo;
import jakarta.servlet.http.HttpServletRequest;

public class ClientHelper {
    private ClientHelper() {
    }

    public static BrowserType getBrowserType(HttpServletRequest request) {
        BrowserType retval = BrowserType.UNKNOWN;
        if (request != null) {
            ClientInfo ci = new ClientInfo(request);
            if (ci.isInternetExplorer()) {
                int majorVersion = ClientHelper.getMajorVersion(ci);
                retval = majorVersion <= 6 ? BrowserType.IE6 : BrowserType.IE7;
            } else if (ci.isFirefox()) {
                int majorVersion = ClientHelper.getMajorVersion(ci);
                if (majorVersion < 4) {
                    retval = BrowserType.FF15;
                } else if (majorVersion >= 4) {
                    retval = BrowserType.FF5;
                }
            } else {
                retval = BrowserType.UNKNOWN;
            }
        }
        return retval;
    }

    private static int getMajorVersion(ClientInfo ci) {
        String version = ci.getBrowserVersion();
        int majorVersion = -1;
        if (version.length() > 0) {
            String major = version;
            int dotIndex = version.indexOf(46);
            if (dotIndex > 0) {
                major = version.substring(0, dotIndex);
            }
            majorVersion = Integer.parseInt(major);
        }
        return majorVersion;
    }
}

