/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.discovery;

import com.sas.codepolicy.SASScope;
import com.sas.services.InitializationException;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceException;
import com.sas.services.ServiceProxy;
import com.sas.services.events.broker.EventBrokerServiceInterface;
import com.sas.services.events.discovery.EventBrokerDiscoveryServiceInterface;
import java.io.Serializable;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Set;

@SASScope
public class EventBrokerDiscoveryServiceProxy
extends ServiceProxy
implements EventBrokerDiscoveryServiceInterface,
Serializable {
    private static final long serialVersionUID = -1651816871408385119L;

    public EventBrokerDiscoveryServiceProxy(EventBrokerDiscoveryServiceInterface eventBrokerService) throws InitializationException {
        super((RemoteServiceInterface)eventBrokerService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventBrokerServiceInterface locateBroker(String eventName, int eventType) throws RemoteException {
        EventBrokerServiceInterface eventBrokerService = null;
        EventBrokerDiscoveryServiceInterface service = this.getEventBrokerDiscoveryService();
        RemoteException remoteException = null;
        try {
            eventBrokerService = service.locateBroker(eventName, eventType);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                try {
                    eventBrokerService = this.findEventBrokerDiscoveryService().locateBroker(eventName, eventType);
                }
                catch (ServiceException ex) {
                    throw remoteException;
                }
            }
        }
        return eventBrokerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set locateBrokers(String eventName, int eventType, int requested) throws RemoteException {
        Set eventBrokerServicesSet = null;
        EventBrokerDiscoveryServiceInterface service = this.getEventBrokerDiscoveryService();
        RemoteException remoteException = null;
        try {
            eventBrokerServicesSet = service.locateBrokers(eventName, eventType, requested);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                try {
                    eventBrokerServicesSet = this.findEventBrokerDiscoveryService().locateBrokers(eventName, eventType, requested);
                }
                catch (ServiceException ex) {
                    throw remoteException;
                }
            }
        }
        if (eventBrokerServicesSet == null) {
            eventBrokerServicesSet = new HashSet(0);
        }
        return eventBrokerServicesSet;
    }

    private final EventBrokerDiscoveryServiceInterface getEventBrokerDiscoveryService() {
        return (EventBrokerDiscoveryServiceInterface)this.getService();
    }

    private final EventBrokerDiscoveryServiceInterface findEventBrokerDiscoveryService() throws ServiceException, RemoteException {
        return (EventBrokerDiscoveryServiceInterface)this.findRemoteService();
    }
}

