/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.discovery;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.net.rmi.RemoteObjectExporterInterface;
import com.sas.net.rmi.UnicastRemoteObjectExporter;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.AbstractRemoteService;
import com.sas.services.InitializationException;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.ServiceInitializationObject;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.LocalDiscoveryServiceInterface;
import com.sas.services.discovery.ServiceNotAvailableException;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.discovery.Services;
import com.sas.services.events.broker.EventBrokerServiceInterface;
import com.sas.services.events.discovery.EventBrokerDiscoveryServiceInitObject;
import com.sas.services.events.discovery.EventBrokerDiscoveryServiceInitializer;
import com.sas.services.events.discovery.EventBrokerDiscoveryServiceInterface;
import com.sas.services.events.discovery.EventBrokerDiscoveryServiceProxy;
import com.sas.services.events.discovery.RB;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class EventBrokerDiscoveryService
extends AbstractRemoteService
implements EventBrokerDiscoveryServiceInterface {
    private EventBrokerDiscoveryServiceInitObject _initObject;
    private Logger _logger;
    private static final String RB_KEY = "EventBrokerDiscoveryService.";
    private static ResourceBundle rb = RB.getResources();

    @SASScope
    public EventBrokerDiscoveryService() throws RemoteException, ServiceException {
        this((DiscoveryServiceInterface)DiscoveryService.defaultInstance());
    }

    public EventBrokerDiscoveryService(DiscoveryServiceInterface discoveryService) throws RemoteException, ServiceException {
        super(discoveryService);
        SSLRMISocketFactories sslRMISocketFactories = SSLRMISocketFactories.getInstance();
        Class<?> theClass = this.getClass();
        this.setRemoteableExporter((RemoteObjectExporterInterface)new UnicastRemoteObjectExporter((Remote)((Object)this), sslRMISocketFactories.getPortForClass(0, theClass), sslRMISocketFactories.getRMIClientSocketFactoryForClass(theClass), sslRMISocketFactories.getRMIServerSocketFactoryForClass(theClass), true));
        this._logger = LogManager.getLogger((String)this.getClass().getName());
    }

    @SASScope(value="ALL")
    public EventBrokerDiscoveryService(ServiceConfigurationInterface serviceConfiguration) throws RemoteException, ServiceException {
        this(serviceConfiguration, (DiscoveryServiceInterface)DiscoveryService.defaultInstance());
        this.configure(serviceConfiguration);
    }

    public EventBrokerDiscoveryService(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws RemoteException, ServiceException {
        this(discoveryService);
        this.configure(serviceConfiguration);
        this.bindToDiscoveryService();
    }

    @SASScope
    public void configure(EventBrokerDiscoveryServiceInitObject initObject) throws InitializationException {
        if (initObject != null) {
            this._initObject = initObject;
        }
    }

    @Override
    @SASScope
    public EventBrokerServiceInterface locateBroker(String eventName, int eventType) throws RemoteException {
        EventBrokerServiceInterface eventBrokerService = null;
        Set brokerRefs = this.locateBrokers(eventName, eventType, 1);
        if (brokerRefs.size() > 0) {
            eventBrokerService = (EventBrokerServiceInterface)brokerRefs.iterator().next();
        }
        return eventBrokerService;
    }

    @Override
    @SASScope
    public Set locateBrokers(String eventName, int eventType, int requested) throws RemoteException {
        HashSet<EventBrokerServiceInterface> brokerRefs;
        block14: {
            Class[] service = new Class[]{EventBrokerServiceInterface.class};
            brokerRefs = new HashSet<EventBrokerServiceInterface>(5);
            if (this._logger.isDebugEnabled()) {
                this._logger.debug(MessageFormat.format(rb.getString("EventBrokerDiscoveryService.entered.fmt.txt"), eventName, new Integer(requested)));
            }
            if (requested <= 0) {
                return brokerRefs;
            }
            try {
                LocalDiscoveryServiceInterface discoveryService = DiscoveryService.defaultInstance();
                Services services = discoveryService.findServices(new ServiceTemplate(service, null), requested, null);
                for (EventBrokerServiceInterface eventBrokerService : services) {
                    try {
                        if (!eventBrokerService.canProcess(eventName, eventType)) continue;
                        brokerRefs.add(eventBrokerService);
                        if (!this._logger.isDebugEnabled()) continue;
                        this._logger.debug(rb.getString("EventBrokerDiscoveryService.foundViaDiscovery.txt"));
                    }
                    catch (RemoteException re) {
                        this._logger.error(rb.getString("EventBrokerDiscoveryService.eventBrokerServiceRemoteException.txt"), (Throwable)re);
                    }
                }
            }
            catch (ServiceNotAvailableException snae) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug(MessageFormat.format(rb.getString("EventBrokerDiscoveryService.discoveryServiceNotAvailableException.fmt.txt"), snae.getMessage()));
                }
            }
            catch (Exception e) {
                if (!this._logger.isDebugEnabled()) break block14;
                this._logger.debug(rb.getString("EventBrokerDiscoveryService.discoveryException.txt"), (Throwable)e);
            }
        }
        if (brokerRefs.size() < requested && this._initObject != null) {
            Iterator iterator = this._initObject.getExternalBrokers().iterator();
            while (brokerRefs.size() < requested && iterator.hasNext()) {
                EventBrokerServiceInterface eventBrokerService = (EventBrokerServiceInterface)iterator.next();
                try {
                    if (!eventBrokerService.canProcess(eventName, eventType)) continue;
                    brokerRefs.add(eventBrokerService);
                    if (!this._logger.isDebugEnabled()) continue;
                    this._logger.debug(rb.getString("EventBrokerDiscoveryService.foundOutsideDiscovery.txt"));
                }
                catch (RemoteException re) {
                    this._logger.error(rb.getString("EventBrokerDiscoveryService.eventBrokerServiceRemoteException.txt"), (Throwable)re);
                }
            }
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug(MessageFormat.format(rb.getString("EventBrokerDiscoveryService.leave.fmt.txt"), new Integer(brokerRefs.size())));
        }
        return brokerRefs;
    }

    @SASScope
    public void configure(ServiceConfigurationInterface serviceConfiguration) throws RemoteException, ServiceException {
        super.configure(serviceConfiguration);
        Object object = serviceConfiguration.getInitializationObject();
        try {
            ServiceInitializationObject serviceInitObject = (ServiceInitializationObject)object;
            if (serviceInitObject.getInitializationObject() == null) {
                serviceInitObject.setInitializationObject((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\" ?><!DOCTYPE EventBrokerDiscoveryService><EventBrokers/>");
            }
            EventBrokerDiscoveryServiceInitObject initObject = EventBrokerDiscoveryServiceInitializer.getInitObject(serviceInitObject.getInitializationObject());
            this.configure(initObject);
        }
        catch (ClassCastException e) {
            throw new InitializationException(e.getLocalizedMessage());
        }
    }

    @SASScope
    public final RemoteServiceInterface getServiceProxy() {
        EventBrokerDiscoveryServiceProxy proxy = null;
        try {
            proxy = new EventBrokerDiscoveryServiceProxy(this);
        }
        catch (InitializationException e) {
            proxy = null;
        }
        return proxy;
    }

    @SASScope
    public void destroy() throws ServiceException, RemoteException {
        super.destroy();
        this._logger = null;
    }
}

