/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker.util;

import com.sas.codepolicy.SASScope;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.Text;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope
public class XMLUtil {
    private static final int LENGTH_SOAP_ELEMENT = 256;
    private static final int LENGTH_SOAP_TEXT = 256;
    private static final int LENGTH_SOAP_BODY = 2560;

    public static final SOAPElement convertDOMToSOAP(Node node) throws SOAPException, IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException(com.sas.services.util.XMLUtil.getInvalidArgumentNullMsg());
        }
        return XMLUtil.convertDOMToSOAP(SOAPFactory.newInstance(), node);
    }

    public static final SOAPElement convertDOMToSOAP(SOAPFactory factory, Node node) throws SOAPException, IllegalArgumentException {
        NamedNodeMap map;
        if (node == null) {
            throw new IllegalArgumentException(com.sas.services.util.XMLUtil.getInvalidArgumentNullParameterMsg((Object)"node"));
        }
        if (factory == null) {
            factory = SOAPFactory.newInstance();
        }
        String elementNS = node.getNamespaceURI();
        String elementPrefix = node.getPrefix();
        String elementLocalName = node.getLocalName();
        Name name = null;
        boolean bAddDefaultNS = false;
        if (elementNS == null || elementNS.length() == 0) {
            name = factory.createName(elementLocalName);
        } else if (elementPrefix == null || elementPrefix.length() == 0) {
            name = factory.createName(elementLocalName);
            bAddDefaultNS = true;
        } else {
            name = factory.createName(elementLocalName, elementPrefix, elementNS);
        }
        SOAPElement se = factory.createElement(name);
        if (bAddDefaultNS) {
            se.addNamespaceDeclaration("", elementNS);
        }
        if (node.hasAttributes() && (map = node.getAttributes()) != null) {
            int len = map.getLength();
            for (int i = 0; i < len; ++i) {
                Node attr = map.item(i);
                String attrNS = attr.getNamespaceURI();
                String attrPrefix = attr.getPrefix();
                String attrLocalName = attr.getLocalName();
                String attrValue = attr.getNodeValue();
                if ("xmlns".equals(attrPrefix)) {
                    se.addNamespaceDeclaration(attrLocalName, attrValue);
                    continue;
                }
                if ("xmlns".equals(attrLocalName)) {
                    if (attrValue.equals(elementNS)) continue;
                    se.addNamespaceDeclaration("", attrValue);
                    continue;
                }
                name = attrPrefix == null ? factory.createName(attrLocalName) : factory.createName(attrLocalName, attrPrefix, attrNS);
                se.addAttribute(name, attrValue);
            }
        }
        NodeList nodeList = node.getChildNodes();
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeType() == 3) {
                se.addTextNode(child.getNodeValue());
                continue;
            }
            if (child.getNodeType() != 1) continue;
            se.addChildElement(XMLUtil.convertDOMToSOAP(factory, child));
        }
        return se;
    }

    public static final String convertSOAPToString(SOAPBody body) throws SOAPException, IllegalArgumentException {
        if (body == null) {
            throw new IllegalArgumentException(com.sas.services.util.XMLUtil.getInvalidArgumentNullMsg());
        }
        StringBuffer buf = new StringBuffer(2560);
        Iterator childIter = body.getChildElements();
        while (childIter.hasNext()) {
            Object o = childIter.next();
            if (!(o instanceof SOAPElement)) continue;
            SOAPElement childElement = (SOAPElement)o;
            buf.append(XMLUtil.convertSOAPToString(childElement));
        }
        return buf.toString();
    }

    public static final String convertSOAPToString(SOAPElement element) throws SOAPException, IllegalArgumentException {
        if (element == null) {
            throw new IllegalArgumentException(com.sas.services.util.XMLUtil.getInvalidArgumentNullMsg());
        }
        StringBuffer buf = new StringBuffer(256);
        Name name = element.getElementName();
        buf.append('<');
        buf.append(name.getQualifiedName());
        Iterator prefixIter = element.getNamespacePrefixes();
        String prefix = null;
        String uri = null;
        while (prefixIter.hasNext()) {
            prefix = (String)prefixIter.next();
            uri = element.getNamespaceURI(prefix);
            buf.append(" xmlns:");
            buf.append(prefix);
            com.sas.services.util.XMLUtil.bufferQuotedValue((StringBuffer)buf, (String)uri);
        }
        Iterator attrsIter = element.getAllAttributes();
        while (attrsIter.hasNext()) {
            Name attrName = (Name)attrsIter.next();
            String strAttrName = attrName.getQualifiedName();
            String strAttrValue = element.getAttributeValue(attrName);
            buf.append(' ');
            buf.append(strAttrName);
            com.sas.services.util.XMLUtil.bufferQuotedValue((StringBuffer)buf, (String)strAttrValue);
        }
        buf.append('>');
        StringBuffer textBuffer = new StringBuffer(256);
        Iterator textIter = element.getChildElements();
        while (textIter.hasNext()) {
            Object o = textIter.next();
            if (!(o instanceof Text)) continue;
            Text text = (Text)o;
            textBuffer.append(text.getValue());
        }
        String strText = textBuffer.toString();
        if (strText != null) {
            buf.append(strText);
        }
        Iterator childrenIter = element.getChildElements();
        while (childrenIter.hasNext()) {
            Object o = childrenIter.next();
            if (!(o instanceof SOAPElement)) continue;
            SOAPElement childElement = (SOAPElement)o;
            buf.append(XMLUtil.convertSOAPToString(childElement));
        }
        buf.append("</" + name.getQualifiedName() + '>');
        return buf.toString();
    }
}

