/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker.util;

import com.sas.services.events.broker.util.ActiveTaskElement;
import com.sas.services.events.broker.util.Barrier;
import com.sas.services.events.broker.util.RB;
import com.sas.services.events.broker.util.TaskRunnable;
import com.sas.services.events.broker.util.ThreadPoolException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadPool {
    public static final int MAX_THREADS = 100;
    public static final int MAX_SPARE_THREADS = 25;
    public static final int MIN_SPARE_THREADS = 10;
    private Vector _pool = null;
    private int _maxThreads;
    private int _maxSpareThreads;
    private int _minSpareThreads;
    private int _currentThreads;
    private int _busyThreads;
    private boolean _bEnding;
    Logger _logger = null;
    private SpareThreadController _spareController = null;
    Vector _vActiveThreads = new Vector(100);
    private static final String RB_KEY = "ThreadPool.";
    static ResourceBundle rb = RB.getResources();

    public ThreadPool() {
        this._maxThreads = 100;
        this._maxSpareThreads = 25;
        this._minSpareThreads = 10;
        this._currentThreads = 0;
        this._busyThreads = 0;
        this._bEnding = false;
        this._logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public ThreadPool(int maxThreads, int minSpareThreads) {
        this._logger = LogManager.getLogger((String)this.getClass().getName());
        this.setLimits(maxThreads, minSpareThreads, minSpareThreads);
        this._currentThreads = 0;
        this._busyThreads = 0;
        this._bEnding = false;
    }

    public ThreadPool(int maxThreads, int maxSpareThreads, int minSpareThreads) {
        this._logger = LogManager.getLogger((String)this.getClass().getName());
        this.setLimits(maxThreads, maxSpareThreads, minSpareThreads);
        this._currentThreads = 0;
        this._busyThreads = 0;
        this._bEnding = false;
    }

    public int getMaxThreads() {
        return this._maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.setLimits(maxThreads, this._maxSpareThreads, this._minSpareThreads);
    }

    public int getMaxSpareThreads() {
        return this._maxSpareThreads;
    }

    public void setMaxSpareThreads(int maxSpareThreads) {
        this.setLimits(this._maxThreads, maxSpareThreads, this._minSpareThreads);
    }

    public int getMinSpareThreads() {
        return this._minSpareThreads;
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.setLimits(this._maxThreads, this._maxSpareThreads, minSpareThreads);
    }

    protected synchronized void setLimits(int maxThreads, int maxSpareThreads, int minSpareThreads) {
        if (maxThreads <= 0) {
            maxThreads = 100;
        }
        this._maxThreads = maxThreads;
        if (maxSpareThreads > maxThreads) {
            maxSpareThreads = maxThreads;
        }
        if (maxSpareThreads <= 0) {
            maxSpareThreads = (maxThreads >> 1) + 1;
        }
        this._maxSpareThreads = maxSpareThreads;
        if (minSpareThreads > maxSpareThreads) {
            minSpareThreads = maxSpareThreads;
        }
        if (minSpareThreads <= 0) {
            minSpareThreads = (maxSpareThreads >> 1) + 1;
        }
        this._minSpareThreads = minSpareThreads;
    }

    public synchronized void init() throws ThreadPoolException {
        this.startIdleThreads(this._minSpareThreads);
        this._spareController = new SpareThreadController(this);
    }

    public synchronized void term() {
        this._bEnding = true;
        this._spareController.term();
        for (int i = 0; i < this._currentThreads - this._busyThreads; ++i) {
            IdleRunnable idle = (IdleRunnable)this._pool.elementAt(i);
            idle.term();
        }
        this.notifyAll();
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(MessageFormat.format(rb.getString("ThreadPool.term.fmt.txt"), this._busyThreads));
        }
        this._logger = null;
    }

    protected void startIdleThreads(int idleThreads) throws ThreadPoolException {
        if (this._bEnding) {
            throw new ThreadPoolException(rb.getString("ThreadPool.terminating.ex.txt"));
        }
        if (idleThreads > this._maxThreads) {
            idleThreads = this._maxThreads;
        }
        if (this._pool == null) {
            this._pool = new Vector(idleThreads);
        }
        for (int i = this._currentThreads; i < idleThreads; ++i) {
            this._pool.addElement(new IdleRunnable(this));
        }
        this._currentThreads = idleThreads;
    }

    public void runTask(TaskRunnable task) throws ThreadPoolException {
        this.runTask(task, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTask(TaskRunnable task, Barrier barrier) throws ThreadPoolException {
        IdleRunnable idle;
        if (this._bEnding) {
            throw new ThreadPoolException(rb.getString("ThreadPool.terminating.ex.txt"));
        }
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (this._currentThreads == this._busyThreads) {
                if (this._currentThreads < this._maxThreads) {
                    this.startIdleThreads(this._currentThreads + this._minSpareThreads);
                } else {
                    while (this._currentThreads == this._busyThreads) {
                        block10: {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e) {
                                if (this._logger == null) break block10;
                                this._logger.error(rb.getString("ThreadPool.waitIdleInterrupt.txt"));
                            }
                        }
                        if (!this._bEnding) continue;
                        throw new ThreadPoolException(rb.getString("ThreadPool.terminating.ex.txt"));
                    }
                }
            }
            idle = (IdleRunnable)this._pool.lastElement();
            this._pool.removeElement(idle);
            ++this._busyThreads;
        }
        idle.runTask(task, barrier);
    }

    protected synchronized void endIdleThread() {
        --this._currentThreads;
        --this._busyThreads;
    }

    protected synchronized void endTaskOnIdleThread(IdleRunnable idle) {
        if (this._bEnding) {
            idle.term();
            return;
        }
        --this._busyThreads;
        this._pool.addElement(idle);
        this._spareController.regulate();
        this.notify();
    }

    protected synchronized void regulateSpareThreads() {
        if (this._currentThreads - this._busyThreads > this._maxSpareThreads) {
            int termCount = this._currentThreads - this._busyThreads - this._maxSpareThreads;
            for (int i = 0; i < termCount; ++i) {
                IdleRunnable idle = (IdleRunnable)this._pool.firstElement();
                this._pool.removeElement(idle);
                idle.term();
                --this._currentThreads;
            }
        }
    }

    public Set getActiveTasks() {
        int nActiveThreads = this._vActiveThreads.size();
        HashSet<ActiveTaskElement> activeTasks = new HashSet<ActiveTaskElement>(nActiveThreads);
        for (int i = 0; i < nActiveThreads; ++i) {
            IdleRunnable idle = (IdleRunnable)this._vActiveThreads.elementAt(i);
            Thread t = idle.getThread();
            TaskRunnable task = idle.getTask();
            ActiveTaskElement ate = new ActiveTaskElement(t, task);
            activeTasks.add(ate);
        }
        return activeTasks;
    }

    class SpareThreadController
    implements Runnable {
        ThreadPool p;
        Thread t;
        boolean bRun;
        boolean bKill;

        SpareThreadController(ThreadPool p) {
            this.p = p;
            this.bRun = false;
            this.t = new Thread(this);
            this.t.setDaemon(true);
            this.t.setPriority(4);
            this.t.setName(this.getClass().getName() + '_' + this.t.getName());
            this.t.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block5: while (true) {
                try {
                    while (true) {
                        SpareThreadController spareThreadController = this;
                        synchronized (spareThreadController) {
                            if (!this.bRun && !this.bKill) {
                                this.wait();
                            }
                        }
                        if (this.bKill) break block5;
                        this.p.regulateSpareThreads();
                        this.bRun = false;
                    }
                }
                catch (InterruptedException e) {
                    if (ThreadPool.this._logger == null) continue;
                    ThreadPool.this._logger.error(rb.getString("ThreadPool.runSpareInterrupt.txt"));
                    continue;
                }
                break;
            }
        }

        public synchronized void term() {
            this.bKill = true;
            this.notify();
        }

        public synchronized void regulate() {
            this.bRun = true;
            this.notify();
        }
    }

    class IdleRunnable
    implements Runnable {
        ThreadPool pool;
        Thread t;
        TaskRunnable task;
        Barrier barrier;
        boolean bRun;
        boolean bKill;

        IdleRunnable(ThreadPool pool) {
            this.pool = pool;
            this.task = null;
            this.barrier = null;
            this.bRun = false;
            this.bKill = false;
            this.t = new Thread(this);
            this.t.setDaemon(true);
            this.t.setName(this.getClass().getName() + '_' + this.t.getName());
            this.t.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                IdleRunnable idleRunnable = this;
                synchronized (idleRunnable) {
                    block21: {
                        try {
                            if (!this.bRun && !this.bKill) {
                                this.wait();
                            }
                            if (this.bKill) {
                                break;
                            }
                            if (this.task == null) break block21;
                            try {
                                if (ThreadPool.this._logger != null && ThreadPool.this._logger.isDebugEnabled()) {
                                    ThreadPool.this._logger.debug(MessageFormat.format(rb.getString("ThreadPool.runningTask.fmt.txt"), this.task.toString(), this.t.getName()));
                                }
                                ThreadPool.this._vActiveThreads.add(this);
                                this.task.run();
                                if (ThreadPool.this._logger != null && ThreadPool.this._logger.isDebugEnabled()) {
                                    ThreadPool.this._logger.debug(MessageFormat.format(rb.getString("ThreadPool.finishedTask.fmt.txt"), this.task.toString(), this.t.getName()));
                                }
                            }
                            catch (InterruptedException ie) {
                                if (ThreadPool.this._logger != null) {
                                    ThreadPool.this._logger.error(MessageFormat.format(rb.getString("ThreadPool.taskInterrupted.fmt.txt"), this.task.toString()));
                                }
                                this.pool.endIdleThread();
                                break;
                            }
                            catch (Throwable t) {
                                if (ThreadPool.this._logger != null) {
                                    ThreadPool.this._logger.error(MessageFormat.format(rb.getString("ThreadPool.taskException.fmt.txt"), this.task.toString()), t);
                                }
                                this.pool.endIdleThread();
                                ThreadPool.this._vActiveThreads.remove(this);
                                break;
                            }
                            finally {
                                ThreadPool.this._vActiveThreads.remove(this);
                            }
                        }
                        catch (InterruptedException e) {
                            if (ThreadPool.this._logger == null) break block21;
                            ThreadPool.this._logger.error(rb.getString("ThreadPool.runIdleInterrupt.txt"));
                        }
                    }
                    if (this.bRun) {
                        this.pool.endTaskOnIdleThread(this);
                        this.bRun = false;
                        if (this.barrier != null) {
                            this.barrier.barrierPost();
                        }
                    }
                }
            }
        }

        public synchronized void term() {
            this.bKill = true;
            this.notify();
        }

        public synchronized void runTask(TaskRunnable task) {
            this.runTask(task, null);
        }

        public synchronized void runTask(TaskRunnable task, Barrier barrier) {
            this.task = task;
            this.barrier = barrier;
            this.bRun = true;
            this.notify();
        }

        public Thread getThread() {
            return this.t;
        }

        public TaskRunnable getTask() {
            return this.task;
        }
    }
}

