/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker.monitor;

import com.sas.codepolicy.SASScope;
import com.sas.services.events.broker.monitor.RB;
import com.sas.services.events.broker.monitor.ResponseAgent;
import com.sas.services.events.broker.monitor.ResponseException;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.NoSuchProviderException;
import jakarta.mail.SendFailedException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Logger;

@SASScope
public class MailResponseAgent
implements ResponseAgent {
    static final long serialVersionUID = -3006960421965054578L;
    private String name;
    private Logger logger;
    private String host = null;
    private String port = null;
    private String user = null;
    private String password = null;
    private Message replyMessage = null;
    private boolean bAttachment = false;
    private boolean bDebugSpecified = false;
    private boolean bDebug = false;
    private Session session = null;
    private Transport transport = null;
    private String loggingContext;
    private static final String RB_KEY = "MailResponseAgent.";
    private static ResourceBundle rb = RB.getResources();

    public MailResponseAgent(String name, Map properties, Logger logger) {
        String value;
        this.name = name;
        this.logger = logger;
        this.loggingContext = this.getClass().getName();
        if (properties.containsKey("host")) {
            this.host = (String)properties.get("host");
        }
        if (properties.containsKey("port")) {
            this.port = (String)properties.get("port");
        }
        if (properties.containsKey("user")) {
            this.user = (String)properties.get("user");
        }
        if (properties.containsKey("password")) {
            this.password = (String)properties.get("password");
        }
        this.replyMessage = (Message)properties.get("replyMessage");
        if (properties.containsKey("attachment") && (value = (String)properties.get("attachment")).equals("1")) {
            this.bAttachment = true;
        }
        if (properties.containsKey("debug")) {
            this.bDebugSpecified = true;
            value = (String)properties.get("debug");
            if (value.equals("1")) {
                this.bDebug = true;
            }
        }
    }

    @Override
    public void init() throws ResponseException {
        block18: {
            if (this.replyMessage == null) {
                throw new ResponseException(rb.getString("MailResponseAgent.noReplyMessage.ex.txt"));
            }
            try {
                Properties props;
                try {
                    props = System.getProperties();
                }
                catch (SecurityException se) {
                    if (this.logger != null && this.logger.isDebugEnabled()) {
                        this.logger.debug(MessageFormat.format(rb.getString("MailResponseAgent.securityException.fmt.txt"), this.name));
                    }
                    props = new Properties();
                }
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(MessageFormat.format(rb.getString("MailResponseAgent.getSession.fmt.txt"), this.name));
                }
                this.session = Session.getDefaultInstance((Properties)props, null);
                if (this.bDebugSpecified) {
                    if (this.logger != null && this.logger.isDebugEnabled()) {
                        this.logger.debug(MessageFormat.format(rb.getString("MailResponseAgent.setDebugSession.fmt.txt"), this.name));
                    }
                    this.session.setDebug(this.bDebug);
                }
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(MessageFormat.format(rb.getString("MailResponseAgent.getTransport.fmt.txt"), this.name));
                }
                this.transport = this.session.getTransport("smtp");
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(MessageFormat.format(rb.getString("MailResponseAgent.connectTransport.fmt.txt"), this.name, this.host != null ? 1 : 0, this.host, this.port != null ? 1 : 0, this.port, this.user != null ? 1 : 0, this.user));
                }
                if (this.host != null || this.port != null || this.user != null || this.password != null) {
                    int nPort = -1;
                    if (this.port != null) {
                        try {
                            nPort = Integer.parseInt(this.port);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    this.transport.connect(this.host, nPort, this.user, this.password);
                    break block18;
                }
                this.transport.connect();
            }
            catch (NoSuchProviderException nspe) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("MailResponseAgent.initNoSuchProviderException.fmt.txt"), this.name), (Throwable)nspe);
                }
                throw new ResponseException(rb.getString("MailResponseAgent.initNoSuchProviderException.ex.txt"));
            }
            catch (MessagingException me) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("MailResponseAgent.initMessagingException.fmt.txt"), this.name), (Throwable)me);
                }
                throw new ResponseException(rb.getString("MailResponseAgent.initMessagingException.ex.txt"));
            }
        }
    }

    @Override
    public void sendResponse(String response) throws ResponseException {
        if (this.transport != null) {
            try {
                if (this.bAttachment) {
                    MimeMultipart mp = new MimeMultipart();
                    MimeBodyPart bp1 = new MimeBodyPart();
                    bp1.setContent((Object)"SAS EventBroker response.\nSee attachment for actual broker response.", "text/plain");
                    mp.addBodyPart((BodyPart)bp1);
                    MimeBodyPart bp2 = new MimeBodyPart();
                    bp2.setContent((Object)response, "text/xml");
                    mp.addBodyPart((BodyPart)bp2);
                    this.replyMessage.setContent((Multipart)mp);
                } else {
                    this.replyMessage.setContent((Object)response, "text/xml");
                }
                this.replyMessage.setHeader("X-Mailer", "SAS EventBroker");
                this.replyMessage.setSentDate(new Date());
                this.transport.sendMessage(this.replyMessage, this.replyMessage.getAllRecipients());
            }
            catch (SendFailedException sfe) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("MailResponseAgent.sendResponseSendFailedException.fmt.txt"), this.name), (Object)this.loggingContext, (Object)sfe);
                }
                throw new ResponseException(rb.getString("MailResponseAgent.sendResponseSendFailedException.ex.txt"));
            }
            catch (MessagingException me) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("MailResponseAgent.sendResponseMessagingException.fmt.txt"), this.name), (Object)this.loggingContext, (Object)me);
                }
                throw new ResponseException(rb.getString("MailResponseAgent.sendResponseMessagingException.ex.txt"));
            }
            catch (SecurityException se) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("MailResponseAgent.sendResponseSecurityException.fmt.txt"), this.name), (Object)this.loggingContext, (Object)se);
                }
                throw new ResponseException(rb.getString("MailResponseAgent.sendResponseSecurityException.ex.txt"));
            }
        } else {
            throw new ResponseException(rb.getString("MailResponseAgent.notInitialized.ex.txt"));
        }
    }

    @Override
    public void term() {
        try {
            if (this.transport != null) {
                this.transport.close();
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }
}

