/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker.monitor;

import com.sas.codepolicy.SASScope;
import com.sas.services.events.broker.monitor.RB;
import com.sas.services.events.broker.monitor.ResponseAgent;
import com.sas.services.events.broker.monitor.ResponseException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Logger;

@SASScope
public class MQJMSResponseAgent
implements ResponseAgent {
    static final long serialVersionUID = -5139313884255737986L;
    private String name;
    private Logger logger;
    private String strUser;
    private String strPassword;
    private String strQueue;
    private String strCorrelId;
    private Queue destQueue;
    private Queue queue = null;
    private QueueSession session = null;
    private QueueConnection connection = null;
    private QueueConnectionFactory factory = null;
    private QueueSender sender = null;
    private String loggingContext;
    private static final String RB_KEY = "MQJMSResponseAgent.";
    private static ResourceBundle rb = RB.getResources();

    public MQJMSResponseAgent(String name, Map properties, Logger logger) {
        this.name = name;
        this.logger = logger;
        this.loggingContext = this.getClass().getName();
        if (properties.containsKey("user")) {
            this.strUser = (String)properties.get("user");
        }
        if (properties.containsKey("password")) {
            this.strPassword = (String)properties.get("password");
        }
        this.strQueue = (String)properties.get("reply_to_queue");
        this.destQueue = (Queue)properties.get("reply_to_dest");
        this.strCorrelId = (String)properties.get("replyCorrelId");
        this.factory = (QueueConnectionFactory)properties.get("qcf");
    }

    @Override
    public void init() throws ResponseException {
        if (this.destQueue == null && this.strQueue == null) {
            throw new ResponseException(rb.getString("MQJMSResponseAgent.noReplyQueue.ex.txt"));
        }
        try {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("MQJMSResponseAgent.createQueueConnection.fmt.txt"), this.name), (Object)this.loggingContext);
            }
            this.connection = this.strUser != null && this.strPassword != null ? this.factory.createQueueConnection(this.strUser, this.strPassword) : this.factory.createQueueConnection();
            this.connection.start();
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("MQJMSResponseAgent.createQueueSession.fmt.txt"), this.name), (Object)this.loggingContext);
            }
            this.session = this.connection.createQueueSession(false, 1);
            if (this.destQueue != null) {
                this.queue = this.destQueue;
            } else {
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(MessageFormat.format(rb.getString("MQJMSResponseAgent.createQueue.fmt.txt"), this.name, this.strQueue), (Object)this.loggingContext);
                }
                this.queue = null;
                try {
                    Class<?> qClass = this.getClass().getClassLoader().loadClass("com.ibm.mq.jms.MQQueue");
                    Class[] params = new Class[]{String.class};
                    Object[] args = new Object[]{"queue:///" + this.strQueue};
                    Constructor<?> ctor = qClass.getConstructor(params);
                    ctor.setAccessible(true);
                    this.queue = (Queue)ctor.newInstance(args);
                }
                catch (ClassNotFoundException ex) {
                    if (this.logger != null) {
                        this.logger.error(MessageFormat.format(rb.getString("MQJMSResponseAgent.initJMSException.fmt.txt"), this.name), (Throwable)ex);
                    }
                    throw new ResponseException(rb.getString("MQJMSResponseAgent.initJMSException.ex.txt"));
                }
                catch (NoSuchMethodException ex) {
                    if (this.logger != null) {
                        this.logger.error(MessageFormat.format(rb.getString("MQJMSResponseAgent.initJMSException.fmt.txt"), this.name), (Throwable)ex);
                    }
                    throw new ResponseException(rb.getString("MQJMSResponseAgent.initJMSException.ex.txt"));
                }
                catch (InvocationTargetException ex) {
                    if (this.logger != null) {
                        this.logger.error(MessageFormat.format(rb.getString("MQJMSResponseAgent.initJMSException.fmt.txt"), this.name), (Throwable)ex);
                    }
                    throw new ResponseException(rb.getString("MQJMSResponseAgent.initJMSException.ex.txt"));
                }
                catch (IllegalAccessException ex) {
                    if (this.logger != null) {
                        this.logger.error(MessageFormat.format(rb.getString("MQJMSResponseAgent.initJMSException.fmt.txt"), this.name), (Throwable)ex);
                    }
                    throw new ResponseException(rb.getString("MQJMSResponseAgent.initJMSException.ex.txt"));
                }
                catch (InstantiationException ex) {
                    if (this.logger != null) {
                        this.logger.error(MessageFormat.format(rb.getString("MQJMSResponseAgent.initJMSException.fmt.txt"), this.name), (Throwable)ex);
                    }
                    throw new ResponseException(rb.getString("MQJMSResponseAgent.initJMSException.ex.txt"));
                }
            }
            try {
                Class[] params = new Class[]{Integer.TYPE};
                Object[] args = new Object[]{1};
                Method method = this.queue.getClass().getDeclaredMethod("setTargetClient", params);
                method.setAccessible(true);
                method.invoke((Object)this.queue, args);
                params = new Class[]{String.class};
                args = new Object[]{"SAS EventBrokerService response."};
                method = this.queue.getClass().getDeclaredMethod("setDescription", params);
                method.setAccessible(true);
                method.invoke((Object)this.queue, args);
            }
            catch (IllegalAccessException ex) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("MQJMSResponseAgent.initJMSException.fmt.txt"), this.name), (Throwable)ex);
                }
                throw new ResponseException(rb.getString("MQJMSResponseAgent.initJMSException.ex.txt"));
            }
            catch (NoSuchMethodException ex) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("MQJMSResponseAgent.initJMSException.fmt.txt"), this.name), (Throwable)ex);
                }
                throw new ResponseException(rb.getString("MQJMSResponseAgent.initJMSException.ex.txt"));
            }
            catch (InvocationTargetException ex) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("MQJMSResponseAgent.initJMSException.fmt.txt"), this.name), (Throwable)ex);
                }
                throw new ResponseException(rb.getString("MQJMSResponseAgent.initJMSException.ex.txt"));
            }
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("MQJMSResponseAgent.createSender.fmt.txt"), this.name), (Object)this.loggingContext);
            }
            this.sender = this.session.createSender(this.queue);
        }
        catch (JMSException je) {
            if (this.logger != null) {
                this.logger.error(MessageFormat.format(rb.getString("MQJMSResponseAgent.initJMSException.fmt.txt"), this.name), (Object)this.loggingContext, (Object)je);
            }
            throw new ResponseException(rb.getString("MQJMSResponseAgent.initJMSException.ex.txt"));
        }
    }

    @Override
    public void sendResponse(String response) throws ResponseException {
        if (this.sender != null) {
            try {
                TextMessage message;
                block7: {
                    message = this.session.createTextMessage(response);
                    try {
                        if (this.strCorrelId != null) {
                            message.setJMSCorrelationID(this.strCorrelId);
                        }
                    }
                    catch (JMSException je) {
                        if (this.logger == null) break block7;
                        this.logger.error(MessageFormat.format(rb.getString("MQJMSResponseAgent.failedSetMessageID.fmt.txt"), this.name), (Object)this.loggingContext, (Object)je);
                    }
                }
                this.sender.send((Message)message);
            }
            catch (JMSException je) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("MQJMSResponseAgent.sendResponseJMSException.fmt.txt"), this.name), (Object)this.loggingContext, (Object)je);
                }
                throw new ResponseException(rb.getString("MQJMSResponseAgent.sendResponseJMSException.ex.txt"));
            }
        }
        throw new ResponseException(rb.getString("MQJMSResponseAgent.notInitialized.ex.txt"));
    }

    @Override
    public void term() {
        try {
            if (this.sender != null) {
                this.sender.close();
            }
            if (this.session != null) {
                this.session.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }
}

