/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker.monitor;

import com.sas.codepolicy.SASScope;
import com.sas.services.events.broker.monitor.RB;
import com.sas.services.events.broker.monitor.ResponseAgent;
import com.sas.services.events.broker.monitor.ResponseException;
import com.sun.messaging.Queue;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Logger;

@SASScope
public class JMQResponseAgent
implements ResponseAgent {
    static final long serialVersionUID = 6577139921000392809L;
    private String name;
    private Logger logger;
    private String strUser;
    private String strPassword;
    private String strQueue;
    private String strCorrelId;
    private jakarta.jms.Queue destQueue;
    private jakarta.jms.Queue queue = null;
    private QueueSession session = null;
    private QueueConnection connection = null;
    private QueueConnectionFactory factory = null;
    private QueueSender sender = null;
    private String loggingContext;
    private static final String RB_KEY = "JMQResponseAgent.";
    private static ResourceBundle rb = RB.getResources();

    public JMQResponseAgent(String name, Map properties, Logger logger) {
        this.name = name;
        this.logger = logger;
        this.loggingContext = this.getClass().getName();
        if (properties.containsKey("user")) {
            this.strUser = (String)properties.get("user");
        }
        if (properties.containsKey("password")) {
            this.strPassword = (String)properties.get("password");
        }
        this.strQueue = (String)properties.get("reply_to_queue");
        this.destQueue = (jakarta.jms.Queue)properties.get("reply_to_dest");
        this.strCorrelId = (String)properties.get("replyCorrelId");
        this.factory = (QueueConnectionFactory)properties.get("qcf");
    }

    @Override
    public void init() throws ResponseException {
        if (this.destQueue == null && this.strQueue == null) {
            throw new ResponseException(rb.getString("JMQResponseAgent.noReplyQueue.ex.txt"));
        }
        try {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("JMQResponseAgent.createQueueConnection.fmt.txt"), this.name), (Object)this.loggingContext);
            }
            this.connection = this.strUser != null && this.strPassword != null ? this.factory.createQueueConnection(this.strUser, this.strPassword) : this.factory.createQueueConnection();
            this.connection.start();
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("JMQResponseAgent.createQueueSession.fmt.txt"), this.name), (Object)this.loggingContext);
            }
            this.session = this.connection.createQueueSession(false, 1);
            if (this.destQueue != null) {
                this.queue = this.destQueue;
            } else {
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(MessageFormat.format(rb.getString("JMQResponseAgent.createQueue.fmt.txt"), this.name, this.strQueue), (Object)this.loggingContext);
                }
                this.queue = new Queue(this.strQueue);
            }
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("JMQResponseAgent.createSender.fmt.txt"), this.name), (Object)this.loggingContext);
            }
            this.sender = this.session.createSender(this.queue);
        }
        catch (JMSException je) {
            if (this.logger != null) {
                this.logger.error(MessageFormat.format(rb.getString("JMQResponseAgent.initJMSException.fmt.txt"), this.name), (Object)this.loggingContext, (Object)je);
            }
            throw new ResponseException(rb.getString("JMQResponseAgent.initJMSException.ex.txt"));
        }
    }

    @Override
    public void sendResponse(String response) throws ResponseException {
        if (this.sender != null) {
            try {
                TextMessage message;
                block7: {
                    message = this.session.createTextMessage(response);
                    try {
                        if (this.strCorrelId != null) {
                            message.setJMSCorrelationID(this.strCorrelId);
                        }
                    }
                    catch (JMSException je) {
                        if (this.logger == null) break block7;
                        this.logger.error(MessageFormat.format(rb.getString("JMQResponseAgent.failedSetMessageID.fmt.txt"), this.name), (Object)this.loggingContext, (Object)je);
                    }
                }
                this.sender.send((Message)message);
            }
            catch (JMSException je) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("JMQResponseAgent.sendResponseJMSException.fmt.txt"), this.name), (Object)this.loggingContext, (Object)je);
                }
                throw new ResponseException(rb.getString("JMQResponseAgent.sendResponseJMSException.ex.txt"));
            }
        }
        throw new ResponseException(rb.getString("JMQResponseAgent.notInitialized.ex.txt"));
    }

    @Override
    public void term() {
        try {
            if (this.sender != null) {
                this.sender.close();
            }
            if (this.session != null) {
                this.session.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }
}

