/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker.monitor;

import com.sas.codepolicy.SASScope;
import com.sas.services.events.broker.monitor.HTTPResponseAgent;
import com.sas.services.events.broker.monitor.ResponseAgent;
import com.sas.services.events.broker.monitor.ResponseException;
import com.sas.services.events.broker.util.XMLUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;

@SASScope
public class HTTPSoapResponseAgent
extends HTTPResponseAgent
implements ResponseAgent {
    static final long serialVersionUID = -5701212138708258986L;
    public static final char COLON = ':';
    public static final char COMMA = ',';
    public static final String CRLF = "\r\n";
    private static final String RB_KEY = "HTTPSoapResponseAgent.";

    public HTTPSoapResponseAgent(String name, Map properties, Logger logger) {
        super(name, properties, logger);
    }

    @Override
    public void sendResponse(String response) throws ResponseException {
        if (this.out != null) {
            try {
                MessageFactory mf = MessageFactory.newInstance();
                SOAPMessage sm = mf.createMessage();
                SOAPPart sp = sm.getSOAPPart();
                SOAPEnvelope envelope = sp.getEnvelope();
                envelope.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                envelope.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
                envelope.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
                SOAPBody body = envelope.getBody();
                if (response.length() > 0) {
                    Document doc = com.sas.services.util.XMLUtil.convertStringToDocument((String)response);
                    SOAPElement element = XMLUtil.convertDOMToSOAP(doc.getDocumentElement());
                    body.addChildElement(element);
                }
                StringBuffer sb = new StringBuffer();
                sb.append("HTTP/1.0 200 OK");
                sb.append(CRLF);
                String s = sb.toString();
                byte[] b = s.getBytes();
                this.out.write(b, 0, b.length);
                sm.saveChanges();
                MimeHeaders headers = sm.getMimeHeaders();
                Iterator it = headers.getAllHeaders();
                while (it.hasNext()) {
                    MimeHeader header = (MimeHeader)it.next();
                    sb = new StringBuffer();
                    sb.append(header.getName());
                    sb.append(':');
                    sb.append(" ");
                    String[] values = headers.getHeader(header.getName());
                    int i = 0;
                    while (i < values.length) {
                        if (i != 0) {
                            sb.append(',');
                        }
                        sb.append(values[i++]);
                    }
                    sb.append(CRLF);
                    s = sb.toString();
                    b = s.getBytes();
                    this.out.write(b, 0, b.length);
                }
                b = CRLF.getBytes();
                this.out.write(b, 0, b.length);
                sm.writeTo((OutputStream)this.out);
                this.out.flush();
            }
            catch (IOException ioe) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("HTTPResponseAgent.sendResponseIOException.fmt.txt"), this.name), (Object)this.loggingContext, (Object)ioe);
                }
                throw new ResponseException(rb.getString("HTTPResponseAgent.sendResponseIOException.ex.txt"));
            }
            catch (Throwable t) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("HTTPSoapResponseAgent.soapResponseException.fmt.txt"), this.name), (Object)this.loggingContext, (Object)t);
                }
                throw new ResponseException(rb.getString("HTTPSoapResponseAgent.soapResponseException.ex.txt"));
            }
        }
    }
}

