/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker.monitor;

import com.sas.codepolicy.SASScope;
import com.sas.services.events.EventFactory;
import com.sas.services.events.EventInterface;
import com.sas.services.events.broker.monitor.HTTPMonitor;
import com.sas.services.events.broker.monitor.HTTPSoapResponseAgent;
import com.sas.services.events.broker.monitor.Monitor;
import com.sas.services.events.broker.util.EventRequest;
import com.sas.services.events.broker.util.MutexStateException;
import com.sas.services.events.broker.util.XMLUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.soap.Text;

@SASScope
public class HTTPSoapMonitor
extends HTTPMonitor
implements Monitor {
    public static final String FAULT_CODE_CLIENT = "soap-env:Client";
    public static final String FAULT_CODE_SERVER = "soap-env:Server";
    private static final String RB_KEY = "HTTPSoapMonitor.";

    @Override
    protected Runnable getListener() {
        return new HTTPSoapListener();
    }

    @SASScope
    protected class HTTPSoapListener
    implements Runnable {
        private String strEvent = null;

        protected HTTPSoapListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Socket socket = null;
            EventRequest eventRequest = null;
            try {
                socket = HTTPSoapMonitor.this.server.accept();
            }
            catch (IOException ioe) {
                if (ioe.toString().indexOf("socket closed") != -1) {
                    if (HTTPSoapMonitor.this.logger != null && HTTPSoapMonitor.this.logger.isDebugEnabled()) {
                        HTTPSoapMonitor.this.logger.debug(MessageFormat.format(HTTPMonitor.rb.getString("HTTPMonitor.listenerShutdown.fmt.txt"), HTTPSoapMonitor.this.name));
                    }
                } else if (HTTPSoapMonitor.this.logger != null) {
                    HTTPSoapMonitor.this.logger.error(MessageFormat.format(HTTPMonitor.rb.getString("HTTPMonitor.runListenerIOException.fmt.txt"), HTTPSoapMonitor.this.name), (Throwable)ioe);
                }
                return;
            }
            HTTPSoapMonitor.this.incrementListeners();
            HTTPSoapMonitor.this.startListener(HTTPSoapMonitor.this.getListener());
            try {
                block31: {
                    HTTPMonitor.HttpInputStream is = new HTTPMonitor.HttpInputStream(socket.getInputStream());
                    this.strEvent = this.parseHttp(is);
                    if (this.strEvent == null || this.strEvent.length() <= 0) {
                        return;
                    }
                    if (HTTPSoapMonitor.this.logger != null && HTTPSoapMonitor.this.logger.isDebugEnabled()) {
                        HTTPSoapMonitor.this.logger.debug(MessageFormat.format(HTTPMonitor.rb.getString("HTTPMonitor.receivedEvent.fmt.txt"), HTTPSoapMonitor.this.name, this.strEvent));
                    }
                    HTTPSoapMonitor.this.responseProperties.put("replyToSocket", socket);
                    HTTPSoapResponseAgent responseAgent = new HTTPSoapResponseAgent(HTTPSoapMonitor.this.name, HTTPSoapMonitor.this.responseProperties, HTTPSoapMonitor.this.logger);
                    eventRequest = new EventRequest(this.strEvent, responseAgent);
                    if (HTTPSoapMonitor.this.defaultEvent != null) {
                        eventRequest.setDefaultEvent(HTTPSoapMonitor.this.defaultEvent);
                    }
                    eventRequest.setReplyRequired();
                    try {
                        HTTPSoapMonitor.this.eventContainer._mutex.lock();
                    }
                    catch (InterruptedException ie) {
                        if (HTTPSoapMonitor.this.logger == null) break block31;
                        HTTPSoapMonitor.this.logger.error(MessageFormat.format(HTTPMonitor.rb.getString("HTTPMonitor.mutexInterrupt.fmt.txt"), HTTPSoapMonitor.this.name));
                    }
                }
                while (HTTPSoapMonitor.this.eventContainer.isFull()) {
                    try {
                        HTTPSoapMonitor.this.eventContainer._monitorCV.condWait(HTTPSoapMonitor.this.eventContainer._mutex);
                    }
                    catch (InterruptedException ie) {
                        if (HTTPSoapMonitor.this.logger == null) continue;
                        HTTPSoapMonitor.this.logger.error(MessageFormat.format(HTTPMonitor.rb.getString("HTTPMonitor.condWaitInterrupt.fmt.txt"), HTTPSoapMonitor.this.name));
                    }
                }
                HTTPSoapMonitor.this.eventContainer.add(eventRequest);
                try {
                    HTTPSoapMonitor.this.eventContainer._mutex.unlock();
                }
                catch (MutexStateException ie) {
                    // empty catch block
                }
                HTTPSoapMonitor.this.eventContainer._workerCV.condSignal();
            }
            catch (Throwable t) {
                if (HTTPSoapMonitor.this.logger != null) {
                    HTTPSoapMonitor.this.logger.error(MessageFormat.format(HTTPMonitor.rb.getString("HTTPMonitor.runListenerException.fmt.txt"), HTTPSoapMonitor.this.name), t);
                }
                SOAPMessage fault = this.createFault(t);
                if (socket != null) {
                    try {
                        OutputStream out = socket.getOutputStream();
                        String s = "HTTP/1.0 500  Internal Server Error\r\n";
                        out.write(s.getBytes());
                        fault.saveChanges();
                        MimeHeaders headers = fault.getMimeHeaders();
                        Iterator it = headers.getAllHeaders();
                        while (it.hasNext()) {
                            MimeHeader header = (MimeHeader)it.next();
                            String[] values = headers.getHeader(header.getName());
                            if (values.length == 1) {
                                s = header.getName() + String.valueOf(':') + header.getValue() + "\r\n";
                                out.write(s.getBytes());
                                continue;
                            }
                            StringBuffer concat = new StringBuffer();
                            int i = 0;
                            while (i < values.length) {
                                if (i != 0) {
                                    concat.append(',');
                                }
                                concat.append(values[i++]);
                            }
                            s = header.getName() + String.valueOf(':') + concat.toString() + "\r\n";
                            out.write(s.getBytes());
                        }
                        out.write("\r\n".getBytes());
                        fault.writeTo(out);
                        out.flush();
                        socket.close();
                    }
                    catch (Throwable e) {
                        if (HTTPSoapMonitor.this.logger != null) {
                            HTTPSoapMonitor.this.logger.error(MessageFormat.format(HTTPMonitor.rb.getString("HTTPSoapMonitor.soapFaultException.fmt.txt"), HTTPSoapMonitor.this.name), e);
                        }
                    }
                }
            }
            finally {
                HTTPSoapMonitor.this.decrementListeners();
            }
        }

        private String parseHttp(HTTPMonitor.HttpInputStream is) throws IOException, SOAPException {
            Object o;
            String strEvent = "";
            is.readRequest();
            MimeHeaders headers = is.readHeaders();
            BufferedInputStream bis = new BufferedInputStream(is);
            ((InputStream)bis).mark(1);
            byte[] buf = new byte[3];
            byte[] BOM = new byte[]{-17, -69, -65};
            try {
                ((InputStream)bis).read(buf, 0, 3);
                if (buf[0] != BOM[0] || buf[1] != BOM[1] || buf[2] != BOM[2]) {
                    ((InputStream)bis).reset();
                }
            }
            catch (Throwable t) {
                ((InputStream)bis).reset();
            }
            MessageFactory msgFactory = MessageFactory.newInstance();
            SOAPMessage sm = msgFactory.createMessage(headers, (InputStream)bis);
            SOAPPart sp = sm.getSOAPPart();
            SOAPEnvelope envelope = sp.getEnvelope();
            SOAPBody body = envelope.getBody();
            SOAPElement eventElement = null;
            String eventName = null;
            Name name = envelope.createName("Event", "sas-event", "http://www.sas.com/xml/namespace/services.events-1.1");
            Iterator eventIter = body.getChildElements(name);
            if (eventIter.hasNext() && (o = eventIter.next()) instanceof SOAPElement) {
                eventElement = (SOAPElement)o;
                name = envelope.createName("name", "sas-event", "http://www.sas.com/xml/namespace/services.events-1.1");
                eventName = eventElement.getAttributeValue(name);
            }
            if (eventName == null) {
                strEvent = XMLUtil.convertSOAPToString(body);
            } else {
                EventFactory ef = new EventFactory();
                EventInterface event = ef.newEvent(eventName);
                this.parseHeaders(eventElement, event);
                this.parseBody(eventElement, event);
                strEvent = (String)event.serialize(0);
            }
            return strEvent;
        }

        private void parseHeaders(SOAPElement eventElement, EventInterface event) throws SOAPException {
            Object o;
            SOAPFactory sf = SOAPFactory.newInstance();
            Name name = sf.createName("Header", "sas-event", "http://www.sas.com/xml/namespace/services.events-1.1");
            Iterator headerIter = eventElement.getChildElements(name);
            if (headerIter.hasNext() && (o = headerIter.next()) instanceof SOAPElement) {
                SOAPElement headerElement = (SOAPElement)o;
                Iterator childIter = headerElement.getChildElements();
                block4: while (childIter.hasNext()) {
                    Iterator attrIter;
                    String value;
                    o = childIter.next();
                    if (!(o instanceof SOAPElement)) continue;
                    SOAPElement childElement = (SOAPElement)o;
                    name = childElement.getElementName();
                    if (name.getLocalName().equals("Version") && "http://www.sas.com/xml/namespace/services.events-1.1".equals(name.getURI())) {
                        value = childElement.getValue();
                        if (value == null) continue;
                        try {
                            double version = Double.parseDouble(value);
                            event.setVersion(version);
                        }
                        catch (NumberFormatException version) {}
                        continue;
                    }
                    if (name.getLocalName().equals("Identity") && "http://www.sas.com/xml/namespace/services.events-1.1".equals(name.getURI())) {
                        value = childElement.getValue();
                        if (value == null) continue;
                        event.setIdentity(value);
                        continue;
                    }
                    if (name.getLocalName().equals("Priority") && "http://www.sas.com/xml/namespace/services.events-1.1".equals(name.getURI())) {
                        value = childElement.getValue();
                        if (value == null) continue;
                        try {
                            int priority = Integer.parseInt(value);
                            event.setPriority(priority);
                        }
                        catch (NumberFormatException priority) {}
                        continue;
                    }
                    if (name.getLocalName().equals("SentFrom") && "http://www.sas.com/xml/namespace/services.events-1.1".equals(name.getURI())) {
                        value = childElement.getValue();
                        if (value == null) continue;
                        event.setFrom(value);
                        continue;
                    }
                    if (name.getLocalName().equals("SentAt") && "http://www.sas.com/xml/namespace/services.events-1.1".equals(name.getURI())) {
                        value = childElement.getValue();
                        if (value == null) continue;
                        event.setTime(value);
                        continue;
                    }
                    if (name.getLocalName().equals("Credentials") && "http://www.sas.com/xml/namespace/services.events-1.1".equals(name.getURI())) {
                        String user = "";
                        String pass = "";
                        String domain = "";
                        attrIter = childElement.getAllAttributes();
                        while (attrIter.hasNext()) {
                            name = (Name)attrIter.next();
                            if (name.getLocalName().equals("name") && "http://www.sas.com/xml/namespace/services.events-1.1".equals(name.getURI())) {
                                user = childElement.getAttributeValue(name);
                                continue;
                            }
                            if (name.getLocalName().equals("password") && "http://www.sas.com/xml/namespace/services.events-1.1".equals(name.getURI())) {
                                pass = childElement.getAttributeValue(name);
                                continue;
                            }
                            if (!name.getLocalName().equals("domain") || !"http://www.sas.com/xml/namespace/services.events-1.1".equals(name.getURI())) continue;
                            domain = childElement.getAttributeValue(name);
                        }
                        event.setCredentials(user, pass, domain);
                        continue;
                    }
                    if (name.getLocalName().equals("Response") && "http://www.sas.com/xml/namespace/services.events-1.1".equals(name.getURI())) {
                        attrIter = childElement.getAllAttributes();
                        while (attrIter.hasNext()) {
                            name = (Name)attrIter.next();
                            if (!name.getLocalName().equals("type") || !"http://www.sas.com/xml/namespace/services.events-1.1".equals(name.getURI())) continue;
                            event.setResponseType(childElement.getAttributeValue(name));
                            continue block4;
                        }
                        continue;
                    }
                    if (!name.getLocalName().equals("Properties") || !"http://www.sas.com/xml/namespace/services.events-1.1".equals(name.getURI())) continue;
                    HashMap<String, String> properties = new HashMap<String, String>();
                    Iterator propertyIter = childElement.getChildElements();
                    while (propertyIter.hasNext()) {
                        o = propertyIter.next();
                        if (!(o instanceof SOAPElement)) continue;
                        SOAPElement propertyElement = (SOAPElement)o;
                        name = propertyElement.getElementName();
                        properties.put(name.getURI() + ':' + name.getLocalName(), propertyElement.getValue());
                    }
                    if (properties.size() <= 0) continue;
                    event.setProperties(properties);
                }
            }
        }

        private void parseBody(SOAPElement eventElement, EventInterface event) throws SOAPException {
            Object o;
            SOAPFactory sf = SOAPFactory.newInstance();
            StringBuffer strBuf = new StringBuffer();
            Name name = sf.createName("Body", "sas-event", "http://www.sas.com/xml/namespace/services.events-1.1");
            Iterator bodyIter = eventElement.getChildElements(name);
            if (bodyIter.hasNext() && (o = bodyIter.next()) instanceof SOAPElement) {
                SOAPElement bodyElement = (SOAPElement)o;
                Iterator childIter = bodyElement.getChildElements();
                while (childIter.hasNext()) {
                    o = childIter.next();
                    if (o instanceof SOAPElement) {
                        SOAPElement childElement = (SOAPElement)o;
                        strBuf.append(XMLUtil.convertSOAPToString(childElement));
                        continue;
                    }
                    if (!(o instanceof Text)) continue;
                    Text childText = (Text)o;
                    strBuf.append(childText.getValue());
                }
                event.setBody(strBuf.toString());
            }
        }

        private SOAPMessage createFault(Throwable t) {
            SOAPMessage faultMessage = null;
            try {
                MessageFactory mf = MessageFactory.newInstance();
                faultMessage = mf.createMessage();
                SOAPPart sp = faultMessage.getSOAPPart();
                SOAPEnvelope envelope = sp.getEnvelope();
                envelope.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                envelope.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
                SOAPHeader header = envelope.getHeader();
                header.detachNode();
                SOAPBody body = envelope.getBody();
                SOAPFault fault = body.addFault();
                fault.setFaultCode(HTTPSoapMonitor.FAULT_CODE_SERVER);
                fault.setFaultActor(HTTPMonitor.rb.getString("HTTPSoapMonitor.soapFaultActor.txt"));
                fault.setFaultString(HTTPMonitor.rb.getString("HTTPSoapMonitor.soapFaultString.txt"));
                Detail detail = fault.addDetail();
                Name name = envelope.createName("Error", "sas-event", "http://www.sas.com/xml/namespace/services.events-1.1");
                DetailEntry detailEntry = detail.addDetailEntry(name);
                name = envelope.createName("Description");
                detailEntry.addAttribute(name, t.getMessage());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return faultMessage;
        }
    }
}

