/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker.monitor;

import com.sas.codepolicy.SASScope;
import com.sas.services.events.broker.monitor.RB;
import com.sas.services.events.broker.monitor.ResponseAgent;
import com.sas.services.events.broker.monitor.ResponseException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Logger;

@SASScope
public class HTTPResponseAgent
implements ResponseAgent {
    static final long serialVersionUID = 881626801307763276L;
    protected String name;
    protected Logger logger;
    protected transient Socket socket = null;
    protected transient BufferedOutputStream out = null;
    protected String loggingContext;
    protected static final String RB_KEY = "HTTPResponseAgent.";
    protected static ResourceBundle rb = RB.getResources();

    public HTTPResponseAgent(String name, Map properties, Logger logger) {
        this.name = name;
        this.logger = logger;
        this.loggingContext = this.getClass().getName();
        this.socket = (Socket)properties.get("replyToSocket");
    }

    @Override
    public void init() throws ResponseException {
        if (this.socket == null) {
            throw new ResponseException(rb.getString("HTTPResponseAgent.noReplySocket.ex.txt"));
        }
        try {
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
        }
        catch (IOException ioe) {
            if (this.logger != null) {
                this.logger.error(MessageFormat.format(rb.getString("HTTPResponseAgent.initIOException.fmt.txt"), this.name), (Object)this.loggingContext, (Object)ioe);
            }
            throw new ResponseException(rb.getString("HTTPResponseAgent.initIOException.ex.txt"));
        }
    }

    @Override
    public void sendResponse(String response) throws ResponseException {
        if (this.out != null) {
            try {
                if (response.equals("")) {
                    String s = "HTTP/1.0 204 No Content\r\n\r\n";
                    byte[] b = s.getBytes();
                    this.out.write(b, 0, b.length);
                } else {
                    String s = "HTTP/1.0 200 OK\r\n";
                    byte[] b = s.getBytes();
                    this.out.write(b, 0, b.length);
                    StringBuffer sb = new StringBuffer();
                    sb.append("Content-Length: ");
                    sb.append(response.length());
                    sb.append("\r\n");
                    s = sb.toString();
                    s = "Content-Type: text/xml\r\n\r\n";
                    b = s.getBytes();
                    this.out.write(b, 0, b.length);
                    b = response.getBytes();
                    this.out.write(b, 0, b.length);
                }
                this.out.flush();
            }
            catch (IOException ioe) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("HTTPResponseAgent.sendResponseIOException.fmt.txt"), this.name), (Object)this.loggingContext, (Object)ioe);
                }
                throw new ResponseException(rb.getString("HTTPResponseAgent.sendResponseIOException.ex.txt"));
            }
        }
    }

    @Override
    public void term() {
        block2: {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                if (this.logger == null) break block2;
                this.logger.error(MessageFormat.format(rb.getString("HTTPResponseAgent.termIOException.fmt.txt"), this.name), (Object)this.loggingContext, (Object)e);
            }
        }
    }
}

