/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker.flowengine;

import com.sas.codepolicy.SASScope;
import com.sas.services.events.broker.Message;
import com.sas.services.events.broker.flowengine.FlowNode;
import com.sas.services.events.broker.flowengine.NodeInput;
import com.sas.services.events.broker.flowengine.NodeOutput;
import com.sas.services.events.broker.flowengine.ProcessNodeException;
import com.sas.services.events.broker.flowengine.ProcessNodeHandlerInterface;
import com.sas.services.events.broker.flowengine.RB;
import com.sas.services.util.XMLUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import org.apache.logging.log4j.Logger;

@SASScope
public class RuntimeFlowNode
extends FlowNode {
    private Map _runtimeMessages = new HashMap();
    private Map _outputMap = new HashMap();
    private Set _predecessorNodes = new HashSet();
    private Set _successorNodes = new HashSet();
    private Logger _logger;
    private String _loggingContext;
    private int _executionInstances = 0;
    private Map _threads = Collections.synchronizedMap(new HashMap());
    private static final String RB_KEY = "RuntimeFlowNode.";
    private static ResourceBundle rb = RB.getResources();

    public RuntimeFlowNode(String id, String name, String desc, String className, boolean bStart, Set inputs, Set outputs, Map attributes, Set predecessors, Set successors, Logger logger) {
        this._id = id;
        this._name = name;
        this._desc = desc;
        this._className = className;
        this._bStart = bStart;
        this._inputs = inputs;
        this._outputs = outputs;
        this._attributes = attributes;
        this._predecessors = predecessors;
        this._successors = successors;
        this._logger = logger;
        this._loggingContext = this.getClass().getName();
    }

    public boolean isOutputValid(String outputName) {
        boolean valid = false;
        for (NodeOutput nodeOutput : this._outputs) {
            if (!outputName.equals(nodeOutput.getName())) continue;
            valid = true;
            break;
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire(ProcessNodeHandlerInterface handler) {
        try {
            block28: {
                String msg;
                String message;
                String clazz;
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                TimeZone utc = TimeZone.getTimeZone("UTC");
                formatter.setTimeZone(utc);
                String startTime = formatter.format(new Date());
                this._threads.put(Thread.currentThread(), startTime);
                HashSet<Message> inputMessages = new HashSet<Message>();
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    this._logger.debug(MessageFormat.format(rb.getString("RuntimeFlowNode.beginFiring.fmt.txt"), this._name, Thread.currentThread().getName()), (Object)this._loggingContext);
                }
                if (this._bStart) {
                    List messages = (List)this._runtimeMessages.values().iterator().next();
                    Message message2 = (Message)messages.iterator().next();
                    messages.remove(message2);
                    Message copy = (Message)message2.clone();
                    inputMessages.add(copy);
                } else {
                    List messages;
                    boolean bMissingRequiredInput = false;
                    String inputName = null;
                    String sourceNodeName = null;
                    String uniqueName = null;
                    for (NodeInput nodeInput : this._inputs) {
                        inputName = nodeInput.getName();
                        sourceNodeName = nodeInput.getSourceNodeName();
                        uniqueName = inputName + '.' + sourceNodeName;
                        messages = (List)this._runtimeMessages.get(uniqueName);
                        if (messages != null && !messages.isEmpty() || !nodeInput.isRequired()) continue;
                        bMissingRequiredInput = true;
                        break;
                    }
                    if (bMissingRequiredInput) {
                        if (this._logger != null && this._logger.isDebugEnabled()) {
                            this._logger.debug(MessageFormat.format(rb.getString("RuntimeFlowNode.missingReqInput.fmt.txt"), this._name, inputName), (Object)this._loggingContext);
                        }
                        return;
                    }
                    for (NodeInput nodeInput : this._inputs) {
                        inputName = nodeInput.getName();
                        sourceNodeName = nodeInput.getSourceNodeName();
                        uniqueName = inputName + '.' + sourceNodeName;
                        messages = (List)this._runtimeMessages.get(uniqueName);
                        if (messages == null || messages.isEmpty()) continue;
                        Message message3 = (Message)messages.iterator().next();
                        messages.remove(message3);
                        Message copy = (Message)message3.clone();
                        inputMessages.add(copy);
                    }
                }
                try {
                    if (this._logger != null && this._logger.isInfoEnabled()) {
                        this._logger.info(MessageFormat.format(rb.getString("RuntimeFlowNode.executeProcessNode.fmt.txt"), this._processNode.toString(), Thread.currentThread().getName()), (Object)this._loggingContext);
                    }
                    this._processNode.execute(inputMessages, this._attributes, handler);
                    if (this._logger != null && this._logger.isInfoEnabled()) {
                        this._logger.info(MessageFormat.format(rb.getString("RuntimeFlowNode.endProcessNode.fmt.txt"), this._processNode.toString(), Thread.currentThread().getName()), (Object)this._loggingContext);
                    }
                }
                catch (ProcessNodeException pe) {
                    if (this._logger != null) {
                        this._logger.error(rb.getString("RuntimeFlowNode.executeProcessNodeException.txt"), (Object)this._loggingContext, (Object)pe);
                    }
                    try {
                        if (handler.isResponseRequired()) {
                            clazz = pe.getClass().getName();
                            message = "";
                            msg = pe.getMessage();
                            if (msg != null) {
                                message = XMLUtil.normalize((String)msg);
                            }
                            handler.setResponse("<sas-event:Exception sas-event:class=\"" + clazz + "\" " + "sas-event:" + "message=\"" + message + "\" />");
                        }
                    }
                    catch (Throwable e) {
                        if (this._logger != null) {
                            this._logger.error(e.getMessage(), (Object)this._loggingContext, (Object)e);
                        }
                    }
                }
                catch (Throwable t) {
                    if (this._logger != null) {
                        this._logger.error(rb.getString("RuntimeFlowNode.executeException.txt"), (Object)this._loggingContext, (Object)t);
                    }
                    try {
                        if (handler.isResponseRequired()) {
                            clazz = t.getClass().getName();
                            message = "";
                            msg = t.getMessage();
                            if (msg != null) {
                                message = XMLUtil.normalize((String)msg);
                            }
                            handler.setResponse("<sas-event:Exception sas-event:class=\"" + clazz + "\" " + "sas-event:" + "message=\"" + message + "\" />");
                        }
                    }
                    catch (Throwable e) {
                        if (this._logger == null) break block28;
                        this._logger.error(e.getMessage(), (Object)this._loggingContext, (Object)e);
                    }
                }
            }
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug(MessageFormat.format(rb.getString("RuntimeFlowNode.endFiring.fmt.txt"), this._name, Thread.currentThread().getName()), (Object)this._loggingContext);
            }
        }
        finally {
            this._threads.remove(Thread.currentThread());
        }
    }

    public void addOutputMapping(String outputName, RuntimeFlowNode node) {
        HashSet<RuntimeFlowNode> inputNodes = (HashSet<RuntimeFlowNode>)this._outputMap.get(outputName);
        if (inputNodes == null) {
            inputNodes = new HashSet<RuntimeFlowNode>();
            this._outputMap.put(outputName, inputNodes);
        }
        inputNodes.add(node);
    }

    public void addPredecessorNode(RuntimeFlowNode node) {
        this._predecessorNodes.add(node);
    }

    public void addSuccessorNode(RuntimeFlowNode node) {
        this._successorNodes.add(node);
    }

    public void setRuntimeMessage(Message message) {
        String messageName = message.getMessageName();
        String sourceNodeName = message.getSourceNodeName();
        String uniqueName = messageName + '.' + sourceNodeName;
        ArrayList<Message> messages = (ArrayList<Message>)this._runtimeMessages.get(uniqueName);
        if (messages == null) {
            messages = new ArrayList<Message>();
            this._runtimeMessages.put(uniqueName, messages);
        }
        messages.add(message);
    }

    public String getDeadMessages() {
        StringBuffer deadMessages = new StringBuffer();
        for (String input : this._runtimeMessages.keySet()) {
            List messages = (List)this._runtimeMessages.get(input);
            if (messages.isEmpty()) continue;
            deadMessages.append(MessageFormat.format(rb.getString("RuntimeFlowNode.deadMessage.fmt.txt"), input, messages.size()));
        }
        return deadMessages.toString();
    }

    public final Map getOutputMap() {
        return this._outputMap;
    }

    public final Set getPredecessorNodes() {
        return this._predecessorNodes;
    }

    public final Set getSuccessorNodes() {
        return this._successorNodes;
    }

    synchronized void incrementUsageCount() {
        ++this._executionInstances;
    }

    synchronized void decrementUsageCount() {
        --this._executionInstances;
    }

    synchronized boolean isExecuting() {
        boolean bExecuting = false;
        if (this._executionInstances > 0) {
            bExecuting = true;
        }
        return bExecuting;
    }

    boolean isPredExecuting() {
        boolean bExecuting = false;
        HashSet processedNodes = new HashSet();
        Iterator predIter = this._predecessorNodes.iterator();
        while (predIter.hasNext() && !bExecuting) {
            RuntimeFlowNode predNode = (RuntimeFlowNode)predIter.next();
            if (predNode.isExecuting()) {
                bExecuting = true;
                continue;
            }
            bExecuting = this.isPredExecuting(predNode, processedNodes);
        }
        return bExecuting;
    }

    private boolean isPredExecuting(RuntimeFlowNode node, Set processedNodes) {
        boolean bExecuting = false;
        processedNodes.add(node);
        Iterator predIter = node.getPredecessorNodes().iterator();
        while (predIter.hasNext() && !bExecuting) {
            RuntimeFlowNode predNode = (RuntimeFlowNode)predIter.next();
            if (predNode.isExecuting()) {
                bExecuting = true;
                continue;
            }
            if (processedNodes.contains(predNode)) continue;
            bExecuting = this.isPredExecuting(predNode, processedNodes);
        }
        return bExecuting;
    }

    final Map getThreads() {
        return this._threads;
    }
}

