/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker.flowengine;

import com.sas.codepolicy.SASScope;
import com.sas.services.InitializationException;
import com.sas.services.events.ApplicationMonitorResources;
import com.sas.services.events.broker.Message;
import com.sas.services.events.broker.MessageInterface;
import com.sas.services.events.broker.flowengine.EventProcessor;
import com.sas.services.events.broker.flowengine.FlowNode;
import com.sas.services.events.broker.flowengine.InvalidOutputException;
import com.sas.services.events.broker.flowengine.NodeInput;
import com.sas.services.events.broker.flowengine.NodeOutput;
import com.sas.services.events.broker.flowengine.ProcessFlow;
import com.sas.services.events.broker.flowengine.ProcessNodeHandlerInterface;
import com.sas.services.events.broker.flowengine.RB;
import com.sas.services.events.broker.flowengine.RuntimeFlowNode;
import com.sas.services.events.broker.flowengine.RuntimeOutput;
import com.sas.services.events.broker.util.ActiveNodeElement;
import com.sas.services.events.broker.util.EventRequest;
import com.sas.services.events.broker.util.TaskRunnable;
import com.sas.services.events.broker.util.ThreadPool;
import com.sas.services.security.GetSubject;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import javax.security.auth.Subject;
import org.w3c.dom.DocumentFragment;

@SASScope
public class RuntimeFlow
extends EventProcessor
implements TaskRunnable {
    private static final long serialVersionUID = 1L;
    ProcessFlow _processFlow;
    private ThreadPool _tp;
    private Set _runtimeNodes = new HashSet();
    private RuntimeFlowNode _startingNode = null;
    List _runtimeOutputs = Collections.synchronizedList(new ArrayList());
    RuntimeFlow _self;
    private static final String RB_KEY = "RuntimeFlow.";
    static ResourceBundle rb = RB.getResources();

    public RuntimeFlow(ProcessFlow processFlow, EventRequest eventRequest, Message secureMessage, ThreadPool tp) throws IllegalArgumentException, RemoteException {
        super(eventRequest, secureMessage, RuntimeFlow.class);
        if (processFlow == null || tp == null) {
            throw new IllegalArgumentException();
        }
        this._processFlow = processFlow;
        this._tp = tp;
        this._self = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws InterruptedException {
        block52: {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            TimeZone utc = TimeZone.getTimeZone("UTC");
            formatter.setTimeZone(utc);
            this._startTime = formatter.format(new Date());
            if (this._applicationMonitorLogger != null && this._applicationMonitorLogger.isLoggingEnabled()) {
                this._applicationMonitorLogger.log(ApplicationMonitorResources.COLUMN_ACTION, ApplicationMonitorResources.ACTION_FLOW_START, ApplicationMonitorResources.COLUMN_EVENT_NAME, this._eventRequest.getEventName(), ApplicationMonitorResources.COLUMN_HANDLER_NAME, this._processFlow.getName(), ApplicationMonitorResources.COLUMN_INFORMATION, "");
            }
            if (this._logger != null && this._logger.isInfoEnabled()) {
                this._logger.info(MessageFormat.format(rb.getString("RuntimeFlow.start.fmt.txt"), this._processFlow.getName(), Thread.currentThread().getName()));
            }
            if (this._eventRequest.getPriority() != 5) {
                try {
                    if (this._logger != null && this._logger.isDebugEnabled()) {
                        this._logger.debug(MessageFormat.format(rb.getString("RuntimeFlow.adjustPriority.fmt.txt"), this._eventRequest.getPriority()));
                    }
                    Thread.currentThread().setPriority(this._eventRequest.getPriority());
                }
                catch (IllegalArgumentException ie) {
                    if (this._logger != null) {
                        this._logger.error(MessageFormat.format(rb.getString("RuntimeFlow.adjustPriorityIllegalArgumentException.fmt.txt"), ie.getMessage()));
                    }
                }
                catch (SecurityException se) {
                    if (this._logger == null) break block52;
                    this._logger.error(MessageFormat.format(rb.getString("RuntimeFlow.adjustPrioritySecurityException.fmt.txt"), se.getMessage()));
                }
            }
        }
        try {
            this.readyForRuntime();
            if (this._startingNode != null) {
                this._startingNode.setRuntimeMessage(this._message);
                this.fireNode(this._startingNode);
            }
            this.fireNodes();
        }
        catch (InitializationException ie) {
            block54: {
                try {
                    if (this._logger == null) break block54;
                    this._logger.error(MessageFormat.format(rb.getString("RuntimeFlow.readyForRuntimeInitializationException.fmt.txt"), ie.getMessage()));
                }
                catch (Throwable throwable) {
                    this.replyToOriginator(MessageFormat.format(rb.getString("RuntimeFlow.providerName.fmt.txt"), this._processFlow.getName()));
                    this.reportDeadMessages();
                    SessionContextInterface sc = this._message.getSecurityContext().getSessionContext();
                    if (sc != null) {
                        Map sessionMap;
                        Map map = sessionMap = this._eventRequest.getSessionContextUsage();
                        synchronized (map) {
                            Object o = sessionMap.get(sc);
                            if (o instanceof Integer) {
                                Integer usageCount = (Integer)o;
                                int i = usageCount;
                                if (--i == 0) {
                                    block56: {
                                        try {
                                            Object sendersLock;
                                            SessionContextInterface sendersSessionContext = this._eventRequest.getSecurityContext().getSessionContext();
                                            if (sc == sendersSessionContext && (sendersLock = this._eventRequest.getSecurityContext().getSessionContextLock()) != null) {
                                                sc.unlock(sendersLock);
                                            }
                                            sc.destroy();
                                        }
                                        catch (Throwable t) {
                                            if (this._logger == null) break block56;
                                            this._logger.warn(MessageFormat.format(rb.getString("RuntimeFlow.destroySCException.fmt.txt"), t.getClass().getName() + ": " + t.getMessage()));
                                        }
                                    }
                                    sessionMap.remove(sc);
                                } else {
                                    sessionMap.put(sc, i);
                                }
                            }
                        }
                    }
                    if (Thread.currentThread().getPriority() != 5) {
                        Thread.currentThread().setPriority(5);
                    }
                    if (this._applicationMonitorLogger != null && this._applicationMonitorLogger.isLoggingEnabled()) {
                        this._applicationMonitorLogger.log(ApplicationMonitorResources.COLUMN_ACTION, ApplicationMonitorResources.ACTION_FLOW_END, ApplicationMonitorResources.COLUMN_EVENT_NAME, this._eventRequest.getEventName(), ApplicationMonitorResources.COLUMN_HANDLER_NAME, this._processFlow.getName(), ApplicationMonitorResources.COLUMN_INFORMATION, "");
                    }
                    this._applicationMonitorLogger = null;
                    if (this._logger != null && this._logger.isInfoEnabled()) {
                        this._logger.info(MessageFormat.format(rb.getString("RuntimeFlow.end.fmt.txt"), this._processFlow.getName(), Thread.currentThread().getName()));
                    }
                    this._logger = null;
                    throw throwable;
                }
            }
            this.replyToOriginator(MessageFormat.format(rb.getString("RuntimeFlow.providerName.fmt.txt"), this._processFlow.getName()));
            this.reportDeadMessages();
            SessionContextInterface sc = this._message.getSecurityContext().getSessionContext();
            if (sc != null) {
                Map sessionMap;
                Map map = sessionMap = this._eventRequest.getSessionContextUsage();
                synchronized (map) {
                    Object o = sessionMap.get(sc);
                    if (o instanceof Integer) {
                        Integer usageCount = (Integer)o;
                        int i = usageCount;
                        if (--i == 0) {
                            block55: {
                                try {
                                    Object sendersLock;
                                    SessionContextInterface sendersSessionContext = this._eventRequest.getSecurityContext().getSessionContext();
                                    if (sc == sendersSessionContext && (sendersLock = this._eventRequest.getSecurityContext().getSessionContextLock()) != null) {
                                        sc.unlock(sendersLock);
                                    }
                                    sc.destroy();
                                }
                                catch (Throwable t) {
                                    if (this._logger == null) break block55;
                                    this._logger.warn(MessageFormat.format(rb.getString("RuntimeFlow.destroySCException.fmt.txt"), t.getClass().getName() + ": " + t.getMessage()));
                                }
                            }
                            sessionMap.remove(sc);
                        } else {
                            sessionMap.put(sc, i);
                        }
                    }
                }
            }
            if (Thread.currentThread().getPriority() != 5) {
                Thread.currentThread().setPriority(5);
            }
            if (this._applicationMonitorLogger != null && this._applicationMonitorLogger.isLoggingEnabled()) {
                this._applicationMonitorLogger.log(ApplicationMonitorResources.COLUMN_ACTION, ApplicationMonitorResources.ACTION_FLOW_END, ApplicationMonitorResources.COLUMN_EVENT_NAME, this._eventRequest.getEventName(), ApplicationMonitorResources.COLUMN_HANDLER_NAME, this._processFlow.getName(), ApplicationMonitorResources.COLUMN_INFORMATION, "");
            }
            this._applicationMonitorLogger = null;
            if (this._logger != null && this._logger.isInfoEnabled()) {
                this._logger.info(MessageFormat.format(rb.getString("RuntimeFlow.end.fmt.txt"), this._processFlow.getName(), Thread.currentThread().getName()));
            }
            this._logger = null;
        }
        this.replyToOriginator(MessageFormat.format(rb.getString("RuntimeFlow.providerName.fmt.txt"), this._processFlow.getName()));
        this.reportDeadMessages();
        SessionContextInterface sc = this._message.getSecurityContext().getSessionContext();
        if (sc != null) {
            Map sessionMap;
            Map map = sessionMap = this._eventRequest.getSessionContextUsage();
            synchronized (map) {
                Object o = sessionMap.get(sc);
                if (o instanceof Integer) {
                    Integer usageCount = (Integer)o;
                    int i = usageCount;
                    if (--i == 0) {
                        block53: {
                            try {
                                Object sendersLock;
                                SessionContextInterface sendersSessionContext = this._eventRequest.getSecurityContext().getSessionContext();
                                if (sc == sendersSessionContext && (sendersLock = this._eventRequest.getSecurityContext().getSessionContextLock()) != null) {
                                    sc.unlock(sendersLock);
                                }
                                sc.destroy();
                            }
                            catch (Throwable t) {
                                if (this._logger == null) break block53;
                                this._logger.warn(MessageFormat.format(rb.getString("RuntimeFlow.destroySCException.fmt.txt"), t.getClass().getName() + ": " + t.getMessage()));
                            }
                        }
                        sessionMap.remove(sc);
                    } else {
                        sessionMap.put(sc, i);
                    }
                }
            }
        }
        if (Thread.currentThread().getPriority() != 5) {
            Thread.currentThread().setPriority(5);
        }
        if (this._applicationMonitorLogger != null && this._applicationMonitorLogger.isLoggingEnabled()) {
            this._applicationMonitorLogger.log(ApplicationMonitorResources.COLUMN_ACTION, ApplicationMonitorResources.ACTION_FLOW_END, ApplicationMonitorResources.COLUMN_EVENT_NAME, this._eventRequest.getEventName(), ApplicationMonitorResources.COLUMN_HANDLER_NAME, this._processFlow.getName(), ApplicationMonitorResources.COLUMN_INFORMATION, "");
        }
        this._applicationMonitorLogger = null;
        if (this._logger != null && this._logger.isInfoEnabled()) {
            this._logger.info(MessageFormat.format(rb.getString("RuntimeFlow.end.fmt.txt"), this._processFlow.getName(), Thread.currentThread().getName()));
        }
        this._logger = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodes() throws InterruptedException {
        while (!this._runtimeOutputs.isEmpty() || this._processFlow.isAsyncMode() && this.isNodeExecuting()) {
            if (Thread.interrupted()) {
                this.interruptNodes();
                throw new InterruptedException();
            }
            boolean bNothingProcessedThisGoAround = true;
            Object object = this._runtimeOutputs;
            synchronized (object) {
                for (RuntimeOutput runtimeOutput : this._runtimeOutputs) {
                    Message message;
                    runtimeOutput = this.getNextRuntimeOutput(runtimeOutput, null);
                    RuntimeFlowNode node = runtimeOutput.getNode();
                    if (this._processFlow.isAsyncMode() && node.isPredExecuting()) continue;
                    bNothingProcessedThisGoAround = false;
                    this._runtimeOutputs.remove(runtimeOutput);
                    while ((message = runtimeOutput.getMessage()) != null) {
                        node.setRuntimeMessage(message);
                    }
                    if (Thread.interrupted()) {
                        this.interruptNodes();
                        throw new InterruptedException();
                    }
                    this.fireNode(node);
                    break;
                }
            }
            if (!this._processFlow.isAsyncMode() || !bNothingProcessedThisGoAround) continue;
            object = this._self;
            synchronized (object) {
                if (this.isNodeExecuting()) {
                    try {
                        this._self.wait();
                    }
                    catch (InterruptedException ie) {
                        this.interruptNodes();
                        throw ie;
                    }
                }
            }
        }
    }

    private void fireNode(RuntimeFlowNode node) {
        FireNodeRunnable runnable = new FireNodeRunnable(node);
        node.incrementUsageCount();
        if (this._processFlow.isAsyncMode()) {
            try {
                this._tp.runTask(runnable);
            }
            catch (Throwable t) {
                node.decrementUsageCount();
            }
        } else {
            try {
                runnable.run();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void readyForRuntime() throws InitializationException {
        for (FlowNode node : this._processFlow.getNodes().values()) {
            RuntimeFlowNode runtimeNode = new RuntimeFlowNode(node.getId(), node.getName(), node.getDesc(), node.getClassName(), node.isStart(), node.getInputs(), node.getOutputs(), node.getAttributes(), node.getPredecessors(), node.getSuccessors(), this._logger);
            runtimeNode.instantiate();
            this._runtimeNodes.add(runtimeNode);
            if (!runtimeNode.isStart()) continue;
            this._startingNode = runtimeNode;
        }
        for (FlowNode node : this._runtimeNodes) {
            for (NodeOutput output : node.getOutputs()) {
                String id = output.getId();
                String outputName = output.getName();
                block3: for (RuntimeFlowNode inputNode : this._runtimeNodes) {
                    if (inputNode == node) continue;
                    for (NodeInput input : inputNode.getInputs()) {
                        if (!input.getId().equals(id)) continue;
                        ((RuntimeFlowNode)node).addOutputMapping(outputName, inputNode);
                        continue block3;
                    }
                }
            }
        }
        for (FlowNode node : this._runtimeNodes) {
            block6: for (String predId : node.getPredecessors()) {
                for (RuntimeFlowNode predNode : this._runtimeNodes) {
                    if (predNode == node || !predId.equals(predNode.getId())) continue;
                    ((RuntimeFlowNode)node).addPredecessorNode(predNode);
                    continue block6;
                }
            }
        }
        for (FlowNode node : this._runtimeNodes) {
            block9: for (String succId : node.getSuccessors()) {
                for (RuntimeFlowNode succNode : this._runtimeNodes) {
                    if (succNode == node || !succId.equals(succNode.getId())) continue;
                    ((RuntimeFlowNode)node).addSuccessorNode(succNode);
                    continue block9;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RuntimeOutput getNextRuntimeOutput(RuntimeOutput runtimeOutput, Set processedOutputs) {
        if (processedOutputs == null) {
            processedOutputs = new HashSet<RuntimeOutput>();
        }
        processedOutputs.add(runtimeOutput);
        RuntimeFlowNode node = runtimeOutput.getNode();
        List list = this._runtimeOutputs;
        synchronized (list) {
            for (RuntimeOutput predRuntimeOutput : this._runtimeOutputs) {
                RuntimeFlowNode predRuntimeNode;
                if (processedOutputs.contains(predRuntimeOutput) || !this.isPredecessor(node, predRuntimeNode = predRuntimeOutput.getNode(), null)) continue;
                runtimeOutput = this.getNextRuntimeOutput(predRuntimeOutput, processedOutputs);
                break;
            }
        }
        return runtimeOutput;
    }

    private void reportDeadMessages() {
        for (RuntimeFlowNode node : this._runtimeNodes) {
            String deadMessages = node.getDeadMessages();
            if (deadMessages.length() <= 0 || this._logger == null || !this._logger.isWarnEnabled()) continue;
            this._logger.warn(MessageFormat.format(rb.getString("RuntimeFlow.deadMessages.fmt.txt"), node.getName(), deadMessages));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RuntimeOutput searchForRuntimeOutput(RuntimeFlowNode runtimeNode) {
        RuntimeOutput runtimeOutput = null;
        List list = this._runtimeOutputs;
        synchronized (list) {
            for (RuntimeOutput tmpRuntimeOutput : this._runtimeOutputs) {
                if (!tmpRuntimeOutput.getNode().equals(runtimeNode)) continue;
                runtimeOutput = tmpRuntimeOutput;
                break;
            }
        }
        return runtimeOutput;
    }

    private boolean isNodeExecuting() {
        boolean bExecuting = false;
        for (RuntimeFlowNode node : this._runtimeNodes) {
            if (!node.isExecuting()) continue;
            bExecuting = true;
            break;
        }
        return bExecuting;
    }

    private boolean isPredecessor(RuntimeFlowNode node1, RuntimeFlowNode node2, Set processedNodes) {
        boolean bPredecessor = false;
        if (processedNodes == null) {
            processedNodes = new HashSet<RuntimeFlowNode>();
        }
        processedNodes.add(node1);
        Iterator predIter = node1.getPredecessorNodes().iterator();
        while (predIter.hasNext() && !bPredecessor) {
            RuntimeFlowNode pred = (RuntimeFlowNode)predIter.next();
            if (pred == node2) {
                bPredecessor = true;
                continue;
            }
            if (processedNodes.contains(pred)) continue;
            bPredecessor = this.isPredecessor(pred, node2, processedNodes);
        }
        return bPredecessor;
    }

    public String getFlowName() {
        return this._processFlow.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCurrentFiringNodes() {
        ArrayList<ActiveNodeElement> anes = new ArrayList<ActiveNodeElement>();
        for (RuntimeFlowNode node : this._runtimeNodes) {
            Map threads;
            if (!node.isExecuting()) continue;
            Map map = threads = node.getThreads();
            synchronized (map) {
                Iterator threadsIter = threads.entrySet().iterator();
                Map.Entry mapEntry = null;
                while (threadsIter.hasNext()) {
                    mapEntry = threadsIter.next();
                    Thread t = (Thread)mapEntry.getKey();
                    String startTime = (String)mapEntry.getValue();
                    ActiveNodeElement ane = new ActiveNodeElement(t, node.getName(), startTime);
                    anes.add(ane);
                }
            }
        }
        return anes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptNodes() {
        if (this._processFlow.isAsyncMode()) {
            for (RuntimeFlowNode node : this._runtimeNodes) {
                Map threads;
                if (!node.isExecuting()) continue;
                Map map = threads = node.getThreads();
                synchronized (map) {
                    for (Thread t : threads.keySet()) {
                        t.interrupt();
                    }
                }
            }
        }
    }

    @SASScope
    class FireNodeRunnable
    implements TaskRunnable {
        RuntimeFlowNode _node;

        FireNodeRunnable(RuntimeFlowNode node) throws IllegalArgumentException {
            if (node == null) {
                throw new IllegalArgumentException();
            }
            this._node = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block19: {
                Serializable runAsContext;
                try {
                    runAsContext = RuntimeFlow.this._message.getSecurityContext();
                    if (runAsContext.getRunAsIdentity() == 0) {
                        this._node.fire(new ProcessNodeHandler(this._node));
                        break block19;
                    }
                    try {
                        Subject subject = GetSubject.getSubject((UserContextInterface)runAsContext.getUserContext());
                        Subject.doAsPrivileged(subject, new PrivilegedAction(){

                            public Object run() {
                                FireNodeRunnable.this._node.fire(new ProcessNodeHandler(FireNodeRunnable.this._node));
                                return null;
                            }
                        }, null);
                    }
                    catch (Throwable t) {
                        if (RuntimeFlow.this._logger != null) {
                            RuntimeFlow.this._logger.error(MessageFormat.format(rb.getString("RuntimeFlow.securityException.fmt.txt"), t.getClass().getName() + ": " + t.getMessage()));
                        }
                    }
                }
                catch (Throwable t) {
                    RuntimeFlow.this._logger.error((Object)t);
                }
                finally {
                    this._node.decrementUsageCount();
                    if (RuntimeFlow.this._processFlow.isAsyncMode()) {
                        runAsContext = RuntimeFlow.this._self;
                        synchronized (runAsContext) {
                            RuntimeFlow.this._self.notify();
                        }
                    }
                }
            }
        }
    }

    @SASScope
    class ProcessNodeHandler
    implements ProcessNodeHandlerInterface {
        private RuntimeFlowNode _node;

        ProcessNodeHandler(RuntimeFlowNode node) {
            if (node == null) {
                throw new IllegalArgumentException();
            }
            this._node = node;
        }

        @Override
        public void propagate(String name, MessageInterface messageIf) throws InvalidOutputException {
            if (RuntimeFlow.this._logger != null && RuntimeFlow.this._logger.isDebugEnabled()) {
                RuntimeFlow.this._logger.debug(MessageFormat.format(rb.getString("RuntimeFlow.propagate.fmt.txt"), name != null ? 1 : 0, name, this._node.getName()));
            }
            if (name == null || name.length() == 0) {
                throw new InvalidOutputException(rb.getString("RuntimeFlow.invalidOutputName.ex.txt"));
            }
            if (!this._node.isOutputValid(name)) {
                throw new InvalidOutputException(rb.getString("RuntimeFlow.invalidPropagation.ex.txt"));
            }
            if (!(messageIf instanceof Message)) {
                throw new InvalidOutputException(rb.getString("RuntimeFlow.invalidOutputType.ex.txt"));
            }
            Message message = (Message)messageIf;
            message = (Message)message.clone();
            message.setMessageName(name);
            message.setSourceNodeName(this._node.getName());
            Set nodesToFire = (Set)this._node.getOutputMap().get(name);
            if (nodesToFire != null) {
                for (RuntimeFlowNode node : nodesToFire) {
                    RuntimeOutput runtimeOutput = RuntimeFlow.this.searchForRuntimeOutput(node);
                    if (runtimeOutput == null) {
                        runtimeOutput = new RuntimeOutput(node, message);
                        RuntimeFlow.this._runtimeOutputs.add(runtimeOutput);
                        continue;
                    }
                    runtimeOutput.addMessage(message);
                }
            }
        }

        @Override
        public Object getOwningBroker() throws RemoteException {
            return RuntimeFlow.this._eventRequest.getOwningBroker();
        }

        @Override
        public boolean isResponseRequired() throws RemoteException {
            return RuntimeFlow.this._self.isResponseRequired();
        }

        @Override
        public void setResponse(String response) throws RemoteException {
            RuntimeFlow.this._self.setResponse(response);
        }

        @Override
        public void setResponse(DocumentFragment response) throws RemoteException {
            RuntimeFlow.this._self.setResponse(response);
        }

        @Override
        public void setResponse(Object response) throws RemoteException {
            RuntimeFlow.this._self.setResponse(response);
        }

        @Override
        public void log(String message) throws RemoteException {
            RuntimeFlow.this._self.log(message);
        }
    }
}

