/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker.flowengine;

import com.sas.codepolicy.SASScope;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.events.broker.Message;
import com.sas.services.events.broker.SecurityContext;
import com.sas.services.events.broker.flowengine.RB;
import com.sas.services.events.broker.flowengine.ResponseHandlerInterface;
import com.sas.services.events.broker.monitor.ResponseAgent;
import com.sas.services.events.broker.monitor.ResponseException;
import com.sas.services.events.broker.util.EventRequest;
import com.sas.services.logging.util.LoggerMonitor2;
import com.sas.services.util.XMLUtil;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

@SASScope
public abstract class EventProcessor
extends UnicastRemoteObject
implements ResponseHandlerInterface {
    protected EventRequest _eventRequest;
    protected Message _message;
    protected Logger _logger;
    protected LoggerMonitor2 _applicationMonitorLogger;
    protected String _startTime;
    private List _responses = Collections.synchronizedList(new ArrayList());
    private static final String RB_KEY = "EventProcessor.";
    private static ResourceBundle rb = RB.getResources();

    public abstract void run() throws InterruptedException;

    public EventProcessor() throws RemoteException {
        this(EventProcessor.class);
    }

    protected EventProcessor(Class theClass) throws RemoteException {
        super(SSLRMISocketFactories.getInstance().getPortForClass(0, theClass), SSLRMISocketFactories.getInstance().getRMIClientSocketFactoryForClass(theClass), SSLRMISocketFactories.getInstance().getRMIServerSocketFactoryForClass(theClass));
    }

    public EventProcessor(EventRequest eventRequest, Message secureMessage) throws IllegalArgumentException, RemoteException {
        this(eventRequest, secureMessage, EventProcessor.class);
    }

    protected EventProcessor(EventRequest eventRequest, Message secureMessage, Class theClass) throws RemoteException {
        this(theClass);
        if (eventRequest == null) {
            throw new IllegalArgumentException();
        }
        this._eventRequest = eventRequest;
        this._message = secureMessage != null ? secureMessage : eventRequest.getMessage();
        SecurityContext securityContext = this._message.getSecurityContext();
        this._logger = LogManager.getLogger((String)this.getClass().getName());
        this._applicationMonitorLogger = new LoggerMonitor2(LogManager.getLogger((String)"ApplicationMonitor.EventBrokerService"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replyToOriginator(String serviceProvider) {
        EventRequest eventRequest = this._eventRequest;
        synchronized (eventRequest) {
            block13: {
                if (this._eventRequest.responseWasSent()) {
                    if (this._logger != null) {
                        this._logger.error(MessageFormat.format(rb.getString("EventProcessor.duplicateResponse.fmt.txt"), serviceProvider));
                    }
                } else if (this._eventRequest.isResponseRequired()) {
                    if (this._logger != null && this._logger.isInfoEnabled()) {
                        this._logger.info(MessageFormat.format(rb.getString("EventProcessor.sendResponse.fmt.txt"), serviceProvider));
                    }
                    StringBuffer response = new StringBuffer();
                    response.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                    response.append("<sas-event:SASEventBrokerResponse");
                    response.append(" xmlns:sas-event=\"http://www.sas.com/xml/namespace/services.events-1.1\"");
                    response.append(" sas-event:event=\"" + this._message.getEventName() + '\"');
                    response.append(" sas-event:type=\"result\"");
                    if (this._eventRequest.getIdentity() != null) {
                        response.append(" sas-event:identity=\"" + this._eventRequest.getIdentity() + '\"');
                    }
                    if (this._eventRequest.getSentAt() != null) {
                        response.append(" sas-event:sentAt=\"" + this._eventRequest.getSentAt() + '\"');
                    }
                    response.append(" sas-event:startedAt=\"" + this._startTime + '\"');
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                    TimeZone utc = TimeZone.getTimeZone("UTC");
                    formatter.setTimeZone(utc);
                    String completionTime = formatter.format(new Date());
                    response.append(" sas-event:completedAt=\"" + completionTime + '\"');
                    response.append(" sas-event:servicedBy=\"" + serviceProvider + '\"');
                    response.append(">");
                    Iterator itResponses = this._responses.iterator();
                    while (itResponses.hasNext()) {
                        response.append((String)itResponses.next());
                    }
                    response.append("</sas-event:SASEventBrokerResponse>");
                    ResponseAgent responseAgent = this._eventRequest.getResponseAgent();
                    try {
                        responseAgent.init();
                        responseAgent.sendResponse(response.toString());
                        this._eventRequest.setResponseWasSent();
                        responseAgent.term();
                    }
                    catch (ResponseException re) {
                        if (this._logger == null) break block13;
                        this._logger.error(MessageFormat.format(rb.getString("EventProcessor.sendResponseException.fmt.txt"), re.getMessage()));
                        this._logger.error(MessageFormat.format(rb.getString("EventProcessor.undeliveredResponse.fmt.txt"), response));
                    }
                }
            }
        }
    }

    public String getEventName() {
        return this._eventRequest.getEventName();
    }

    public String getStartTime() {
        return this._startTime;
    }

    @Override
    public boolean isResponseRequired() throws RemoteException {
        return this._eventRequest.isResponseRequired();
    }

    @Override
    public void setResponse(String response) throws RemoteException {
        this._responses.add(response);
    }

    @Override
    public void setResponse(DocumentFragment response) throws RemoteException {
        String strResponse = XMLUtil.convertNodeToString((Node)response, (boolean)true);
        this._responses.add(strResponse);
    }

    @Override
    public void setResponse(Object response) throws RemoteException {
        if (response instanceof String) {
            String str = (String)response;
            this.setResponse(str);
        } else if (response instanceof DocumentFragment) {
            DocumentFragment documentFragment = (DocumentFragment)response;
            this.setResponse(documentFragment);
        }
    }

    @Override
    public void log(String message) throws RemoteException {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(MessageFormat.format(rb.getString("EventProcessor.userCode.fmt.txt"), message));
        }
    }
}

