/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.events.broker.Message;
import com.sas.services.events.broker.MessageInterface;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class MessageFactory {
    public static final int MESSAGE_FLAG_EMPTY_BODY = 1;

    public MessageInterface newMessage() {
        Message message = new Message();
        message.setBody("");
        return message;
    }

    public MessageInterface newMessage(Object body) {
        Message message = new Message();
        message.setBody(body);
        return message;
    }

    public MessageInterface newMessage(MessageInterface message, int flags) {
        Message newMessage = (Message)message.clone();
        if ((flags & 1) != 0) {
            newMessage.setBody("");
            Object body = message.getBody();
            if (body instanceof Node) {
                Node node = (Node)body;
                Document doc = node.getOwnerDocument();
                if (node instanceof DocumentFragment) {
                    DocumentFragment documentFragment = doc.createDocumentFragment();
                    newMessage.setBody(documentFragment);
                }
            }
        }
        return newMessage;
    }
}

