/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker;

import com.sas.PublicClonable;
import com.sas.codepolicy.SASScope;
import com.sas.services.events.broker.MessageBodyConversionException;
import com.sas.services.events.broker.MessageInterface;
import com.sas.services.events.broker.RB;
import com.sas.services.events.broker.SecurityContext;
import com.sas.services.util.XMLUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope
public class Message
implements MessageInterface,
PublicClonable,
Serializable {
    private static final long serialVersionUID = 2920043337564517039L;
    private String _eventName = "";
    private String _messageName = "";
    private Object _body = "";
    private Map _properties = new HashMap();
    private SecurityContext _securityContext = new SecurityContext();
    private String _sourceNodeName = "";
    private static final String RB_KEY = "Message.";
    private static ResourceBundle rb = RB.getResources();

    @Override
    public final Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(MessageFormat.format(rb.getString("Message.cloneNotSupportedException.ex.fmt.txt"), e.getMessage()));
        }
        Message message = (Message)clone;
        if (this._body != null) {
            if (this._body instanceof Node) {
                Node body = (Node)this._body;
                Node cloneNode = body.cloneNode(true);
                message.setBody(cloneNode);
            } else {
                boolean isClonable = false;
                Class<?> clazz = this._body.getClass();
                Class<?>[] interfaces = clazz.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    Class<?> myInterface = interfaces[i];
                    if (!myInterface.getName().equals("Cloneable")) continue;
                    isClonable = true;
                }
                if (isClonable) {
                    Class[] parameterTypes = new Class[]{};
                    Object[] args = new Object[]{};
                    try {
                        Method cloneMethod = clazz.getMethod("clone", parameterTypes);
                        Object body = cloneMethod.invoke(this._body, args);
                        message.setBody(body);
                    }
                    catch (Throwable throwable) {}
                }
            }
        } else {
            message.setBody("");
        }
        message.setProperties((Map)((HashMap)this._properties).clone());
        message.setSecurityContext((SecurityContext)this._securityContext.clone());
        return clone;
    }

    public final void setEventName(String eventName) {
        this._eventName = eventName;
    }

    @Override
    public final String getEventName() {
        return this._eventName;
    }

    public final void setMessageName(String messageName) {
        this._messageName = messageName;
    }

    @Override
    public final String getMessageName() {
        return this._messageName;
    }

    @Override
    public final void setBody(Object body) {
        this._body = body;
    }

    @Override
    public final Object getBody() {
        return this._body;
    }

    @Override
    public DocumentFragment getBodyAsDocumentFragment() throws MessageBodyConversionException {
        DocumentFragment documentFragment = null;
        if (this._body instanceof DocumentFragment) {
            documentFragment = (DocumentFragment)this._body;
        } else if (this._body instanceof String) {
            String body = (String)this._body;
            Document doc = null;
            try {
                StringBuffer buffer = new StringBuffer();
                if (body.startsWith("<?xml")) {
                    int index = body.indexOf("?>");
                    if (index != -1) {
                        buffer.append(body.substring(0, index + 2));
                        buffer.append("<DocumentRootRoot>");
                        buffer.append(body.substring(index + 2));
                        buffer.append("</DocumentRootRoot>");
                    }
                } else {
                    buffer.append("<DocumentRootRoot>");
                    buffer.append(body);
                    buffer.append("</DocumentRootRoot>");
                }
                body = buffer.toString();
                doc = XMLUtil.convertStringToDocument((String)body);
                documentFragment = doc.createDocumentFragment();
                Element root = doc.getDocumentElement();
                NodeList nodeList = root.getChildNodes();
                int listLength = nodeList.getLength();
                Vector<Node> nodes = new Vector<Node>();
                for (int i = 0; i < listLength; ++i) {
                    Node node = nodeList.item(i);
                    if (node == null || node.getNodeType() != 1 && node.getNodeType() != 3) continue;
                    nodes.add(node);
                }
                Iterator nodeIter = nodes.iterator();
                while (nodeIter.hasNext()) {
                    documentFragment.appendChild((Node)nodeIter.next());
                }
                this.setBody(documentFragment);
            }
            catch (Throwable t) {
                throw new MessageBodyConversionException(t.getClass().getName() + ": " + t.getMessage());
            }
        }
        return documentFragment;
    }

    @Override
    public String getBodyAsString() throws MessageBodyConversionException {
        String body;
        block6: {
            body = null;
            if (this._body != null) {
                if (this._body instanceof Node) {
                    try {
                        Node node = (Node)this._body;
                        body = XMLUtil.convertNodeToString((Node)node, (boolean)true);
                        if (body == null) {
                            String msg = rb.getString("Message.unableToConvertDocToString.ext.txt");
                            throw new MessageBodyConversionException(msg);
                        }
                        break block6;
                    }
                    catch (MessageBodyConversionException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new MessageBodyConversionException(e.getMessage());
                    }
                }
                body = this._body instanceof String ? (String)this._body : this._body.toString();
            }
        }
        return body;
    }

    public final void setProperties(Map properties) {
        this._properties = properties;
    }

    @Override
    public final Map getProperties() {
        return this._properties;
    }

    public final void setSecurityContext(SecurityContext securityContext) {
        this._securityContext = securityContext;
    }

    @Override
    public final SecurityContext getSecurityContext() {
        return this._securityContext;
    }

    public final void setSourceNodeName(String sourceNodeName) {
        this._sourceNodeName = sourceNodeName;
    }

    @Override
    public final String getSourceNodeName() {
        return this._sourceNodeName;
    }
}

