/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.MdStoreUtil;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.services.AbstractServiceComponentConfig;
import com.sas.services.MergePolicy;
import com.sas.services.ServiceConfigurationException;
import com.sas.services.ServiceException;
import com.sas.services.events.broker.EventBrokerServiceFactory;
import com.sas.services.events.broker.EventBrokerServiceInitializer;
import com.sas.services.events.broker.RB;
import com.sas.services.util.XMLUtil;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope
public class EventBrokerServiceComponentConfig
extends AbstractServiceComponentConfig {
    private static final UsageVersion USAGEVERSION_OLDEST = new UsageVersion(0, 0);
    private static final UsageVersion USAGEVERSION_CURRENT = new UsageVersion(0, 0);
    private static final String CONSUMER_PROPERTY_NAME = "Consumer";
    private static final String CONSUMER_PROPERTY_DISPLAY_NAME = "Consumer tracking name";
    private static final String TRANSPORT_DELETION_TEMPLATE = "<PropertySet>   <Properties/>   <OwningObject/></PropertySet><TCPIPConnection>   <Source search=\"@ProductName^='Foundation Services'\"/></TCPIPConnection>";
    private static final String PROPERTY_DELETION_TEMPLATE = "<Property>   <OwningType/></Property>";
    private static final String ROOT_DELETION_TEMPLATE = "<Root>   <Properties/></Root>";

    public EventBrokerServiceComponentConfig() {
        super(EventBrokerServiceInitializer.getXMLDocument(), true);
        this.setUsageVersionCompatibility(USAGEVERSION_OLDEST, USAGEVERSION_CURRENT);
    }

    public final String getServiceComponentConfiguration(ServiceComponent serviceComponent) throws ServiceException {
        String configuration = this.getConfiguration(serviceComponent);
        configuration = "<ObjectRoot>" + configuration + "</ObjectRoot>";
        Document configDocument = XMLUtil.convertStringToDocument((String)configuration);
        Document rootDocument = this.getDocument();
        Element rootElement = rootDocument.getDocumentElement();
        Element configElement = configDocument.getDocumentElement();
        NodeList childNodes = configElement.getChildNodes();
        int len = childNodes.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = childNodes.item(i);
            Node importedNode = rootDocument.importNode(node, true);
            rootElement.appendChild(importedNode);
        }
        Properties outputFormatProperties = new Properties();
        outputFormatProperties.put("encoding", "UTF-8");
        outputFormatProperties.put("indent", "yes");
        configuration = XMLUtil.convertNodeToString((Node)rootDocument, (Properties)outputFormatProperties);
        return configuration;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getConfiguration(ServiceComponent serviceComponent) throws ServiceException {
        String configuration = "";
        MdObjectStore workStore = null;
        MdObjectStore outStore = null;
        try {
            MdObjectStore curStore = (MdObjectStore)serviceComponent.getObjectStore();
            MdFactory mdFactory = curStore.getFactory();
            workStore = mdFactory.createObjectStore((MdStore)curStore);
            outStore = mdFactory.createObjectStore((MdStore)workStore);
            for (Event event : serviceComponent.getRegisteredEvents()) {
                event = (Event)workStore.getObject(event.getFQID());
                event.getEventBrokers().clear();
                event = (Event)outStore.getObject(event.getFQID());
                for (Property property : event.getProperties()) {
                    property.getOwningType();
                }
                for (TransformationActivity transformationActivity : event.getTriggeredTransforms()) {
                    for (Property property : transformationActivity.getProperties()) {
                        property.getOwningType();
                    }
                    for (TextStore textStore : transformationActivity.getTransformationTargets()) {
                        for (Property property : textStore.getProperties()) {
                            property.getOwningType();
                        }
                    }
                    for (TransformationStep step : transformationActivity.getSteps()) {
                        Iterator transformationsIter = step.getTransformations().iterator();
                        if (!transformationsIter.hasNext()) continue;
                        Transformation transformation = (Transformation)transformationsIter.next();
                        transformation.getComputeLocations().iterator();
                        for (Property property : transformation.getProperties()) {
                            property.getOwningType();
                        }
                        for (TextStore textStore : transformation.getTransformationSources()) {
                            for (Property property : textStore.getProperties()) {
                                property.getOwningType();
                            }
                        }
                        for (TextStore textStore : transformation.getTransformationTargets()) {
                            for (Property property : textStore.getProperties()) {
                                property.getOwningType();
                            }
                        }
                    }
                }
            }
            ServiceComponent workServiceComponent = (ServiceComponent)workStore.getObject(serviceComponent.getFQID());
            workServiceComponent.getSourceConnections().clear();
            workServiceComponent.getProviderConnections().clear();
            workServiceComponent.getDataPackages().clear();
            Iterator transformIter = serviceComponent.getInitProcesses().iterator();
            if (transformIter.hasNext()) {
                Transformation transformation = (Transformation)transformIter.next();
                for (PropertySet propertySet : transformation.getTransformationSources()) {
                    if ("RMI".equals(propertySet.getSetRole())) continue;
                    propertySet = (PropertySet)workStore.getObject(propertySet.getFQID());
                    propertySet.getSourceTransformations().clear();
                    Root owningObject = propertySet.getOwningObject();
                    if (owningObject instanceof Directory) {
                        Directory dir = (Directory)owningObject;
                        dir.getDeployedComponents().clear();
                    } else if (owningObject instanceof TCPIPConnection) {
                        TCPIPConnection connection = (TCPIPConnection)owningObject;
                        String transportType = propertySet.getSetRole();
                        if ("HTTP".equalsIgnoreCase(transportType) || "IOM".equalsIgnoreCase(transportType)) {
                            connection.getSources().clear();
                        } else if ("JMS".equalsIgnoreCase(transportType) || "MQJMS".equalsIgnoreCase(transportType) || "JMQ".equalsIgnoreCase(transportType) || "Mail".equalsIgnoreCase(transportType)) {
                            connection.getProviders().clear();
                        }
                    }
                    propertySet = (PropertySet)outStore.getObject(propertySet.getFQID());
                    for (Property property : propertySet.getProperties()) {
                        property.getOwningType();
                    }
                    owningObject = propertySet.getOwningObject();
                    if (!(owningObject instanceof TCPIPConnection)) continue;
                    TCPIPConnection connection = (TCPIPConnection)owningObject;
                    String transportType = propertySet.getSetRole();
                    if (!"JMS".equalsIgnoreCase(transportType) && !"MQJMS".equalsIgnoreCase(transportType) && !"JMQ".equalsIgnoreCase(transportType) && !"Mail".equalsIgnoreCase(transportType)) continue;
                    connection.getSources();
                }
            }
            this.changeIdsToAliases(outStore);
            configuration = outStore.createXMLforStore();
        }
        catch (MdException e) {
            try {
                throw new ServiceException((Throwable)e, RB.getStringResource("EventBrokerServiceComponentConfig.getConfiguration.mdException.ex.txt"));
                catch (RemoteException e2) {
                    throw new ServiceException((Throwable)e2, RB.getStringResource("EventBrokerServiceComponentConfig.getConfiguration.mdException.ex.txt"));
                }
            }
            catch (Throwable throwable) {
                EventBrokerServiceComponentConfig.disposeStore(outStore);
                EventBrokerServiceComponentConfig.disposeStore(workStore);
                throw throwable;
            }
        }
        EventBrokerServiceComponentConfig.disposeStore((MdStore)outStore);
        EventBrokerServiceComponentConfig.disposeStore((MdStore)workStore);
        return configuration;
    }

    private static final void disposeStore(MdStore mdStore) {
        if (mdStore != null) {
            try {
                mdStore.dispose();
            }
            catch (RemoteException e) {
                LogManager.getLogger(EventBrokerServiceComponentConfig.class).error((Object)e);
            }
        }
    }

    private void changeIdsToAliases(MdObjectStore mdObjectStore) throws MdException {
        try {
            Map map = mdObjectStore.getDetailObjectMap();
            ArrayList list = new ArrayList(map.values());
            Iterator iter = list.iterator();
            CMetadata cMetadata = null;
            String id = null;
            String newId = null;
            while (iter.hasNext()) {
                cMetadata = (CMetadata)iter.next();
                id = cMetadata.getId();
                newId = MessageFormat.format("{0}{1}{2}", "$", id.substring(0, 8), id.substring(9, id.length()));
                mdObjectStore.changeHashKey(id, newId);
            }
        }
        catch (RemoteException e) {
            throw new MdException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void mergeConfig(ServiceComponent serviceComponent, Document serviceConfiguration) throws ServiceException {
        block25: {
            if (serviceComponent == null || serviceConfiguration == null) {
                throw new IllegalArgumentException();
            }
            MdObjectStore inputStore = null;
            MdObjectStore workStore = null;
            Throwable exception = null;
            try {
                this.validateServiceComponent(serviceComponent);
                this.validateServiceConfiguration(serviceConfiguration);
                MdObjectStore curStore = (MdObjectStore)serviceComponent.getObjectStore();
                MdFactory mdFactory = curStore.getFactory();
                workStore = mdFactory.createObjectStore((MdStore)curStore);
                inputStore = mdFactory.createObjectStore();
                MdOMIUtil mdOMIUtil = mdFactory.getOMIUtil();
                mdOMIUtil.populateStoreFromString((MdStore)inputStore, serviceConfiguration, 1, true);
                String reposId = serviceComponent.getFQID().substring(0, 8);
                this.changeIdsToMatchRepos(inputStore, reposId);
                Map map = inputStore.getDetailObjectMap();
                ArrayList newMetadata = new ArrayList(map.values());
                boolean bAddedConsumer = false;
                boolean bAddedNewEvent = false;
                AssociationList existingEvents = serviceComponent.getRegisteredEvents();
                ServiceComponent inputServiceComponent = (ServiceComponent)mdOMIUtil.getMetadataAllDepths((MdStore)inputStore, "ServiceComponent", serviceComponent.getFQID(), new ArrayList(0), new ArrayList(0), null, 0);
                Iterator metadataIter = newMetadata.iterator();
                CMetadata cMetadata = null;
                Event newEvent = null;
                Event existingEvent2222222222 = null;
                while (metadataIter.hasNext()) {
                    cMetadata = (CMetadata)metadataIter.next();
                    String type = cMetadata.getCMetadataType();
                    if (!"Event".equals(type)) continue;
                    newEvent = (Event)cMetadata;
                    String name = newEvent.getName();
                    boolean bDuplicate = false;
                    for (Event existingEvent2222222222 : existingEvents) {
                        if (!existingEvent2222222222.getName().equals(name)) continue;
                        bDuplicate = this.isDuplicateEvent(existingEvent2222222222, newEvent);
                        if (!bDuplicate) {
                            throw new ServiceException(MessageFormat.format(RB.getStringResource("EventBrokerServiceComponentConfig.mergeConfig.event.conflict.ex.fmt.txt"), name));
                        }
                        bAddedConsumer = this.trackConsumer((CMetadata)existingEvent2222222222, this.getConfigName());
                        break;
                    }
                    if (bDuplicate) continue;
                    bAddedConsumer = this.trackConsumer((CMetadata)newEvent, this.getConfigName());
                    newEvent.getEventBrokers().add((Object)inputServiceComponent);
                    this.copyEvent(inputStore, workStore, newEvent);
                    bAddedNewEvent = true;
                }
                boolean bAddedNewTransport = false;
                AssociationList existingTransports = null;
                Transformation inputTransformation = null;
                Iterator transformIter = serviceComponent.getInitProcesses().iterator();
                if (transformIter.hasNext()) {
                    Transformation transformation = (Transformation)transformIter.next();
                    existingTransports = transformation.getTransformationSources();
                    inputTransformation = (Transformation)mdOMIUtil.getMetadataAllDepths((MdStore)inputStore, "Transformation", transformation.getFQID(), new ArrayList(0), new ArrayList(0), null, 0);
                }
                if (existingTransports == null) {
                    throw new ServiceException(MessageFormat.format(RB.getStringResource("EventBrokerServiceComponentConfig.mergeConfig.missingAssociation.ex.fmt.txt"), serviceComponent.getName()));
                }
                metadataIter = newMetadata.iterator();
                PropertySet newTransport = null;
                while (metadataIter.hasNext()) {
                    cMetadata = (CMetadata)metadataIter.next();
                    String type = cMetadata.getCMetadataType();
                    if (!"PropertySet".equals(type)) continue;
                    newTransport = (PropertySet)cMetadata;
                    String name = newTransport.getName();
                    boolean bDuplicate = false;
                    for (PropertySet existingTransport : existingTransports) {
                        if (!existingTransport.getName().equals(name)) continue;
                        bDuplicate = this.isDuplicateTransport(existingTransport, newTransport);
                        if (!bDuplicate) {
                            throw new ServiceException(MessageFormat.format(RB.getStringResource("EventBrokerServiceComponentConfig.mergeConfig.transport.conflict.ex.fmt.txt"), name));
                        }
                        bAddedConsumer = this.trackConsumer((CMetadata)existingTransport, this.getConfigName());
                        break;
                    }
                    if (bDuplicate) continue;
                    bAddedConsumer = this.trackConsumer((CMetadata)newTransport, this.getConfigName());
                    newTransport.getSourceTransformations().add((Object)inputTransformation);
                    Root owningObject = newTransport.getOwningObject();
                    if (owningObject instanceof Directory) {
                        Directory dir = (Directory)owningObject;
                        dir.getDeployedComponents().add((Object)inputServiceComponent);
                    } else if (owningObject instanceof TCPIPConnection) {
                        TCPIPConnection connection = (TCPIPConnection)owningObject;
                        String transportType = newTransport.getSetRole();
                        if ("HTTP".equalsIgnoreCase(transportType) || "IOM".equalsIgnoreCase(transportType)) {
                            connection.getSources().add((Object)inputServiceComponent);
                        } else if ("JMS".equalsIgnoreCase(transportType) || "MQJMS".equalsIgnoreCase(transportType) || "JMQ".equalsIgnoreCase(transportType) || "Mail".equalsIgnoreCase(transportType)) {
                            connection.getProviders().add((Object)inputServiceComponent);
                        }
                    }
                    this.copyTransport(inputStore, workStore, newTransport);
                    bAddedNewTransport = true;
                }
                if (bAddedNewEvent || bAddedNewTransport || bAddedConsumer) {
                    if (bAddedNewEvent || bAddedNewTransport) {
                        workStore.updatedMetadataAll();
                    }
                    curStore.updatedMetadataAll();
                }
                EventBrokerServiceComponentConfig.disposeStore((MdStore)inputStore);
            }
            catch (MdException e) {
                exception = e;
            }
            catch (RemoteException e2) {
                exception = e2;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                EventBrokerServiceComponentConfig.disposeStore(inputStore);
                EventBrokerServiceComponentConfig.disposeStore(workStore);
                if (exception == null) break block25;
                throw new ServiceException(exception, RB.getStringResource("EventBrokerServiceComponentConfig.mergeConfig.mdException.ex.txt"));
            }
            EventBrokerServiceComponentConfig.disposeStore((MdStore)workStore);
            if (exception != null) {
                throw new ServiceException(exception, RB.getStringResource("EventBrokerServiceComponentConfig.mergeConfig.mdException.ex.txt"));
            }
        }
    }

    private void changeIdsToMatchRepos(MdObjectStore mdObjectStore, String reposId) throws MdException {
        try {
            Map map = mdObjectStore.getDetailObjectMap();
            ArrayList list = new ArrayList(map.values());
            Iterator iter = list.iterator();
            CMetadata cMetadata = null;
            String id = null;
            String newId = null;
            while (iter.hasNext()) {
                cMetadata = (CMetadata)iter.next();
                id = cMetadata.getId();
                newId = MessageFormat.format("{0}{1}{2}", reposId, ".", id.substring(9, id.length()));
                mdObjectStore.changeHashKey(id, newId);
            }
        }
        catch (RemoteException e) {
            throw new MdException((Throwable)e);
        }
    }

    private boolean isDuplicateEvent(Event event1, Event event2) throws MdException {
        boolean bDuplicate = true;
        try {
            String desc1 = event1.getDesc();
            String desc2 = event2.getDesc();
            if (!desc1.equals(desc2)) {
                bDuplicate = false;
            } else {
                AssociationList props1 = event1.getProperties();
                AssociationList props2 = event2.getProperties();
                Iterator propsIter1 = props1.iterator();
                Property property1 = null;
                Property property22 = null;
                while (propsIter1.hasNext() && bDuplicate) {
                    property1 = (Property)propsIter1.next();
                    if (property1.getPropertyName().equals(CONSUMER_PROPERTY_NAME)) continue;
                    boolean bFound = false;
                    for (Property property22 : props2) {
                        if (!property1.getPropertyName().equals(property22.getPropertyName())) continue;
                        bFound = true;
                        if (property1.getDefaultValue().equals(property22.getDefaultValue())) break;
                        bDuplicate = false;
                        break;
                    }
                    if (bFound) continue;
                    bDuplicate = false;
                }
                if (bDuplicate) {
                    AssociationList flows1 = event1.getTriggeredTransforms();
                    AssociationList flows2 = event2.getTriggeredTransforms();
                    if (flows1.size() != flows2.size()) {
                        bDuplicate = false;
                    } else {
                        Iterator flowsIter1 = flows1.iterator();
                        TransformationActivity flow1 = null;
                        TransformationActivity flow22 = null;
                        while (flowsIter1.hasNext() && bDuplicate) {
                            flow1 = (TransformationActivity)flowsIter1.next();
                            boolean bFound = false;
                            for (TransformationActivity flow22 : flows2) {
                                if (!flow1.getName().equals(flow22.getName())) continue;
                                bFound = true;
                                if (!flow1.getDesc().equals(flow22.getDesc())) {
                                    bDuplicate = false;
                                    break;
                                }
                                props1 = flow1.getProperties();
                                props2 = flow22.getProperties();
                                if (props1.size() != props2.size()) {
                                    bDuplicate = false;
                                } else {
                                    propsIter1 = props1.iterator();
                                    property1 = null;
                                    property22 = null;
                                    while (propsIter1.hasNext() && bDuplicate) {
                                        property1 = (Property)propsIter1.next();
                                        bFound = false;
                                        for (Property property22 : props2) {
                                            if (!property1.getPropertyName().equals(property22.getPropertyName())) continue;
                                            bFound = true;
                                            if (property1.getDefaultValue().equals(property22.getDefaultValue())) break;
                                            bDuplicate = false;
                                            break;
                                        }
                                        if (bFound) continue;
                                        bDuplicate = false;
                                    }
                                }
                                if (!bDuplicate) break;
                                AssociationList steps1 = flow1.getSteps();
                                AssociationList steps2 = flow22.getSteps();
                                if (steps1.size() != steps2.size()) {
                                    bDuplicate = false;
                                    break;
                                }
                                Iterator stepsIter1 = steps1.iterator();
                                TransformationStep step1 = null;
                                TransformationStep step22 = null;
                                while (stepsIter1.hasNext() && bDuplicate) {
                                    step1 = (TransformationStep)stepsIter1.next();
                                    bFound = false;
                                    for (TransformationStep step22 : steps2) {
                                        boolean bFound2;
                                        Iterator sourcesIter2;
                                        TextStore msg2;
                                        TextStore msg1;
                                        Iterator sourcesIter1;
                                        AssociationList sources2;
                                        AssociationList sources1;
                                        if (!step1.getName().equals(step22.getName())) continue;
                                        bFound = true;
                                        if (!step1.getDesc().equals(step22.getDesc())) {
                                            bDuplicate = false;
                                            break;
                                        }
                                        AssociationList transformations1 = step1.getTransformations();
                                        AssociationList transformations2 = step22.getTransformations();
                                        if (transformations1.size() != transformations2.size()) {
                                            bDuplicate = false;
                                            break;
                                        }
                                        Transformation transformation1 = null;
                                        Transformation transformation2 = null;
                                        if (transformations1.size() <= 0) break;
                                        transformation1 = (Transformation)transformations1.get(0);
                                        transformation2 = (Transformation)transformations2.get(0);
                                        AssociationList locations1 = transformation1.getComputeLocations();
                                        AssociationList locations2 = transformation2.getComputeLocations();
                                        if (locations1.size() != locations2.size()) {
                                            bDuplicate = false;
                                        } else if (locations1.size() > 0) {
                                            DeployedComponent location1 = (DeployedComponent)locations1.get(0);
                                            DeployedComponent location2 = (DeployedComponent)locations2.get(0);
                                            if (!location1.getClassIdentifier().equals(location2.getClassIdentifier())) {
                                                bDuplicate = false;
                                            }
                                        }
                                        if (bDuplicate) {
                                            props1 = transformation1.getProperties();
                                            props2 = transformation2.getProperties();
                                            if (props1.size() != props2.size()) {
                                                bDuplicate = false;
                                            } else {
                                                propsIter1 = props1.iterator();
                                                property1 = null;
                                                property22 = null;
                                                while (propsIter1.hasNext() && bDuplicate) {
                                                    property1 = (Property)propsIter1.next();
                                                    bFound = false;
                                                    for (Property property22 : props2) {
                                                        if (!property1.getPropertyName().equals(property22.getPropertyName())) continue;
                                                        bFound = true;
                                                        if (property1.getDefaultValue().equals(property22.getDefaultValue())) break;
                                                        bDuplicate = false;
                                                        break;
                                                    }
                                                    if (bFound) continue;
                                                    bDuplicate = false;
                                                }
                                            }
                                        }
                                        if (bDuplicate) {
                                            sources1 = transformation1.getTransformationSources();
                                            sources2 = transformation2.getTransformationSources();
                                            if (sources1.size() != sources2.size()) {
                                                bDuplicate = false;
                                            } else {
                                                sourcesIter1 = sources1.iterator();
                                                msg1 = null;
                                                msg2 = null;
                                                while (sourcesIter1.hasNext() && bDuplicate) {
                                                    msg1 = (TextStore)sourcesIter1.next();
                                                    bFound = false;
                                                    sourcesIter2 = sources2.iterator();
                                                    while (sourcesIter2.hasNext() && !bFound) {
                                                        msg2 = (TextStore)sourcesIter2.next();
                                                        if (!msg1.getName().equals(msg2.getName()) || !msg1.getDesc().equals(msg2.getDesc())) continue;
                                                        props1 = msg1.getProperties();
                                                        props2 = msg2.getProperties();
                                                        if (props1.size() != props2.size()) continue;
                                                        bFound = true;
                                                        propsIter1 = props1.iterator();
                                                        property1 = null;
                                                        property22 = null;
                                                        while (propsIter1.hasNext() && bFound) {
                                                            property1 = (Property)propsIter1.next();
                                                            bFound2 = false;
                                                            for (Property property22 : props2) {
                                                                if (!property1.getPropertyName().equals(property22.getPropertyName())) continue;
                                                                bFound2 = true;
                                                                if (property1.getDefaultValue().equals(property22.getDefaultValue())) break;
                                                                bFound = false;
                                                                break;
                                                            }
                                                            if (bFound2) continue;
                                                            bFound = false;
                                                        }
                                                    }
                                                    if (bFound) continue;
                                                    bDuplicate = false;
                                                }
                                            }
                                        }
                                        if (!bDuplicate) break;
                                        sources1 = transformation1.getTransformationTargets();
                                        sources2 = transformation2.getTransformationTargets();
                                        if (sources1.size() != sources2.size()) {
                                            bDuplicate = false;
                                            break;
                                        }
                                        sourcesIter1 = sources1.iterator();
                                        msg1 = null;
                                        msg2 = null;
                                        while (sourcesIter1.hasNext() && bDuplicate) {
                                            msg1 = (TextStore)sourcesIter1.next();
                                            bFound = false;
                                            sourcesIter2 = sources2.iterator();
                                            while (sourcesIter2.hasNext() && !bFound) {
                                                msg2 = (TextStore)sourcesIter2.next();
                                                if (!msg1.getName().equals(msg2.getName()) || !msg1.getDesc().equals(msg2.getDesc())) continue;
                                                props1 = msg1.getProperties();
                                                props2 = msg2.getProperties();
                                                if (props1.size() != props2.size()) continue;
                                                bFound = true;
                                                propsIter1 = props1.iterator();
                                                property1 = null;
                                                property22 = null;
                                                while (propsIter1.hasNext() && bFound) {
                                                    property1 = (Property)propsIter1.next();
                                                    bFound2 = false;
                                                    for (Property property22 : props2) {
                                                        if (!property1.getPropertyName().equals(property22.getPropertyName())) continue;
                                                        bFound2 = true;
                                                        if (property1.getDefaultValue().equals(property22.getDefaultValue())) break;
                                                        bFound = false;
                                                        break;
                                                    }
                                                    if (bFound2) continue;
                                                    bFound = false;
                                                }
                                            }
                                            if (bFound) continue;
                                            bDuplicate = false;
                                        }
                                        break block9;
                                    }
                                    if (bFound) continue;
                                    bDuplicate = false;
                                }
                                break block5;
                            }
                            if (bFound) continue;
                            bDuplicate = false;
                        }
                    }
                }
            }
        }
        catch (RemoteException e) {
            throw new MdException((Throwable)e);
        }
        return bDuplicate;
    }

    private void copyEvent(MdObjectStore inStore, MdObjectStore outStore, Event event) throws MdException {
        try {
            MdStoreUtil.copyMetaObject((MdObjectStore)inStore, (MdObjectStore)outStore, (String)event.getFQID());
            for (Property property : event.getProperties()) {
                PropertyType propertyType = property.getOwningType();
                MdStoreUtil.copyMetaObject((MdObjectStore)inStore, (MdObjectStore)outStore, (String)property.getFQID());
                MdStoreUtil.copyMetaObject((MdObjectStore)inStore, (MdObjectStore)outStore, (String)propertyType.getFQID());
            }
            for (TransformationActivity transformationActivity : event.getTriggeredTransforms()) {
                MdStoreUtil.copyMetaObject((MdObjectStore)inStore, (MdObjectStore)outStore, (String)transformationActivity.getFQID());
                for (Property property : transformationActivity.getProperties()) {
                    PropertyType propertyType = property.getOwningType();
                    MdStoreUtil.copyMetaObject((MdObjectStore)inStore, (MdObjectStore)outStore, (String)property.getFQID());
                    MdStoreUtil.copyMetaObject((MdObjectStore)inStore, (MdObjectStore)outStore, (String)propertyType.getFQID());
                }
                for (TextStore textStore : transformationActivity.getTransformationTargets()) {
                    MdStoreUtil.copyMetaObject((MdObjectStore)inStore, (MdObjectStore)outStore, (String)textStore.getFQID());
                    for (Property property : textStore.getProperties()) {
                        PropertyType propertyType = property.getOwningType();
                        MdStoreUtil.copyMetaObject((MdObjectStore)inStore, (MdObjectStore)outStore, (String)property.getFQID());
                        MdStoreUtil.copyMetaObject((MdObjectStore)inStore, (MdObjectStore)outStore, (String)propertyType.getFQID());
                    }
                }
                for (TransformationStep step : transformationActivity.getSteps()) {
                    PropertyType propertyType;
                    MdStoreUtil.copyMetaObject((MdObjectStore)inStore, (MdObjectStore)outStore, (String)step.getFQID());
                    Iterator transformationsIter = step.getTransformations().iterator();
                    if (!transformationsIter.hasNext()) continue;
                    Transformation transformation = (Transformation)transformationsIter.next();
                    MdStoreUtil.copyMetaObject((MdObjectStore)inStore, (MdObjectStore)outStore, (String)transformation.getFQID());
                    Iterator computeLocationsIter = transformation.getComputeLocations().iterator();
                    if (computeLocationsIter.hasNext()) {
                        DeployedComponent dc = (DeployedComponent)computeLocationsIter.next();
                        MdStoreUtil.copyMetaObject((MdObjectStore)inStore, (MdObjectStore)outStore, (String)dc.getFQID());
                    }
                    for (Property property : transformation.getProperties()) {
                        PropertyType propertyType2 = property.getOwningType();
                        MdStoreUtil.copyMetaObject((MdObjectStore)inStore, (MdObjectStore)outStore, (String)property.getFQID());
                        MdStoreUtil.copyMetaObject((MdObjectStore)inStore, (MdObjectStore)outStore, (String)propertyType2.getFQID());
                    }
                    for (TextStore textStore : transformation.getTransformationSources()) {
                        MdStoreUtil.copyMetaObject((MdObjectStore)inStore, (MdObjectStore)outStore, (String)textStore.getFQID());
                        for (Property property : textStore.getProperties()) {
                            propertyType = property.getOwningType();
                            MdStoreUtil.copyMetaObject((MdObjectStore)inStore, (MdObjectStore)outStore, (String)property.getFQID());
                            MdStoreUtil.copyMetaObject((MdObjectStore)inStore, (MdObjectStore)outStore, (String)propertyType.getFQID());
                        }
                    }
                    for (TextStore textStore : transformation.getTransformationTargets()) {
                        MdStoreUtil.copyMetaObject((MdObjectStore)inStore, (MdObjectStore)outStore, (String)textStore.getFQID());
                        for (Property property : textStore.getProperties()) {
                            propertyType = property.getOwningType();
                            MdStoreUtil.copyMetaObject((MdObjectStore)inStore, (MdObjectStore)outStore, (String)property.getFQID());
                            MdStoreUtil.copyMetaObject((MdObjectStore)inStore, (MdObjectStore)outStore, (String)propertyType.getFQID());
                        }
                    }
                }
            }
        }
        catch (RemoteException e) {
            throw new MdException((Throwable)e);
        }
    }

    private boolean isDuplicateTransport(PropertySet transport1, PropertySet transport2) throws MdException {
        boolean bDuplicate = true;
        try {
            String type1 = transport1.getSetRole();
            String type2 = transport2.getSetRole();
            if (!type1.equals(type2)) {
                bDuplicate = false;
            } else {
                AssociationList props1 = transport1.getProperties();
                AssociationList props2 = transport2.getProperties();
                Iterator propsIter1 = props1.iterator();
                while (propsIter1.hasNext() && bDuplicate) {
                    Property property1 = (Property)propsIter1.next();
                    if (property1.getPropertyName().equals(CONSUMER_PROPERTY_NAME)) continue;
                    boolean bFound = false;
                    for (Property property2 : props2) {
                        if (!property1.getPropertyName().equals(property2.getPropertyName())) continue;
                        bFound = true;
                        if (property1.getDefaultValue().equals(property2.getDefaultValue())) break;
                        bDuplicate = false;
                        break;
                    }
                    if (bFound) continue;
                    bDuplicate = false;
                }
                Root owningObject1 = transport1.getOwningObject();
                Root owningObject2 = transport2.getOwningObject();
                type1 = "";
                type2 = "";
                if (owningObject1 != null) {
                    type1 = owningObject1.getCMetadataType();
                }
                if (owningObject2 != null) {
                    type2 = owningObject2.getCMetadataType();
                }
                if (!type1.equals(type2)) {
                    bDuplicate = false;
                } else if (type1.equals("TCPIPConnection")) {
                    TCPIPConnection connection1 = (TCPIPConnection)owningObject1;
                    TCPIPConnection connection2 = (TCPIPConnection)owningObject2;
                    if (!connection1.getHostName().equals(connection2.getHostName())) {
                        bDuplicate = false;
                    } else if (connection1.getPort() != connection2.getPort()) {
                        bDuplicate = false;
                    }
                } else if (type1.equals("Directory")) {
                    Directory dir1 = (Directory)owningObject1;
                    Directory dir2 = (Directory)owningObject2;
                    if (!dir1.getDirectoryName().equals(dir2.getDirectoryName())) {
                        bDuplicate = false;
                    }
                }
            }
        }
        catch (RemoteException e) {
            throw new MdException((Throwable)e);
        }
        return bDuplicate;
    }

    private void copyTransport(MdObjectStore inStore, MdObjectStore outStore, PropertySet transport) throws MdException {
        try {
            MdStoreUtil.copyMetaObject((MdObjectStore)inStore, (MdObjectStore)outStore, (String)transport.getFQID());
            for (Property property : transport.getProperties()) {
                PropertyType propertyType = property.getOwningType();
                MdStoreUtil.copyMetaObject((MdObjectStore)inStore, (MdObjectStore)outStore, (String)property.getFQID());
                MdStoreUtil.copyMetaObject((MdObjectStore)inStore, (MdObjectStore)outStore, (String)propertyType.getFQID());
            }
            Root owningObject = transport.getOwningObject();
            MdStoreUtil.copyMetaObject((MdObjectStore)inStore, (MdObjectStore)outStore, (String)owningObject.getFQID());
            if (owningObject instanceof TCPIPConnection) {
                TCPIPConnection connection = (TCPIPConnection)owningObject;
                for (Root source : connection.getSources()) {
                    if (!source.isNewObject()) continue;
                    MdStoreUtil.copyMetaObject((MdObjectStore)inStore, (MdObjectStore)outStore, (String)source.getFQID());
                }
            }
        }
        catch (RemoteException e) {
            throw new MdException((Throwable)e);
        }
    }

    protected final String getServiceFactoryClassName() {
        return EventBrokerServiceFactory.class.getName();
    }

    protected final void validateServiceConfigurationCustom(Document serviceConfiguration) throws ServiceException {
    }

    protected final DocumentFragment appendDOM(Document document, AbstractServiceComponentConfig serviceConfig) throws ServiceConfigurationException, IllegalArgumentException {
        return null;
    }

    protected final DocumentFragment appendDOM(Document document) throws ServiceConfigurationException, IllegalArgumentException {
        return null;
    }

    protected final AbstractServiceComponentConfig getConfig(Document serviceConfigDocument) throws ServiceConfigurationException, IllegalArgumentException {
        return null;
    }

    protected final void mergeConfiguration(AbstractServiceComponentConfig currentConfig, AbstractServiceComponentConfig newConfig) throws ServiceConfigurationException, IllegalArgumentException {
    }

    protected final void mergeConfiguration(AbstractServiceComponentConfig currentConfig, AbstractServiceComponentConfig newConfig, MergePolicy mergePolicy) throws ServiceConfigurationException {
    }

    private boolean trackConsumer(CMetadata cMetadata, String consumerName) throws RemoteException, MdException {
        boolean addConsumer = false;
        if (consumerName != null && consumerName.length() > 0) {
            AssociationList propertiesList = null;
            String type = cMetadata.getCMetadataType();
            if ("Event".equals(type)) {
                Event event = (Event)cMetadata;
                propertiesList = event.getProperties();
            } else if ("PropertySet".equals(type)) {
                PropertySet propertySet = (PropertySet)cMetadata;
                propertiesList = propertySet.getProperties();
            }
            if (propertiesList != null) {
                boolean isTracked = false;
                for (Property property : propertiesList) {
                    if (!CONSUMER_PROPERTY_NAME.equals(property.getPropertyName()) || !consumerName.equals(property.getDefaultValue())) continue;
                    isTracked = true;
                    break;
                }
                if (!isTracked) {
                    MdObjectStore mdObjectStore = (MdObjectStore)cMetadata.getObjectStore();
                    Property property = (Property)mdObjectStore.getFactory().createComplexMetadataObject(mdObjectStore, CONSUMER_PROPERTY_DISPLAY_NAME, "Property", cMetadata.getRepositoryID());
                    property.setPropertyName(CONSUMER_PROPERTY_NAME);
                    property.setDefaultValue(consumerName);
                    property.setDesc("Used by EventBrokerService to track consumer usage.");
                    PropertyType propertyType = (PropertyType)mdObjectStore.getFactory().createComplexMetadataObject(mdObjectStore, null, "String", "PropertyType", cMetadata.getRepositoryID());
                    propertyType.setSQLType(12);
                    property.setOwningType(propertyType);
                    propertiesList.add(property);
                    addConsumer = true;
                }
            }
        }
        return addConsumer;
    }

    /*
     * WARNING - void declaration
     */
    public void removeConsumer(ServiceComponent serviceComponent) throws ServiceException {
        String consumerName = this.getConfigName();
        if (consumerName != null && consumerName.length() > 0) {
            Throwable ex = null;
            try {
                Transformation transformation;
                AssociationList transports;
                MdObjectStore objectStore = (MdObjectStore)serviceComponent.getObjectStore();
                MdFactory mdFactory = objectStore.getFactory();
                StringBuffer propertyDeletionTemplate = new StringBuffer();
                propertyDeletionTemplate.append("<Templates>");
                propertyDeletionTemplate.append(PROPERTY_DELETION_TEMPLATE);
                propertyDeletionTemplate.append(ROOT_DELETION_TEMPLATE);
                propertyDeletionTemplate.append("</Templates>");
                StringBuffer transportDeletionTemplate = new StringBuffer();
                transportDeletionTemplate.append("<Templates>");
                transportDeletionTemplate.append(TRANSPORT_DELETION_TEMPLATE);
                transportDeletionTemplate.append(PROPERTY_DELETION_TEMPLATE);
                transportDeletionTemplate.append(ROOT_DELETION_TEMPLATE);
                transportDeletionTemplate.append("</Templates>");
                ArrayList<Object> deletionList = new ArrayList<Object>();
                for (Event event : serviceComponent.getRegisteredEvents()) {
                    Property consumerProperty = null;
                    boolean isOtherConsumerDependent = false;
                    for (Property property : event.getProperties()) {
                        if (!CONSUMER_PROPERTY_NAME.equals(property.getPropertyName())) continue;
                        if (consumerName.equals(property.getDefaultValue())) {
                            consumerProperty = property;
                            continue;
                        }
                        isOtherConsumerDependent = true;
                    }
                    if (consumerProperty == null) continue;
                    if (isOtherConsumerDependent) {
                        event.getProperties().remove(consumerProperty);
                        objectStore.updatedMetadataAll();
                        mdFactory.deleteMetadataObjects((CMetadata)consumerProperty, propertyDeletionTemplate.toString());
                        continue;
                    }
                    deletionList.add(event);
                }
                Iterator transformIter = serviceComponent.getInitProcesses().iterator();
                if (transformIter.hasNext() && (transports = (transformation = (Transformation)transformIter.next()).getTransformationSources()) != null) {
                    deletionList.clear();
                    for (PropertySet transport : transports) {
                        void var15_18;
                        Object var15_19 = null;
                        boolean isOtherConsumerDependent = false;
                        for (Property property : transport.getProperties()) {
                            if (!CONSUMER_PROPERTY_NAME.equals(property.getPropertyName())) continue;
                            if (consumerName.equals(property.getDefaultValue())) {
                                Property property2 = property;
                                continue;
                            }
                            isOtherConsumerDependent = true;
                        }
                        if (var15_18 == null) continue;
                        if (isOtherConsumerDependent) {
                            transport.getProperties().remove((Object)var15_18);
                            objectStore.updatedMetadataAll();
                            mdFactory.deleteMetadataObjects((CMetadata)var15_18, propertyDeletionTemplate.toString());
                            continue;
                        }
                        deletionList.add(transport);
                    }
                    for (PropertySet propertySet : deletionList) {
                        transformation.getTransformationSources().remove((Object)propertySet);
                        objectStore.updatedMetadataAll();
                        mdFactory.deleteMetadataObjects((CMetadata)propertySet, transportDeletionTemplate.toString());
                    }
                }
            }
            catch (RemoteException e) {
                ex = e;
            }
            catch (MdException e) {
                ex = e;
            }
            if (ex != null) {
                throw new ServiceException(ex);
            }
        }
    }
}

