/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.events.Event;
import com.sas.services.events.EventInterface;
import com.sas.services.util.TransformerFactoryFactory;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class EventFactory {
    public EventInterface newEvent() {
        return new Event();
    }

    public EventInterface newEvent(String eventName) {
        return new Event(eventName);
    }

    public EventInterface newEvent(Document existingEvent) {
        Event event = new Event();
        Element root = existingEvent.getDocumentElement();
        if (root.getLocalName().equals("Event")) {
            Node node;
            NamedNodeMap map = root.getAttributes();
            for (int i = 0; i < map.getLength(); ++i) {
                node = map.item(i);
                if (!node.getLocalName().equals("name")) continue;
                event.setName(node.getNodeValue());
                break;
            }
            NodeList rootChildren = root.getChildNodes();
            int rootChildrenLen = rootChildren.getLength();
            for (int i = 0; i < rootChildrenLen; ++i) {
                Node rootChildNode = rootChildren.item(i);
                if (rootChildNode.getNodeType() != 1) continue;
                if (rootChildNode.getLocalName().equals("Header")) {
                    NodeList headerChildren = rootChildNode.getChildNodes();
                    int headerChildrenLen = headerChildren.getLength();
                    block8: for (int j = 0; j < headerChildrenLen; ++j) {
                        Node headerChildNode = headerChildren.item(j);
                        if (headerChildNode.getNodeType() != 1) continue;
                        String header = headerChildNode.getLocalName();
                        if (header.equals("Version")) {
                            NodeList list = headerChildNode.getChildNodes();
                            for (int k = 0; k < list.getLength(); ++k) {
                                node = list.item(k);
                                if (node.getNodeType() != 3) continue;
                                try {
                                    event.setVersion(Double.parseDouble(node.getNodeValue()));
                                }
                                catch (NumberFormatException numberFormatException) {}
                                continue block8;
                            }
                            continue;
                        }
                        if (header.equals("Identity")) {
                            NodeList list = headerChildNode.getChildNodes();
                            for (int k = 0; k < list.getLength(); ++k) {
                                node = list.item(k);
                                if (node.getNodeType() != 3) continue;
                                event.setIdentity(node.getNodeValue());
                                continue block8;
                            }
                            continue;
                        }
                        if (header.equals("Credentials")) {
                            String strName = "";
                            String strPassword = "";
                            String strDomain = "";
                            map = headerChildNode.getAttributes();
                            for (int k = 0; k < map.getLength(); ++k) {
                                node = map.item(k);
                                if (node.getLocalName().equals("name")) {
                                    strName = node.getNodeValue();
                                    continue;
                                }
                                if (node.getLocalName().equals("password")) {
                                    strPassword = node.getNodeValue();
                                    continue;
                                }
                                if (!node.getLocalName().equals("domain")) continue;
                                strDomain = node.getNodeValue();
                            }
                            event.setCredentials(strName, strPassword, strDomain);
                            continue;
                        }
                        if (header.equals("Priority")) {
                            NodeList list = headerChildNode.getChildNodes();
                            for (int k = 0; k < list.getLength(); ++k) {
                                node = list.item(k);
                                if (node.getNodeType() != 3) continue;
                                try {
                                    event.setPriority(Integer.parseInt(node.getNodeValue()));
                                }
                                catch (NumberFormatException strDomain) {}
                                continue block8;
                            }
                            continue;
                        }
                        if (header.equals("SentFrom")) {
                            NodeList list = headerChildNode.getChildNodes();
                            for (int k = 0; k < list.getLength(); ++k) {
                                node = list.item(k);
                                if (node.getNodeType() != 3) continue;
                                event.setFrom(node.getNodeValue());
                                continue block8;
                            }
                            continue;
                        }
                        if (header.equals("SentAt")) {
                            NodeList list = headerChildNode.getChildNodes();
                            for (int k = 0; k < list.getLength(); ++k) {
                                node = list.item(k);
                                if (node.getNodeType() != 3) continue;
                                event.setTime(node.getNodeValue());
                                continue block8;
                            }
                            continue;
                        }
                        if (header.equals("Response")) {
                            map = headerChildNode.getAttributes();
                            for (int k = 0; k < map.getLength(); ++k) {
                                node = map.item(k);
                                if (!node.getLocalName().equals("type")) continue;
                                event.setResponseType(node.getNodeValue());
                                continue block8;
                            }
                            continue;
                        }
                        if (!header.equals("Properties")) continue;
                        HashMap<String, String> properties = new HashMap<String, String>();
                        NodeList propChildren = headerChildNode.getChildNodes();
                        int propChildrenLen = propChildren.getLength();
                        for (int k = 0; k < propChildrenLen; ++k) {
                            node = propChildren.item(k);
                            if (node.getNodeType() != 1) continue;
                            String strPropName = "";
                            String strNS = node.getNamespaceURI();
                            if (strNS != null) {
                                strPropName = strNS + ':';
                            }
                            strPropName = strPropName + node.getLocalName();
                            String strPropValue = "";
                            NodeList list = node.getChildNodes();
                            for (int m = 0; m < list.getLength(); ++m) {
                                node = list.item(m);
                                if (node.getNodeType() != 3) continue;
                                strPropValue = node.getNodeValue();
                                break;
                            }
                            properties.put(strPropName, strPropValue);
                        }
                        if (properties.isEmpty()) continue;
                        event.setProperties(properties);
                    }
                    continue;
                }
                if (!rootChildNode.getLocalName().equals("Body")) continue;
                try {
                    DocumentBuilderFactory factory = TransformerFactoryFactory.newDocumentBuilderFactory();
                    factory.setNamespaceAware(true);
                    factory.setValidating(false);
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document doc = builder.newDocument();
                    DocumentFragment body = doc.createDocumentFragment();
                    NodeList bodyChildren = rootChildNode.getChildNodes();
                    int bodyChildrenLen = bodyChildren.getLength();
                    for (int j = 0; j < bodyChildrenLen; ++j) {
                        node = bodyChildren.item(j);
                        if (node.getNodeType() != 1) continue;
                        Node importedNode = doc.importNode(node, true);
                        body.appendChild(importedNode);
                    }
                    event.setBody(body);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return event;
    }
}

