/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events;

import com.sas.codepolicy.SASScope;
import com.sas.services.events.EventInterface;
import com.sas.services.util.XMLUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.w3c.dom.Node;

@SASScope
public class Event
implements EventInterface {
    String _eventName = null;
    double _version = 1.0;
    String _identity = null;
    String _userName = null;
    String _userPW = null;
    String _domain = null;
    String _sessionContextId = null;
    String _sessionContextLockId = null;
    String _priority = null;
    String _from = null;
    String _time = null;
    String _responseType = "none";
    HashMap _properties = new HashMap();
    Object _body = null;
    public static final String NS_URI = "http://www.sas.com/xml/namespace/services.events-1.1";
    public static final String NS_PREFIX = "sas-event";
    public static final String NS_PREFIX_COLON = "sas-event:";

    public Event() {
    }

    public Event(String eventName) {
        this._eventName = eventName;
    }

    @Override
    public final void setName(String eventName) {
        this._eventName = eventName;
    }

    @Override
    public final String getName() {
        return this._eventName;
    }

    @Override
    public final void setVersion(double version) {
        this._version = version;
    }

    @Override
    public final double getVersion() {
        return this._version;
    }

    @Override
    public final void setIdentity(String identity) {
        this._identity = identity;
    }

    @Override
    public final String getIdentity() {
        return this._identity;
    }

    @Override
    public final void setCredentials(String name, String password, String domain) {
        this._userName = name;
        this._userPW = password;
        this._domain = domain;
    }

    @Override
    public final void setCredentials(String sessionContextId, String sessionContextLockId) {
        this._sessionContextId = sessionContextId;
        this._sessionContextLockId = sessionContextLockId;
    }

    @Override
    public final String getCredentialsName() {
        return this._userName;
    }

    @Override
    public final String getCredentialsPW() {
        return this._userPW;
    }

    @Override
    public final String getCredentialsDomain() {
        return this._domain;
    }

    @Override
    public final String getCredentialsSessionContextId() {
        return this._sessionContextId;
    }

    @Override
    public final String getCredentialsSessionContextLockId() {
        return this._sessionContextLockId;
    }

    @Override
    public final void setPriority(int priority) {
        this._priority = String.valueOf(priority);
    }

    @Override
    public final int getPriority() {
        return Integer.parseInt(this._priority);
    }

    @Override
    public final void setFrom(String from) {
        this._from = from;
    }

    @Override
    public final String getFrom() {
        return this._from;
    }

    @Override
    public final void setTime(String time) {
        this._time = time;
    }

    @Override
    public final String getTime() {
        return this._time;
    }

    @Override
    public final void setResponseType(String responseType) {
        if (responseType.equalsIgnoreCase("ack")) {
            this._responseType = "ack";
        } else if (responseType.equalsIgnoreCase("result")) {
            this._responseType = "result";
        }
    }

    @Override
    public final String getResponseType() {
        return this._responseType;
    }

    @Override
    public final void setProperties(Map map) {
        this._properties.putAll(map);
    }

    @Override
    public final Map getProperties() {
        return this._properties;
    }

    @Override
    public final void setBody(String body) {
        this._body = body;
    }

    @Override
    public final void setBody(Node body) {
        this._body = body;
    }

    @Override
    public final Object getBody() {
        return this._body;
    }

    @Override
    public Object serialize(int format) {
        Object object = null;
        StringBuffer buf = new StringBuffer();
        if (this._eventName != null) {
            buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
            buf.append("<sas-event:Event xmlns:sas-event=\"http://www.sas.com/xml/namespace/services.events-1.1\" sas-event:name=\"" + this._eventName + "\">");
            buf.append("<sas-event:Header>");
            buf.append("<sas-event:Version>" + String.valueOf(this._version) + "</" + NS_PREFIX_COLON + "Version>");
            if (this._identity != null) {
                buf.append("<sas-event:Identity>" + this._identity + "</" + NS_PREFIX_COLON + "Identity>");
            }
            if (this._userName != null || this._userPW != null || this._domain != null || this._sessionContextId != null || this._sessionContextLockId != null) {
                buf.append("<sas-event:Credentials");
                if (this._userName != null) {
                    buf.append(" sas-event:name=\"" + this._userName + '\"');
                }
                if (this._userPW != null) {
                    buf.append(" sas-event:password=\"" + this._userPW + '\"');
                }
                if (this._domain != null) {
                    buf.append(" sas-event:domain=\"" + this._domain + '\"');
                }
                if (this._sessionContextId != null) {
                    buf.append(" sas-event:sessionContextId=\"" + this._sessionContextId + '\"');
                }
                if (this._sessionContextLockId != null) {
                    buf.append(" sas-event:sessionContextLockId=\"" + this._sessionContextLockId + '\"');
                }
                buf.append("/>");
            }
            if (this._priority != null) {
                buf.append("<sas-event:Priority>" + this._priority + "</" + NS_PREFIX_COLON + "Priority>");
            }
            if (this._from != null) {
                buf.append("<sas-event:SentFrom>" + this._from + "</" + NS_PREFIX_COLON + "SentFrom>");
            }
            String gmt = null;
            if (this._time == null) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                TimeZone utc = TimeZone.getTimeZone("UTC");
                formatter.setTimeZone(utc);
                gmt = formatter.format(new Date());
            } else {
                gmt = this._time;
            }
            buf.append("<sas-event:SentAt>" + gmt + "</" + NS_PREFIX_COLON + "SentAt>");
            buf.append("<sas-event:Response sas-event:type=\"" + this._responseType + "\"/>");
            if (!this._properties.isEmpty()) {
                buf.append("<sas-event:Properties>");
                Set keys = this._properties.keySet();
                Iterator iter = keys.iterator();
                while (iter.hasNext()) {
                    Object value;
                    String strKey = null;
                    String strPropValue = null;
                    Object key = iter.next();
                    if (!(key instanceof String)) continue;
                    strKey = (String)key;
                    String strPropName = "";
                    String strNS = "";
                    int index = strKey.lastIndexOf(":");
                    if (index == -1) {
                        strPropName = strKey;
                    } else {
                        strNS = strKey.substring(0, index);
                        strPropName = strKey.substring(index + 1);
                    }
                    if (!((value = this._properties.get(key)) instanceof String)) continue;
                    strPropValue = (String)value;
                    buf.append('<' + strPropName);
                    if (strNS.length() > 0) {
                        buf.append(" xmlns=\"" + strNS + '\"');
                    }
                    buf.append(">");
                    buf.append(strPropValue);
                    buf.append("</" + strPropName + '>');
                }
                buf.append("</sas-event:Properties>");
            }
            buf.append("</sas-event:Header>");
            if (this._body != null) {
                buf.append("<sas-event:Body>");
                String body = "";
                if (this._body instanceof String) {
                    int index;
                    body = (String)this._body;
                    if (body.startsWith("<?xml") && (index = body.indexOf("?>")) != -1) {
                        body = body.substring(index + 2);
                    }
                } else if (this._body instanceof Node) {
                    try {
                        Node node = (Node)this._body;
                        String result = XMLUtil.convertNodeToString((Node)node, (boolean)true);
                        if (result != null) {
                            body = result;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                buf.append(body);
                buf.append("</sas-event:Body>");
            }
            buf.append("</sas-event:Event>");
        }
        if (format == 0) {
            object = buf.toString();
        } else if (format == 1) {
            try {
                object = XMLUtil.convertStringToDocument((String)buf.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return object;
    }
}

