/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.deployment.data;

import com.sas.svcs.deployment.dao.WorkflowStateHolder;
import java.net.InetAddress;

public class SASHost {
    private String hostType;
    private String hostFamily;
    private String hostName;

    public SASHost() {
    }

    public SASHost(String hostName, String hostType) {
        this.hostType = hostType;
        this.hostName = hostName;
    }

    public String getHostType() {
        return this.hostType;
    }

    public void setHostType(String hostType) {
        this.hostType = hostType;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostFamily() {
        return this.hostFamily;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SASHost)) {
            return false;
        }
        SASHost sasHost = (SASHost)obj;
        if (this.hostName == null || sasHost.getHostName() == null) {
            return false;
        }
        return this == sasHost || SASHost.isHostsEqual(this.hostName, sasHost.getHostName());
    }

    public int hashCode() {
        int result = 17;
        try {
            InetAddress hostAddress;
            if (this.hostName != null && (hostAddress = SASHost.convertToInetAddress(this.hostName)) != null && hostAddress.getHostAddress() != null) {
                result = 31 * result + hostAddress.getHostAddress().hashCode();
            }
        }
        catch (RuntimeException e) {
            Object offlineWorkflowPhaseEnabled = WorkflowStateHolder.getProperty(WorkflowStateHolder.IS_OFFLINE_RECOVERY_INITIAL_PHASE_ENABLED);
            if (offlineWorkflowPhaseEnabled != null && ((Boolean)offlineWorkflowPhaseEnabled).booleanValue()) {
                if (this.hostName != null) {
                    return this.hostName.hashCode();
                }
            }
            throw e;
        }
        return result;
    }

    public static boolean isHostsEqual(String host1, String host2) {
        boolean result = false;
        try {
            InetAddress hostAddress1 = SASHost.convertToInetAddress(host1);
            InetAddress hostAddress2 = SASHost.convertToInetAddress(host2);
            result = hostAddress1 != null && hostAddress1.getHostAddress() != null && hostAddress2 != null && hostAddress2.getHostAddress() != null && hostAddress1.getHostAddress().equals(hostAddress2.getHostAddress());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static InetAddress convertToInetAddress(String host) {
        InetAddress address = null;
        try {
            address = InetAddress.getByName(host);
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown host : " + host, e);
        }
        return address;
    }
}

