/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.deployment.dao;

import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.SoftwareComponentInterface;
import com.sas.svcs.deployment.DiscoveryException;
import com.sas.svcs.deployment.dao.ConfigurableObjectExtractor;
import com.sas.svcs.deployment.dao.DeploymentDiscoveryDAO;
import com.sas.svcs.deployment.data.ConfigurableProperties;
import com.sas.svcs.deployment.data.SASHost;
import com.sas.svcs.deployment.data.SASTier;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="SAS_TIERExtractor")
public class SASTierExtractor
implements ConfigurableObjectExtractor<SASTier> {
    private static String TIER_NAME_PREFIX = "tier";
    @Autowired
    private DeploymentDiscoveryDAO discoveryDAO;
    private static final Logger logger = LogManager.getLogger(SASTierExtractor.class);

    @Override
    public List<SASTier> getConfigurableObjects(DeploymentDiscoveryDAO.ComponentType componetType) throws DiscoveryException {
        List<SoftwareComponentInterface> levDirRoots = this.discoveryDAO.getDeploymentComponents(DeploymentDiscoveryDAO.ComponentType.SAS_TIER, SoftwareComponentInterface.class);
        ArrayList<SASTier> sasTiers = null;
        SASTier sasTier = null;
        if (levDirRoots.size() > 0) {
            int count = 1;
            sasTiers = new ArrayList<SASTier>(levDirRoots.size());
            for (SoftwareComponentInterface levdirRoot : levDirRoots) {
                sasTier = this.convert(levdirRoot);
                sasTier.setTierName(TIER_NAME_PREFIX + count++);
                sasTiers.add(sasTier);
            }
        } else {
            throw new DiscoveryException();
        }
        return sasTiers;
    }

    @Override
    public SASTier convert(SoftwareComponentInterface configurable) throws DiscoveryException {
        Properties configProperties = this.discoveryDAO.getConfigurableProperties(configurable);
        String hostName = null;
        String configDir = null;
        String hostType = null;
        String sasHome = null;
        SASTier sasTier = new SASTier();
        try {
            logger.debug("configurable.getIdentifier() = " + configurable.getIdentifier());
            sasTier.setEntityId(configurable.getIdentifier());
        }
        catch (ServiceException serviceException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        boolean productsDeployed = true;
        List deployedProducts = null;
        try {
            deployedProducts = configurable.getDependentComponents();
            boolean bl = productsDeployed = deployedProducts != null && deployedProducts.size() > 0;
            if (productsDeployed) {
                for (MetadataInterface deployed : deployedProducts) {
                    String classId;
                    if (!(deployed instanceof SoftwareComponentInterface) || !"webappsrv".equals(classId = ((SoftwareComponentInterface)deployed).getClassIdentifier())) continue;
                    sasTier.setMidTierClusterTier(true);
                }
            }
        }
        catch (ServiceException serviceException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        sasTier.setProductsDeployed(productsDeployed);
        if (configProperties != null) {
            sasTier.set_12Byte("levconfig");
            hostName = configProperties.getProperty(ConfigurableProperties.TIER_HOST_NAME.property());
            hostType = configProperties.getProperty(ConfigurableProperties.OS_TYPE.property());
            configDir = configProperties.getProperty(ConfigurableProperties.TIER_DIR.property());
            sasHome = configProperties.getProperty(ConfigurableProperties.SAS_HOME.property());
            sasTier.setSasConfig(configDir);
            sasTier.setSasHome(sasHome);
            sasTier.setTierHost(new SASHost(hostName, hostType));
            sasTier.setProperties(configProperties);
        }
        return sasTier;
    }
}

