/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.deployment.dao;

import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.svcs.deployment.dao.DeploymentDiscoveryDAO;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class FilterFactory {
    private int DEF_FLGS = 18561;

    public FilterInterface getClassIdFilter(DeploymentDiscoveryDAO.ComponentType componentType) {
        Filter filter = new Filter();
        FilterComponent fc = new FilterComponent();
        fc.setAggregation(1);
        if (!"".equals(componentType.classId())) {
            fc.addComponent(new FilterComponent("ClassIdentifier", 0, componentType.classId()));
        }
        filter.setType(componentType.metadataType());
        filter.setOMRFlags(this.DEF_FLGS);
        filter.setFilterComponent(fc);
        return filter;
    }

    public FilterInterface getAnyofFilter(String type, Map<String, String> filterComponents) {
        Filter filter = new Filter();
        if (filterComponents != null) {
            FilterComponent fc = new FilterComponent();
            fc.setAggregation(1);
            for (String key : filterComponents.keySet()) {
                fc.addComponent(new FilterComponent(key, 0, filterComponents.get(key)));
                filter.setType(type);
                filter.setOMRFlags(this.DEF_FLGS);
                filter.setFilterComponent(fc);
            }
        }
        return filter;
    }
}

