/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.deployment.dao;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.util.ConfigurablePropertiesUtil;
import com.sas.services.ServiceException;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.SoftwareComponentInterface;
import com.sas.svcs.authentication.helper.FoundationServicesUserSessionFactory;
import com.sas.svcs.deployment.ApplicationContextUtil;
import com.sas.svcs.deployment.DiscoveryException;
import com.sas.svcs.deployment.dao.ConfigurableObjectExtractor;
import com.sas.svcs.deployment.dao.FilterFactory;
import com.sas.svcs.deployment.data.ConfigurableServer;
import com.sas.svcs.deployment.data.SASHost;
import com.sas.svcs.deployment.data.SASTier;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="configPropertyDependentDAO")
public class DeploymentDiscoveryDAO {
    @Autowired
    private FoundationServicesUserSessionFactory userSessionFactory;
    @Autowired
    private FilterFactory filterFactory;
    @Autowired
    private ApplicationContextUtil discoverer;
    private static String HOST_NAME_PROP = "os.localhost.fqdn.host.name";
    private static String CONFIG_DIR_PROP = "config.lev.dir";
    Logger logger = LogManager.getLogger(DeploymentDiscoveryDAO.class);

    public SoftwareComponentInterface getSASTierConfigurable(SoftwareComponentInterface configurable) throws DiscoveryException {
        SoftwareComponentInterface sasTier = null;
        if (configurable != null) {
            try {
                List dependsOn = configurable.getDependsOnComponents();
                if (dependsOn != null) {
                    for (SoftwareComponentInterface depend : dependsOn) {
                        if (!"levdirroot".equalsIgnoreCase(depend.getClassIdentifier())) continue;
                        return depend;
                    }
                }
            }
            catch (ServiceException e) {
                throw new DiscoveryException();
            }
            catch (RemoteException e) {
                throw new DiscoveryException();
            }
        }
        return sasTier;
    }

    public <T extends SoftwareComponentInterface> List<T> getDeploymentComponents(ComponentType componentType, Class<T> clazz) throws DiscoveryException {
        FilterInterface filter = this.filterFactory.getClassIdFilter(componentType);
        return this.getDeploymentComponents(filter, clazz);
    }

    public Properties getConfigurableProperties(SoftwareComponentInterface configurable) throws DiscoveryException {
        HashMap publicProperties = new HashMap();
        HashMap privateProperties = new HashMap();
        Properties properties = null;
        try {
            ConfigurablePropertiesUtil.getObjectProperties((SoftwareComponent)((SoftwareComponent)configurable.getRepositoryEntity()), publicProperties, privateProperties);
            properties = this.convert(publicProperties, privateProperties);
        }
        catch (RemoteException exception) {
            throw new DiscoveryException();
        }
        catch (MdException exception) {
            throw new DiscoveryException();
        }
        return properties;
    }

    private Properties convert(Map<String, String> ... props) {
        Properties allProperties = null;
        if (props != null) {
            allProperties = new Properties();
            for (Map<String, String> properties : props) {
                Set<Map.Entry<String, String>> propEntries = properties.entrySet();
                for (Map.Entry<String, String> prop : propEntries) {
                    allProperties.setProperty(prop.getKey(), prop.getValue());
                    this.logger.trace("DeploymentDiscoveryDAO.convert() ConfigurableProperties  key = " + prop.getKey() + " , value = " + prop.getValue());
                }
            }
        }
        return allProperties;
    }

    public <T extends SoftwareComponentInterface> List<T> getDeploymentComponents(FilterInterface filter, Class<T> clazz) {
        ServerInterface metaServer = null;
        List configurableObjects = null;
        try {
            metaServer = this.userSessionFactory.getLocalSession().getUserContext().getAuthServer();
            configurableObjects = metaServer.search(filter);
        }
        catch (ServiceException exception) {
            throw new DiscoveryException();
        }
        catch (RemoteException exception) {
            throw new DiscoveryException();
        }
        return configurableObjects;
    }

    public SoftwareComponentInterface getSASTier(String hostName, String configDir) {
        List<SoftwareComponentInterface> sasTiers;
        if (hostName != null && configDir != null && (sasTiers = this.getDeploymentComponents(ComponentType.SAS_TIER, SoftwareComponentInterface.class)) != null) {
            Properties properties = null;
            for (SoftwareComponentInterface sasTier : sasTiers) {
                properties = this.getConfigurableProperties(sasTier);
                String levHostname = properties.getProperty(HOST_NAME_PROP);
                String levConfigDir = properties.getProperty(CONFIG_DIR_PROP);
                if (!SASHost.isHostsEqual(hostName, levHostname) || !configDir.startsWith(levConfigDir)) continue;
                return sasTier;
            }
        }
        return null;
    }

    public SASTier getDeployedOn(SoftwareComponentInterface configurable) {
        SoftwareComponentInterface sasTier = this.getSASTierConfigurable(configurable);
        SASTier configurableSASTier = null;
        if (sasTier != null) {
            ConfigurableObjectExtractor extractor = this.discoverer.getExtractor(ComponentType.SAS_TIER);
            configurableSASTier = (SASTier)extractor.convert(sasTier);
        }
        return configurableSASTier;
    }

    public String getName(SoftwareComponentInterface softwareC) {
        String name = null;
        try {
            if (softwareC != null) {
                name = softwareC.getName();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return name;
    }

    public static enum ComponentType {
        METADATA_SERVER("0217E202-B560-11DB-AD91-001083FF6836", "ServerComponent", ConfigurableServer.class, null),
        METADATA_SERVER1("0217E202-B560-11DB-AD91-001083FF6836", "LogicalServer", ConfigurableServer.class, null),
        SAS_TIER("LEVDIRROOT", "SoftwareComponent", SASTier.class, null),
        CONTENT_SERVER("WEBINFPLTFM", "SoftwareComponent", ConfigurableServer.class, null),
        SAS_WIP_DATA_SERVER("SASInfrastructureData", "ServerComponent", ConfigurableServer.class, "DataServer"),
        SAS_SOL_DATA_SERVER("SASInfrastructureData", "ServerComponent", ConfigurableServer.class, "DataServer"),
        SAS_APP_SERVER("SAS Application Server", "ServerContext", ConfigurableServer.class, null);

        private String classId;
        private String metadataType;
        private Class<?> clazz;
        private String groupName;

        private ComponentType(String clsId, String metaType, Class<?> clz, String gName) {
            this.classId = clsId;
            this.metadataType = metaType;
            this.clazz = clz;
            this.groupName = gName;
        }

        String classId() {
            return this.classId;
        }

        String metadataType() {
            return this.metadataType;
        }

        Class model() {
            return this.clazz;
        }

        public String groupName() {
            return this.groupName;
        }
    }
}

