/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.webservice.client;

import com.sas.svcs.commons.webservice.client.MarshallingSupport;
import com.sas.svcs.commons.webservice.client.ProxyHelperException;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.oxm.Unmarshaller;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.client.core.FaultMessageResolver;
import org.springframework.ws.soap.SoapFault;
import org.springframework.ws.soap.SoapFaultDetail;
import org.springframework.ws.soap.SoapFaultDetailElement;
import org.springframework.ws.soap.SoapMessage;

class UnmarshallingFaultMessageResolver
implements FaultMessageResolver {
    private static final Logger logger = LogManager.getLogger(UnmarshallingFaultMessageResolver.class);
    private String faultBinding;
    private String contextPath;

    public UnmarshallingFaultMessageResolver(String faultBinding, String contextPath) {
        this.faultBinding = faultBinding;
        this.contextPath = contextPath;
    }

    public void resolveFault(WebServiceMessage message) throws IOException {
        SoapFault soapFault = ((SoapMessage)message).getSoapBody().getFault();
        SoapFaultDetail detail = soapFault.getFaultDetail();
        if (detail != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Fault has detail");
            }
            Unmarshaller unmarshaller = MarshallingSupport.getUnmarshaller(this.faultBinding, this.contextPath);
            SoapFaultDetailElement detailEntry = (SoapFaultDetailElement)detail.getDetailEntries().next();
            Object fault = unmarshaller.unmarshal(detailEntry.getSource());
            throw new ProxyHelperException(fault);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Fault String: " + soapFault.getFaultStringOrReason());
        }
        throw new RuntimeException(soapFault.getFaultStringOrReason());
    }
}

