/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.webservice.client;

import com.sas.svcs.commons.webservice.client.MarshallingSupport;
import com.sas.svcs.commons.webservice.util.SASMarshallingUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.oxm.Unmarshaller;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.client.core.WebServiceMessageExtractor;
import org.springframework.ws.support.MarshallingUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class UnmarshallingExtractor
implements WebServiceMessageExtractor {
    private static final Logger logger = LogManager.getLogger(UnmarshallingExtractor.class);
    private String encOutElem;
    private String outParamBinding;
    private String contextPath;
    private String statefulElem;

    public UnmarshallingExtractor(String encOutElem, String outParamBinding, String contextPath, String statefulElem) {
        this.encOutElem = encOutElem;
        this.outParamBinding = outParamBinding;
        this.contextPath = contextPath;
        this.statefulElem = statefulElem;
    }

    public Object extractData(WebServiceMessage message) throws IOException, TransformerException {
        if (logger.isDebugEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            message.writeTo((OutputStream)baos);
            logger.debug("WS Response:\n" + baos.toString());
        }
        if (this.outParamBinding != null && message.getPayloadSource() != null) {
            Unmarshaller unmarshaller = MarshallingSupport.getUnmarshaller(this.outParamBinding, this.contextPath);
            if (this.encOutElem == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("encOutElem is null");
                }
                return MarshallingUtils.unmarshal((Unmarshaller)unmarshaller, (WebServiceMessage)message);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("encOutElem is NOT null");
            }
            try {
                Document responseDoc = MarshallingSupport.getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                MarshallingSupport.getTransformerFactory().newTransformer().transform(message.getPayloadSource(), new DOMResult(responseDoc));
                Node response = responseDoc.getFirstChild();
                if (response.getChildNodes().getLength() == 1) {
                    response = response.getFirstChild();
                    if (this.statefulElem != null && new QName(response.getNamespaceURI(), response.getLocalName()).toString().equals(this.statefulElem)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("processing stateful id child");
                        }
                        NodeList childNodes = response.getChildNodes();
                        for (int i = 0; i < childNodes.getLength(); ++i) {
                            Node childNode = childNodes.item(i);
                            if (!(childNode instanceof Text)) continue;
                            return ((Text)childNode).getNodeValue();
                        }
                        return null;
                    }
                    return SASMarshallingUtils.unmarshal((Unmarshaller)unmarshaller, (Source)new DOMSource(response), (WebServiceMessage)message);
                }
                return null;
            }
            catch (ParserConfigurationException e) {
                logger.error((Object)e);
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

