/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.webservice.client;

import com.sas.svcs.security.authentication.client.AuthenticationClient;
import com.sas.svcs.security.authentication.client.AuthenticationClientHolder;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServiceRegistryClient {
    private static final String SR_NS = "http://www.sas.com/xml/schema/sas-svcs/serviceregistry-9.2";
    private static final String SR_SERVICE_ELEM = "Service";
    private static final String SR_SERVICE_NAME_ELEM = "Name";
    private static final String SR_SERVICE_URL_ELEM = "Url";
    private static final String REQUEST_FILE = "ServiceRegistryRequest.xml";
    private String url;
    private NodeList serviceElems;

    public ServiceRegistryClient(String url) {
        this.url = url;
    }

    public void obtainServices() {
        StreamSource request = new StreamSource(ServiceRegistryClient.class.getResourceAsStream(REQUEST_FILE));
        DOMResult response = new DOMResult();
        AuthenticationClient client = AuthenticationClientHolder.get();
        if (null != client) {
            UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)this.url);
            UriComponents components = builder.build();
            if ("http".equals(components.getScheme()) && components.getPort() == 80 || "https".equals(components.getScheme()) && components.getPort() == 443) {
                builder.port(-1);
            }
            builder.replaceQueryParam("ticket", new Object[0]);
            this.url = builder.build().toString();
            String ticket = client.acquireTicket(this.url);
            builder.queryParam("ticket", new Object[]{ticket});
            this.url = builder.build().toString();
        }
        new WebServiceTemplate().sendSourceAndReceiveToResult(this.url, (Source)request, (Result)response);
        Document responseDoc = (Document)response.getNode();
        this.serviceElems = responseDoc.getElementsByTagNameNS(SR_NS, SR_SERVICE_ELEM);
    }

    public String getServiceURL(String serviceName) {
        for (int i = 0; i < this.serviceElems.getLength(); ++i) {
            Element serviceElem = (Element)this.serviceElems.item(i);
            String name = ServiceRegistryClient.getServiceName(serviceElem);
            if (!serviceName.equals(name)) continue;
            return ServiceRegistryClient.getServiceURL(serviceElem);
        }
        return null;
    }

    private static String getServiceName(Element serviceElem) {
        Element nameElem = ServiceRegistryClient.getOnlyIfOneElement(serviceElem, SR_SERVICE_NAME_ELEM);
        if (nameElem != null) {
            return nameElem.getTextContent();
        }
        return null;
    }

    private static String getServiceURL(Element serviceElem) {
        Element urlElem = ServiceRegistryClient.getOnlyIfOneElement(serviceElem, SR_SERVICE_URL_ELEM);
        if (urlElem != null) {
            return urlElem.getTextContent();
        }
        return null;
    }

    private static Element getOnlyIfOneElement(Element elem, String localName) {
        NodeList childElems = elem.getElementsByTagNameNS(SR_NS, localName);
        if (childElems != null && childElems.getLength() == 1) {
            return (Element)childElems.item(0);
        }
        return null;
    }
}

