/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.webservice.client;

import com.sas.svcs.commons.webservice.client.SecurityToken;
import com.sas.svcs.commons.webservice.client.SecurityTokenServiceClient;
import com.sas.svcs.security.authentication.client.AuthenticationClient;
import com.sas.svcs.security.authentication.client.AuthenticationClientHolder;
import com.sas.svcs.security.authentication.client.TicketCreationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.oxm.xmlbeans.XmlBeansMarshaller;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.FaultMessageResolver;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceMessageExtractor;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.soap.SoapFault;
import org.springframework.ws.soap.SoapFaultDetail;
import org.springframework.ws.soap.SoapFaultDetailElement;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.SoapVersion;
import org.springframework.ws.soap.saaj.SaajSoapMessageFactory;
import org.springframework.ws.soap.security.wss4j2.Wss4jSecurityInterceptor;
import org.springframework.ws.support.MarshallingUtils;

public class ProxyHelper {
    private static final Logger logger = LogManager.getLogger(ProxyHelper.class);
    private static final QName WS_ADDRESSING_ACTION_QNAME = new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Action");
    private static final String SECURITY_POLICY_DIGEST = "com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml";
    private static final String TOKEN_EXPIRED_MSG = "com.sun.xml.wss.impl.WssSoapFaultException: Authentication of Username Password Token Failed";
    private static final String TOKEN_EXPIRED_MSG_WSS4J = "The security token could not be authenticated or authorized;";
    private UnmarshallingFaultMessageResolver faultResolver;
    private boolean soap12;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;
    private String userid;
    private String password;
    private SecurityTokenServiceClient stsClient;
    private String securityPolicy;

    public ProxyHelper(String binding, String contextPath) {
        this(binding, contextPath, false);
    }

    public ProxyHelper(String binding, String contextPath, boolean soap12) {
        this.soap12 = soap12;
        if ("xmlbeansMarshaller".equals(binding)) {
            XmlBeansMarshaller xmlbeansMarshaller = new XmlBeansMarshaller();
            xmlbeansMarshaller.setValidating(false);
            this.marshaller = xmlbeansMarshaller;
            this.unmarshaller = xmlbeansMarshaller;
        } else if ("jaxbMarshaller".equals(binding) && contextPath != null) {
            try {
                Jaxb2Marshaller jaxb2Marshaller = new Jaxb2Marshaller();
                jaxb2Marshaller.setContextPath(contextPath);
                jaxb2Marshaller.afterPropertiesSet();
                this.marshaller = jaxb2Marshaller;
                this.unmarshaller = jaxb2Marshaller;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if ("jaxbAttachmentMarshaller".equals(binding) && contextPath != null) {
            try {
                Jaxb2Marshaller jaxb2AttachmentMarshaller = new Jaxb2Marshaller();
                jaxb2AttachmentMarshaller.setContextPath(contextPath);
                jaxb2AttachmentMarshaller.setMtomEnabled(true);
                jaxb2AttachmentMarshaller.afterPropertiesSet();
                this.marshaller = jaxb2AttachmentMarshaller;
                this.unmarshaller = jaxb2AttachmentMarshaller;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException("Unknown XML binding: " + binding);
        }
        this.faultResolver = new UnmarshallingFaultMessageResolver(this.unmarshaller);
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSecurityTokenServiceClient(SecurityTokenServiceClient stsClient) {
        this.stsClient = stsClient;
    }

    public void setSecurityPolicy(String securityPolicy) {
        this.securityPolicy = securityPolicy;
    }

    public Object call(String uri, String action, Object requestPayload) {
        RuntimeException faultException;
        String exceptionMsg;
        Object resultObj = this.callInternal(uri, action, requestPayload);
        Object fault = this.getFault();
        if (fault != null && fault instanceof RuntimeException && this.stsClient != null && (exceptionMsg = (faultException = (RuntimeException)fault).getMessage()) != null && (exceptionMsg.startsWith(TOKEN_EXPIRED_MSG) || exceptionMsg.startsWith(TOKEN_EXPIRED_MSG_WSS4J))) {
            if (logger.isDebugEnabled()) {
                logger.debug("Retrying Request. Token Expired Fault: " + ((RuntimeException)fault).getMessage());
            }
            this.resetFault();
            this.stsClient.cancelToken();
            resultObj = this.callInternal(uri, action, requestPayload);
        }
        return resultObj;
    }

    protected Object callInternal(String uri, final String action, final Object requestPayload) {
        WebServiceTemplate wsTemplate = this.createTemplate();
        AuthenticationClient client = AuthenticationClientHolder.get();
        if (null == this.stsClient && null != client) {
            try {
                UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)uri);
                UriComponents components = builder.build();
                if ("http".equals(components.getScheme()) && components.getPort() == 80 || "https".equals(components.getScheme()) && components.getPort() == 443) {
                    builder.port(-1);
                }
                builder.replaceQueryParam("ticket", new Object[0]);
                uri = builder.build().toUriString();
                String ticket = client.acquireTicket(uri);
                builder.queryParam("ticket", new Object[]{ticket});
                uri = builder.toString();
            }
            catch (TicketCreationException e) {
                logger.warn("Could not acquire ticket for service '" + uri + "'. Trying call without ticket.", (Throwable)e);
            }
        }
        return wsTemplate.sendAndReceive(uri, new WebServiceMessageCallback(){

            public void doWithMessage(WebServiceMessage message) throws IOException, TransformerException {
                if (action != null) {
                    ProxyHelper.this.addWsAddressingActionHeader((SoapMessage)message, action);
                }
                if (requestPayload != null) {
                    MarshallingUtils.marshal((Marshaller)ProxyHelper.this.marshaller, (Object)requestPayload, (WebServiceMessage)message);
                }
                if (logger.isDebugEnabled()) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    message.writeTo((OutputStream)baos);
                    logger.debug("WS Request:\n" + baos.toString());
                }
            }
        }, (WebServiceMessageExtractor)new WebServiceMessageExtractor<Object>(){

            public Object extractData(WebServiceMessage message) throws IOException {
                if (logger.isDebugEnabled()) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    message.writeTo((OutputStream)baos);
                    logger.debug("WS Response:\n" + baos.toString());
                }
                return MarshallingUtils.unmarshal((Unmarshaller)ProxyHelper.this.unmarshaller, (WebServiceMessage)message);
            }
        });
    }

    private void addWsAddressingActionHeader(SoapMessage message, String action) {
        SoapHeader soapHeader = message.getSoapHeader();
        SoapHeaderElement headerElement = soapHeader.addHeaderElement(WS_ADDRESSING_ACTION_QNAME);
        headerElement.setText(action);
    }

    private WebServiceTemplate createTemplate() {
        WebServiceTemplate wsTemplate = new WebServiceTemplate();
        if (this.soap12) {
            try {
                SaajSoapMessageFactory messageFactory = new SaajSoapMessageFactory();
                messageFactory.setSoapVersion(SoapVersion.SOAP_12);
                messageFactory.afterPropertiesSet();
                wsTemplate.setMessageFactory((WebServiceMessageFactory)messageFactory);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        wsTemplate.setMarshaller(this.marshaller);
        wsTemplate.setUnmarshaller(this.unmarshaller);
        wsTemplate.setFaultMessageResolver((FaultMessageResolver)this.faultResolver);
        this.addSecurityInterceptor(wsTemplate);
        return wsTemplate;
    }

    private void addSecurityInterceptor(WebServiceTemplate wsTemplate) {
        try {
            String thisPassword;
            String thisUsername;
            if (this.stsClient != null) {
                SecurityToken token = this.stsClient.getSecurityToken();
                thisUsername = token.getSecurityContextKey();
                thisPassword = token.getBinarySecret();
            } else {
                thisUsername = this.userid;
                thisPassword = this.password;
                logger.debug("No AuthenticationClient found, but userid and password were used. The SecurityTokenService is deprecated. Please switch to " + AuthenticationClient.class.getName());
            }
            if (thisUsername != null) {
                Wss4jSecurityInterceptor securityInterceptor = new Wss4jSecurityInterceptor();
                securityInterceptor.setSecurementUsername(thisUsername);
                if (thisPassword != null) {
                    securityInterceptor.setSecurementPassword(thisPassword);
                } else {
                    securityInterceptor.setSecurementPassword(thisUsername);
                }
                String actions = "UsernameToken";
                String passwordType = "PasswordText";
                boolean tokenCreated = false;
                boolean tokenNonce = false;
                if (this.securityPolicy != null && SECURITY_POLICY_DIGEST.equals(this.securityPolicy)) {
                    actions = actions + " Timestamp";
                    passwordType = "PasswordDigest";
                    tokenCreated = true;
                    tokenNonce = true;
                }
                securityInterceptor.setSecurementActions(actions);
                securityInterceptor.setSecurementPasswordType(passwordType);
                if (tokenCreated && tokenNonce) {
                    securityInterceptor.setSecurementUsernameTokenNonce(tokenNonce);
                    securityInterceptor.setSecurementUsernameTokenCreated(tokenCreated);
                }
                securityInterceptor.setValidateResponse(false);
                securityInterceptor.afterPropertiesSet();
                wsTemplate.setInterceptors(new ClientInterceptor[]{securityInterceptor});
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object getFault() {
        if (this.faultResolver != null) {
            return this.faultResolver.getFault();
        }
        return null;
    }

    public void resetFault() {
        if (this.faultResolver != null) {
            this.faultResolver.resetFault();
        }
    }

    class UnmarshallingFaultMessageResolver
    implements FaultMessageResolver {
        private Unmarshaller unmarshaller;
        private Object fault;

        public UnmarshallingFaultMessageResolver(Unmarshaller unmarshaller) {
            this.unmarshaller = unmarshaller;
        }

        public Object getFault() {
            return this.fault;
        }

        public void resetFault() {
            this.fault = null;
        }

        public void resolveFault(WebServiceMessage message) throws IOException {
            SoapFault soapFault = ((SoapMessage)message).getSoapBody().getFault();
            SoapFaultDetail detail = soapFault.getFaultDetail();
            if (detail != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Fault has detail");
                }
                SoapFaultDetailElement detailEntry = (SoapFaultDetailElement)detail.getDetailEntries().next();
                this.fault = this.unmarshaller.unmarshal(detailEntry.getSource());
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Fault String: " + soapFault.getFaultStringOrReason());
                }
                this.fault = new RuntimeException(soapFault.getFaultStringOrReason());
            }
        }
    }
}

