/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.webservice.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;

public class HeartBeat {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void testPulse(String endpointURL) {
        boolean heartbeat = false;
        try {
            URL url = new URL(endpointURL + ".wsdl");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "text/xml");
            conn.setReadTimeout(10000);
            if (conn.getResponseCode() == 200) {
                BufferedReader rdr = null;
                try {
                    String line;
                    StringBuffer wsdl = new StringBuffer();
                    rdr = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                    while ((line = rdr.readLine()) != null) {
                        wsdl.append(line);
                    }
                    if (wsdl.length() > 0) {
                        heartbeat = true;
                    }
                }
                finally {
                    if (rdr != null) {
                        try {
                            rdr.close();
                        }
                        catch (IOException wsdl) {}
                    }
                }
            }
            if (heartbeat) return;
            url = new URL(endpointURL);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Accept", "text/xml");
            conn.setReadTimeout(10000);
            conn.setDoOutput(true);
            String data = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
            data = data + "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\">";
            data = data + "<SOAP-ENV:Body/>";
            data = data + "</SOAP-ENV:Envelope>";
            OutputStreamWriter wr = null;
            BufferedReader rdr = null;
            try {
                wr = new OutputStreamWriter(conn.getOutputStream());
                wr.write(data);
                wr.flush();
                switch (conn.getResponseCode()) {
                    case 200: {
                        heartbeat = true;
                        return;
                    }
                    case 500: {
                        rdr = new BufferedReader(new InputStreamReader(conn.getErrorStream(), "UTF-8"));
                        StringBuffer errorBuf = new StringBuffer();
                        while (true) {
                            String line;
                            if ((line = rdr.readLine()) == null) {
                                String errorStr = errorBuf.toString();
                                int index = errorStr.indexOf("service cannot be found");
                                if (index != -1) return;
                                heartbeat = true;
                                return;
                            }
                            errorBuf.append(line);
                        }
                    }
                }
                return;
            }
            finally {
                if (wr != null) {
                    try {
                        wr.close();
                    }
                    catch (IOException iOException) {}
                }
                if (rdr != null) {
                    try {
                        rdr.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

