/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio;

import com.healthmarketscience.rmiio.EncodingRemoteIteratorServer;
import com.healthmarketscience.rmiio.IOIterator;
import com.healthmarketscience.rmiio.RemoteInputStreamServer;
import com.healthmarketscience.rmiio.RemoteStreamMonitor;
import com.healthmarketscience.rmiio.RmiioUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialRemoteIteratorServer<DataType>
extends EncodingRemoteIteratorServer<DataType> {
    public static final int DEFAULT_RESET_NUM_OBJECTS = 1000;
    private ObjectOutputStream _objOStream;
    private final IOIterator<DataType> _localIterator;
    private int _numObjectsWrittenSinceLastReset;
    private final int _resetNumObjects;

    public SerialRemoteIteratorServer(Iterator<DataType> localIterator) throws IOException {
        this(true, localIterator);
    }

    public SerialRemoteIteratorServer(boolean useCompression, Iterator<DataType> localIterator) throws IOException {
        this(useCompression, false, localIterator);
    }

    public SerialRemoteIteratorServer(boolean useCompression, boolean noDelay, Iterator<DataType> localIterator) throws IOException {
        this(useCompression, noDelay, RemoteInputStreamServer.DUMMY_MONITOR, localIterator);
    }

    public SerialRemoteIteratorServer(boolean useCompression, RemoteStreamMonitor<RemoteInputStreamServer> monitor, Iterator<DataType> localIterator) throws IOException {
        this(useCompression, false, monitor, localIterator);
    }

    public SerialRemoteIteratorServer(boolean useCompression, boolean noDelay, RemoteStreamMonitor<RemoteInputStreamServer> monitor, Iterator<DataType> localIterator) throws IOException {
        this(useCompression, noDelay, monitor, 7168, localIterator);
    }

    public SerialRemoteIteratorServer(boolean useCompression, boolean noDelay, RemoteStreamMonitor<RemoteInputStreamServer> monitor, int chunkSize, Iterator<DataType> localIterator) throws IOException {
        this(useCompression, noDelay, monitor, chunkSize, RmiioUtil.adapt(localIterator));
    }

    public SerialRemoteIteratorServer(IOIterator<DataType> localIterator) throws IOException {
        this(true, localIterator);
    }

    public SerialRemoteIteratorServer(boolean useCompression, IOIterator<DataType> localIterator) throws IOException {
        this(useCompression, false, localIterator);
    }

    public SerialRemoteIteratorServer(boolean useCompression, boolean noDelay, IOIterator<DataType> localIterator) throws IOException {
        this(useCompression, noDelay, RemoteInputStreamServer.DUMMY_MONITOR, localIterator);
    }

    public SerialRemoteIteratorServer(boolean useCompression, RemoteStreamMonitor<RemoteInputStreamServer> monitor, IOIterator<DataType> localIterator) throws IOException {
        this(useCompression, false, monitor, localIterator);
    }

    public SerialRemoteIteratorServer(boolean useCompression, boolean noDelay, RemoteStreamMonitor<RemoteInputStreamServer> monitor, IOIterator<DataType> localIterator) throws IOException {
        this(useCompression, noDelay, monitor, 7168, localIterator);
    }

    public SerialRemoteIteratorServer(boolean useCompression, boolean noDelay, RemoteStreamMonitor<RemoteInputStreamServer> monitor, int chunkSize, IOIterator<DataType> localIterator) throws IOException {
        this(useCompression, noDelay, monitor, chunkSize, localIterator, 1000);
    }

    public SerialRemoteIteratorServer(boolean useCompression, boolean noDelay, RemoteStreamMonitor<RemoteInputStreamServer> monitor, int chunkSize, IOIterator<DataType> localIterator, int resetNumObjects) throws IOException {
        super(useCompression, noDelay, monitor, chunkSize);
        if (localIterator == null) {
            throw new IllegalArgumentException("Iterator cannot be null");
        }
        this._localIterator = localIterator;
        this._resetNumObjects = resetNumObjects;
    }

    @Override
    protected boolean writeNextObject() throws IOException {
        if (this._objOStream == null) {
            this._objOStream = new ObjectOutputStream(this._localOStream);
        }
        if (this._localIterator.hasNext()) {
            this.serializeObject(this._objOStream, this._localIterator.next());
            return true;
        }
        return false;
    }

    @Override
    protected void closeIterator() throws IOException {
        if (this._objOStream != null) {
            this._objOStream.close();
        }
        super.closeIterator();
    }

    @Override
    protected void closeImpl(boolean readSuccess) throws IOException {
        if (this._localIterator instanceof Closeable) {
            RmiioUtil.closeQuietly((Closeable)((Object)this._localIterator));
        }
        super.closeImpl(readSuccess);
    }

    protected void serializeObject(ObjectOutputStream ostream, Object obj) throws IOException {
        ostream.writeUnshared(obj);
        ++this._numObjectsWrittenSinceLastReset;
        if (this._numObjectsWrittenSinceLastReset >= this._resetNumObjects) {
            ostream.reset();
            this._numObjectsWrittenSinceLastReset = 0;
        }
    }
}

