/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.AuthenticatorFactory;
import com.sas.launcher.client.Client;
import com.sas.launcher.client.Consumer;
import com.sas.launcher.client.Credential;
import com.sas.launcher.client.DeletePacket;
import com.sas.launcher.client.Error;
import com.sas.launcher.client.ErrorPacket;
import com.sas.launcher.client.Function;
import com.sas.launcher.client.GridInfo;
import com.sas.launcher.client.GridInfoPacket;
import com.sas.launcher.client.GridInfoRequest;
import com.sas.launcher.client.GridInfoRequestPacket;
import com.sas.launcher.client.InitPacket;
import com.sas.launcher.client.KillPacket;
import com.sas.launcher.client.LaunchPacket;
import com.sas.launcher.client.LaunchRequest;
import com.sas.launcher.client.LauncherClientAuthenticationException;
import com.sas.launcher.client.LauncherClientDisconnectedException;
import com.sas.launcher.client.LauncherClientException;
import com.sas.launcher.client.LauncherProcessTerminatedException;
import com.sas.launcher.client.Optional;
import com.sas.launcher.client.Packet;
import com.sas.launcher.client.PingPacket;
import com.sas.launcher.client.Process;
import com.sas.launcher.client.ProcessPacket;
import com.sas.launcher.client.Product;
import com.sas.launcher.client.ProductInfoRequest;
import com.sas.launcher.client.ProductInfoRequestPacket;
import com.sas.launcher.client.ProductPacket;
import com.sas.launcher.client.Server;
import com.sas.launcher.client.ServerAvailable;
import com.sas.launcher.client.ServerInfo;
import com.sas.launcher.client.ServerInfoPacket;
import com.sas.launcher.client.ServerInfoRequestPacket;
import com.sas.launcher.client.SocketFactory;
import com.sas.launcher.client.StatusPacket;
import com.sas.launcher.client.Supplier;
import com.sas.launcher.client.TermPacket;
import java.io.IOException;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TKClient
implements Client {
    private static final Logger logger = LoggerFactory.getLogger(TKClient.class);
    private final SocketFactory socketFactory;
    private final AuthenticatorFactory authenticatorFactory;
    private Connection connection;

    private TKClient(SocketFactory socketFactory, AuthenticatorFactory authenticatorFactory) {
        this.socketFactory = socketFactory;
        this.authenticatorFactory = authenticatorFactory;
    }

    static TKClient create(SocketFactory socketFactory, AuthenticatorFactory authenticatorFactory) {
        return new TKClient(socketFactory, authenticatorFactory);
    }

    private Connection getConnection() {
        return this.connection;
    }

    @Override
    public synchronized void connect(Server server, Credential credential) {
        this.disconnect();
        this.connection = new Connection(server, credential);
    }

    @Override
    public synchronized void disconnect() {
        Optional.ofNullable(this.connection).ifPresent(new Consumer<Connection>(){

            @Override
            public void accept(Connection connection) {
                connection.terminate();
            }
        });
        this.connection = null;
    }

    @Override
    public synchronized Process launch(LaunchRequest launchRequest) throws LauncherClientDisconnectedException {
        Process process;
        Connection connection = this.getConnection();
        if (connection == null) {
            throw new LauncherClientDisconnectedException(Error.Type.CLIENT_DISCONNECTED_ERROR.toError(new Object[0]));
        }
        try {
            logger.debug("Sending process launch request to Launcher Server: {}", new Object[]{launchRequest});
            LaunchPacket requestPacket = LaunchPacket.builder(launchRequest.getLaunchType()).command(launchRequest.getCommand()).environment(launchRequest.getEnvironment()).properties(launchRequest.getServerProperties()).build();
            connection.writePacket(requestPacket);
            ProcessPacket responsePacket = (ProcessPacket)connection.readPacket();
            process = Process.builder().launchType(launchRequest.getLaunchType()).command(launchRequest.getCommand()).environment(launchRequest.getEnvironment()).serverProperties(launchRequest.getServerProperties()).host(responsePacket.getHost().orElse(null)).uuid(responsePacket.getUuid()).luid(responsePacket.getLuid()).state(responsePacket.getState()).submitTime(responsePacket.getSubmitTime()).startTime(responsePacket.getStartTime()).endTime(responsePacket.getEndTime()).exitCode(responsePacket.getExitCode()).build();
            logger.debug("Received process object from Launcher Server: {}", (Object)process);
        }
        catch (Throwable cause) {
            logger.debug("Failed to launch process: " + cause.getMessage(), cause);
            throw new LauncherClientException(Error.Type.CLIENT_LAUNCH_ERROR.toError(new Object[0]), cause);
        }
        return process;
    }

    @Override
    public synchronized Boolean ping() throws LauncherClientDisconnectedException {
        Connection connection = this.getConnection();
        ServerAvailable serverAvailable = ServerAvailable.FALSE;
        if (connection == null) {
            throw new LauncherClientDisconnectedException(Error.Type.CLIENT_DISCONNECTED_ERROR.toError(new Object[0]));
        }
        try {
            logger.debug("Sending ping request to Launcher Server.");
            PingPacket requestPacket = PingPacket.create();
            connection.writePacket(requestPacket);
            Packet responsePacket = connection.readPacket();
            if (responsePacket.isOKPacket().booleanValue()) {
                logger.trace("Launcher Server successfully responded to ping request.");
                serverAvailable = ServerAvailable.TRUE;
            } else {
                logger.trace("Launcher Server failed to respond to ping request.");
            }
        }
        catch (Throwable cause) {
            logger.debug("Failed to ping Launcher Server: " + cause.getMessage(), cause);
            throw new LauncherClientException(Error.Type.CLIENT_PING_ERROR.toError(new Object[0]), cause);
        }
        return serverAvailable.isAvailable();
    }

    @Override
    public synchronized void kill(Process process) throws LauncherClientDisconnectedException, LauncherProcessTerminatedException {
        Connection connection = this.getConnection();
        if (process.hasTerminated().booleanValue()) {
            throw new LauncherProcessTerminatedException(Error.Type.PROCESS_NOT_KILLABLE.toError(process.getId(), process.getState().getName()));
        }
        if (connection == null) {
            throw new LauncherClientDisconnectedException(Error.Type.CLIENT_DISCONNECTED_ERROR.toError(new Object[0]));
        }
        try {
            logger.debug("Sending process kill request to Launcher Server: {}", new Object[]{process});
            KillPacket requestPacket = KillPacket.create(process.getLaunchType(), process.getUuid(), process.getServerProperties());
            connection.writePacket(requestPacket);
            Packet responsePacket = connection.readPacket();
            if (!responsePacket.isOKPacket().booleanValue()) {
                throw new LauncherClientException(Error.Type.INVALID_SERVER_RESPONSE_ERROR.toError(new Object[0]));
            }
        }
        catch (Throwable cause) {
            logger.debug("Failed to kill process: " + cause.getMessage(), cause);
            throw new LauncherClientException(Error.Type.CLIENT_KILL_ERROR.toError(new Object[0]), cause);
        }
    }

    @Override
    public synchronized void delete(Process process) throws LauncherClientDisconnectedException {
        Connection connection = this.getConnection();
        if (!process.isDirectLaunch().booleanValue()) {
            return;
        }
        if (connection == null) {
            throw new LauncherClientDisconnectedException(Error.Type.CLIENT_DISCONNECTED_ERROR.toError(new Object[0]));
        }
        try {
            logger.debug("Sending process delete request to Launcher Server: {}", new Object[]{process});
            DeletePacket requestPacket = DeletePacket.create(process.getLaunchType(), process.getUuid(), process.getServerProperties());
            connection.writePacket(requestPacket);
            Packet responsePacket = connection.readPacket();
            if (!responsePacket.isOKPacket().booleanValue()) {
                throw new LauncherClientException(Error.Type.INVALID_SERVER_RESPONSE_ERROR.toError(new Object[0]));
            }
        }
        catch (Throwable cause) {
            logger.debug("Failed to delete process: " + cause.getMessage(), cause);
            throw new LauncherClientException(Error.Type.CLIENT_DELETE_ERROR.toError(new Object[0]), cause);
        }
    }

    @Override
    public synchronized Process status(Process process) throws LauncherClientDisconnectedException {
        Connection connection = this.getConnection();
        if (connection == null) {
            throw new LauncherClientDisconnectedException(Error.Type.CLIENT_DISCONNECTED_ERROR.toError(new Object[0]));
        }
        try {
            logger.debug("Sending process status request to Launcher Server: {}", new Object[]{process});
            StatusPacket requestPacket = StatusPacket.create(process.getLaunchType(), process.getUuid(), process.getServerProperties());
            connection.writePacket(requestPacket);
            ProcessPacket responsePacket = (ProcessPacket)connection.readPacket();
            process.setState(responsePacket.getState()).setHost(responsePacket.getHost().orElse(null)).setUuid(responsePacket.getUuid()).setLuid(responsePacket.getLuid()).setSubmitTime(responsePacket.getSubmitTime()).setStartTime(responsePacket.getStartTime()).setEndTime(responsePacket.getEndTime()).setExitCode(responsePacket.getExitCode());
            logger.debug("Updated process object from Launcher Server: {}", (Object)process);
            if (process.isDirectLaunch().booleanValue() && process.hasTerminated().booleanValue() && process.getState().isNotServerError()) {
                this.delete(process);
            }
        }
        catch (LauncherClientDisconnectedException cause) {
            logger.debug("Failed to get process status: " + cause.getMessage(), (Throwable)cause);
            throw cause;
        }
        catch (Throwable cause) {
            logger.debug("Failed to get process status: " + cause.getMessage(), cause);
            throw new LauncherClientException(Error.Type.CLIENT_STATUS_ERROR.toError(new Object[0]), cause);
        }
        return process;
    }

    @Override
    public synchronized GridInfo gridInfo(GridInfoRequest gridInfoRequest) throws LauncherClientDisconnectedException {
        GridInfo gridInfo;
        Connection connection = this.getConnection();
        if (connection == null) {
            throw new LauncherClientDisconnectedException(Error.Type.CLIENT_DISCONNECTED_ERROR.toError(new Object[0]));
        }
        try {
            logger.debug("Sending Grid info request to Launcher Server: {}", (Object)gridInfoRequest);
            GridInfoRequestPacket requestPacket = GridInfoRequestPacket.create(gridInfoRequest.getServerProperties());
            connection.writePacket(requestPacket);
            GridInfoPacket responsePacket = (GridInfoPacket)connection.readPacket();
            gridInfo = GridInfo.create(responsePacket.getHosts(), responsePacket.getMaxProcessingUnits());
            logger.debug("Received Grid info object from Launcher Server: {}", (Object)gridInfo);
        }
        catch (Throwable cause) {
            logger.debug("Failed to get Grid info: " + cause.getMessage(), cause);
            throw new LauncherClientException(Error.Type.CLIENT_GRIDINFO_ERROR.toError(new Object[0]), cause);
        }
        return gridInfo;
    }

    @Override
    public synchronized ServerInfo serverInfo() throws LauncherClientDisconnectedException {
        ServerInfo serverInfo;
        Connection connection = this.getConnection();
        if (connection == null) {
            throw new LauncherClientDisconnectedException(Error.Type.CLIENT_DISCONNECTED_ERROR.toError(new Object[0]));
        }
        try {
            logger.debug("Sending server info request to Launcher Server.");
            ServerInfoRequestPacket requestPacket = ServerInfoRequestPacket.create();
            connection.writePacket(requestPacket);
            ServerInfoPacket responsePacket = (ServerInfoPacket)connection.readPacket();
            serverInfo = ServerInfo.create(responsePacket.getOperatingSystem());
            logger.debug("Received server info object from Launcher Server: {}", (Object)serverInfo);
        }
        catch (Throwable cause) {
            logger.debug("Failed to get Launcher Server info: " + cause.getMessage(), cause);
            throw new LauncherClientException(Error.Type.CLIENT_SERVERINFO_ERROR.toError(new Object[0]), cause);
        }
        return serverInfo;
    }

    @Override
    public synchronized Product productInfo(ProductInfoRequest productInfoRequest) throws LauncherClientDisconnectedException {
        Product product;
        Connection connection = this.getConnection();
        if (connection == null) {
            throw new LauncherClientDisconnectedException(Error.Type.CLIENT_DISCONNECTED_ERROR.toError(new Object[0]));
        }
        try {
            logger.debug("Sending license info request to Launcher Server.");
            ProductInfoRequestPacket requestPacket = ProductInfoRequestPacket.create(productInfoRequest.getProductCode());
            connection.writePacket(requestPacket);
            ProductPacket responsePacket = (ProductPacket)connection.readPacket();
            product = Product.create(responsePacket.getProductCode(), responsePacket.getLicensed());
            logger.debug("Received license info object from Launcher Server: {}", (Object)product);
        }
        catch (Throwable cause) {
            logger.debug("Failed to get product info: " + cause.getMessage(), cause);
            throw new LauncherClientException(Error.Type.CLIENT_PRODUCT_INFO_ERROR.toError(new Object[0]), cause);
        }
        return product;
    }

    class Connection {
        private Socket socket;

        Connection(final Server server, Credential credential) throws LauncherClientException {
            try {
                logger.debug("Establishing connection to Launcher Server: server={}", (Object)server);
                this.socket = TKClient.this.socketFactory.createSocket(server.getHost(), server.getPort(), server.isSSLEnabled());
                Supplier<Server> serverSupplier = new Supplier<Server>(){

                    @Override
                    public Server get() {
                        return server;
                    }
                };
                Consumer<Packet> packetWriter = new Consumer<Packet>(){

                    @Override
                    public void accept(Packet packet) {
                        Connection.this.writePacket(packet);
                    }
                };
                Supplier<Packet> packetReader = new Supplier<Packet>(){

                    @Override
                    public Packet get() {
                        return Connection.this.readPacket();
                    }
                };
                InitPacket initPacket = InitPacket.create();
                this.writePacket(initPacket);
                Packet responsePacket = this.readPacket();
                if (responsePacket.isAuthRequiredPacket().booleanValue()) {
                    logger.debug("Authenticating to Launcher Server.");
                    TKClient.this.authenticatorFactory.create(credential, serverSupplier, packetWriter, packetReader).authenticate();
                    responsePacket = this.readPacket();
                    if (!responsePacket.isReadyPacket().booleanValue()) {
                        logger.debug("Unexpected packet type received from Launcher Server: expectedPacketType={} actualPacketType={}", (Object)Packet.Type.READY.name(), (Object)responsePacket.getType().name());
                        throw new LauncherClientException(Error.Type.UNEXPECTED_PACKET_TYPE.toError(responsePacket.getType().name()));
                    }
                } else if (!responsePacket.isReadyPacket().booleanValue()) {
                    logger.debug("Unexpected packet type received from Launcher Server: expectedPacketType={} actualPacketType={}", (Object)Packet.Type.READY.name(), (Object)responsePacket.getType().name());
                    throw new LauncherClientException(Error.Type.UNEXPECTED_PACKET_TYPE.toError(responsePacket.getType().name()));
                }
            }
            catch (LauncherClientAuthenticationException cause) {
                logger.debug("Failed to connect to Launcher Server: " + cause.getMessage(), (Throwable)cause);
                throw cause;
            }
            catch (Throwable cause) {
                logger.debug("Failed to connect to Launcher Server: " + cause.getMessage(), cause);
                this.terminate();
                throw new LauncherClientException(Error.Type.CLIENT_CONNECT_ERROR.toError(new Object[0]), cause);
            }
        }

        private void terminate() {
            Boolean socketConnected = Optional.ofNullable(this.socket).map(new Function<Socket, Boolean>(){

                @Override
                public Boolean apply(Socket socket) {
                    return socket.isConnected();
                }
            }).orElse(false);
            if (!socketConnected.booleanValue()) {
                logger.debug("Launcher Server connection termination not required since socket connection has not been established.");
                return;
            }
            logger.debug("Terminating connection to Launcher Server.");
            try {
                TermPacket termPacket = TermPacket.create();
                this.writePacket(termPacket);
                logger.trace("Flushing Launcher Server connection output stream.");
                this.socket.getOutputStream().flush();
            }
            catch (IOException cause) {
                logger.debug("Failed to terminate connection to Launcher Server: " + cause.getMessage(), (Throwable)cause);
            }
            finally {
                logger.trace("Closing Launcher Server socket connection.");
                try {
                    this.socket.close();
                }
                catch (IOException cause) {
                    logger.debug("Failed to close socket: " + cause.getMessage(), (Throwable)cause);
                }
            }
        }

        private Packet readPacket() throws LauncherClientException {
            Packet responsePacket;
            try {
                logger.debug("Reading response packet from Launcher Server.");
                responsePacket = Packet.read(this.socket.getInputStream());
                logger.debug("Received {} packet from Launcher Server.", (Object)responsePacket.getType().name());
                if (responsePacket.isErrorPacket().booleanValue()) {
                    ErrorPacket errorPacket = (ErrorPacket)responsePacket;
                    String status = errorPacket.getStatusAsString();
                    String messages = errorPacket.getMessagesAsString();
                    if (errorPacket.getStatus().equals(-2134912768)) {
                        throw new LauncherClientAuthenticationException(Error.Type.SERVER_ERROR.toError(status, messages));
                    }
                    throw new LauncherClientException(Error.Type.SERVER_ERROR.toError(status, messages));
                }
            }
            catch (LauncherClientException cause) {
                logger.debug("Failed to read packet: " + cause.getMessage(), (Throwable)cause);
                throw cause;
            }
            catch (Throwable cause) {
                logger.debug("Failed to read packet: " + cause.getMessage(), cause);
                throw new LauncherClientException(Error.Type.PACKET_READ_ERROR.toError(new Object[0]), cause);
            }
            return responsePacket;
        }

        private void writePacket(Packet packet) throws LauncherClientException {
            try {
                logger.debug("Sending {} packet to Launcher Server.", (Object)packet.getType().name());
                this.socket.getOutputStream().write(packet.serialize());
            }
            catch (Throwable cause) {
                logger.debug("Failed to write packet: " + cause.getMessage(), cause);
                throw new LauncherClientException(Error.Type.PACKET_WRITE_ERROR.toError(new Object[0]), cause);
            }
        }
    }
}

