/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Host;
import com.sas.launcher.client.LauncherClientConfiguration;
import com.sas.launcher.client.Password;
import com.sas.launcher.client.Port;
import com.sas.launcher.client.SSLSocketFactoryBuilder;
import com.sas.launcher.client.SSLSocketFactoryInitException;
import com.sas.launcher.client.Supplier;
import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SocketFactory {
    private static final Logger logger = LoggerFactory.getLogger(SocketFactory.class);
    private final javax.net.SocketFactory socketFactory;
    private final SSLSocketFactory sslSocketFactory;

    private SocketFactory(LauncherClientConfiguration launcherClientConfiguration, Supplier<javax.net.SocketFactory> socketFactorySupplier, SSLSocketFactoryBuilder sslSocketFactoryBuilder) throws SSLSocketFactoryInitException {
        this.socketFactory = socketFactorySupplier.get();
        try {
            String sslProtocol = launcherClientConfiguration.getSSLProtocol();
            String sslTrustManagerAlgorithm = launcherClientConfiguration.getSSLTrustManagerAlgorithm();
            String sslTrustStoreType = launcherClientConfiguration.getSSLTrustStoreType();
            String sslTrustStorePath = launcherClientConfiguration.getSSLTrustStorePath().orElse(null);
            Password sslTrustStorePassword = launcherClientConfiguration.getSSLTrustStorePassword().orElse(null);
            this.sslSocketFactory = sslSocketFactoryBuilder.getInstance().sslProtocol(sslProtocol).sslTrustManagerAlgorithm(sslTrustManagerAlgorithm).sslTrustStoreType(sslTrustStoreType).sslTrustStorePath(sslTrustStorePath).sslTrustStorePassword(sslTrustStorePassword).build();
        }
        catch (Exception cause) {
            logger.debug("Failed to create socket factory object: " + cause.getMessage(), (Throwable)cause);
            throw new SSLSocketFactoryInitException(cause);
        }
    }

    static SocketFactory create(LauncherClientConfiguration launcherClientConfiguration, Supplier<javax.net.SocketFactory> socketFactorySupplier, SSLSocketFactoryBuilder sslSocketFactoryBuilder) {
        return new SocketFactory(launcherClientConfiguration, socketFactorySupplier, sslSocketFactoryBuilder);
    }

    Socket createSocket(Host host, Port port, Boolean sslEnabled) throws IOException {
        Socket socket = sslEnabled == false ? this.socketFactory.createSocket(host.getName(), (int)port.getPort()) : this.sslSocketFactory.createSocket(host.getName(), (int)port.getPort());
        socket.setSoLinger(true, 10);
        socket.setReuseAddress(true);
        socket.setTcpNoDelay(true);
        socket.setKeepAlive(true);
        return socket;
    }
}

