/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Error;
import com.sas.launcher.client.LauncherRuntimeException;
import com.sas.launcher.client.Objects;

class ProductCode {
    private final Integer value;

    private ProductCode(Integer value) {
        if (value == null) {
            throw new LauncherRuntimeException(Error.Type.INVALID_PRODUCT_CODE.toError(value));
        }
        this.value = value;
    }

    static ProductCode create(Integer value) {
        return new ProductCode(value);
    }

    public Integer getValue() {
        return this.value;
    }

    public String toString() {
        return "ProductCode{value=" + this.value + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductCode that = (ProductCode)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

