/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Objects;
import com.sas.launcher.client.ProductCode;

public class Product {
    private final ProductCode code;
    private final Boolean licensed;

    private Product(Builder builder) {
        this.code = builder.productCode;
        this.licensed = builder.licensed != null && builder.licensed != false;
    }

    static Builder builder(ProductCode productCode) {
        return new Builder(productCode);
    }

    static Product create(ProductCode productCode) {
        return Product.create(productCode, false);
    }

    static Product create(ProductCode productCode, Boolean licensed) {
        return Product.builder(productCode).licensed(licensed).build();
    }

    public String toString() {
        return "Product{code=" + this.code + ", licensed=" + this.licensed + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Product product = (Product)o;
        return Objects.equals(this.code, product.code) && Objects.equals(this.licensed, product.licensed);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.licensed);
    }

    public Integer getCode() {
        return this.code.getValue();
    }

    public Boolean isLicensed() {
        return this.licensed;
    }

    static class Builder {
        private final ProductCode productCode;
        private Boolean licensed;

        private Builder(ProductCode productCode) {
            this.productCode = productCode;
        }

        Builder licensed(Boolean licensed) {
            this.licensed = licensed;
            return this;
        }

        Product build() {
            return new Product(this);
        }
    }
}

