/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Error;
import com.sas.launcher.client.LauncherRuntimeException;

public enum ProcessState {
    PENDING("pending", 0),
    RUNNING("running", 1),
    COMPLETED("completed", 2),
    FAILED("failed", 3),
    SERVER_ERROR("serverError", 5),
    UNKNOWN("unknown", 6);

    private final String name;
    private final Integer id;

    private ProcessState(String name, Integer id) {
        this.name = name;
        this.id = id;
    }

    static ProcessState fromString(String value) {
        for (ProcessState processState : ProcessState.values()) {
            if (!processState.getName().equals(value)) continue;
            return processState;
        }
        throw new LauncherRuntimeException(Error.Type.INVALID_PROCESS_STATE.toError(value));
    }

    static ProcessState fromInteger(Integer value) {
        for (ProcessState processState : ProcessState.values()) {
            if (!processState.getId().equals(value)) continue;
            return processState;
        }
        throw new LauncherRuntimeException(Error.Type.INVALID_PROCESS_STATE_ID.toError(value));
    }

    String getName() {
        return this.name;
    }

    Integer getId() {
        return this.id;
    }

    boolean isTerminal() {
        return this.equals((Object)COMPLETED) || this.equals((Object)FAILED) || this.equals((Object)SERVER_ERROR);
    }

    boolean isNotServerError() {
        return !this.equals((Object)SERVER_ERROR);
    }

    public String toString() {
        return "ProcessState{name='" + this.name + '\'' + ", id=" + this.id + '}';
    }
}

