/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Error;
import com.sas.launcher.client.Function;
import com.sas.launcher.client.LauncherRuntimeException;
import com.sas.launcher.client.Objects;
import com.sas.launcher.client.Optional;
import com.sas.launcher.client.Predicate;
import com.sas.launcher.client.Supplier;

class Port {
    static final Integer MINIMUM = 0;
    static final Integer MAXIMUM = 65535;
    private final Integer port;

    private Port(final Integer port) {
        this.port = Optional.of(Optional.ofNullable(port).orElse(0)).filter(new Predicate<Integer>(){

            @Override
            public boolean test(Integer port) {
                return port >= MINIMUM;
            }
        }).filter(new Predicate<Integer>(){

            @Override
            public boolean test(Integer port) {
                return port <= MAXIMUM;
            }
        }).orElseThrow(new Supplier<LauncherRuntimeException>(){

            @Override
            public LauncherRuntimeException get() {
                return new LauncherRuntimeException(Error.Type.INVALID_PORT.toError(port, MINIMUM, MAXIMUM));
            }
        });
    }

    static Port create(Integer port) {
        return new Port(port);
    }

    static Port create(String port) {
        return Port.create(Optional.ofNullable(port).map(new Function<String, Integer>(){

            @Override
            public Integer apply(String port) {
                return Integer.parseInt(port);
            }
        }).orElse(null));
    }

    Integer getPort() {
        return this.port;
    }

    public String toString() {
        return "Port{port=" + this.port + '}';
    }

    String getPortString() {
        return this.getPort().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Port port1 = (Port)o;
        return Objects.equals(this.port, port1.port);
    }

    public int hashCode() {
        return Objects.hash(this.port);
    }
}

