/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Error;
import com.sas.launcher.client.LauncherRuntimeException;
import com.sas.launcher.client.Objects;
import com.sas.launcher.client.Optional;
import com.sas.launcher.client.Supplier;
import com.sas.util.BASE64;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SealedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Password {
    private static final Logger logger = LoggerFactory.getLogger(Password.class);
    private static final String DEFAULT_KEY_GENERATOR_ALGORITHM = "AES";
    private static final Integer DEFAULT_KEY_SIZE = 128;
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    private final Key key;
    private final SealedObject password;

    private Password(String password, String keyGeneratorAlgorithm, Integer keySize, String cipherAlgorithm) {
        Optional.ofNullable(password).orElseThrow(new Supplier<LauncherRuntimeException>(){

            @Override
            public LauncherRuntimeException get() {
                return new LauncherRuntimeException(Error.Type.NULL_PASSWORD_ERROR.toError(new Object[0]));
            }
        });
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(Optional.ofNullable(keyGeneratorAlgorithm).orElse(DEFAULT_KEY_GENERATOR_ALGORITHM));
            keyGenerator.init(Optional.ofNullable(keySize).orElse(DEFAULT_KEY_SIZE));
            this.key = keyGenerator.generateKey();
            Cipher cipher = Cipher.getInstance(Optional.ofNullable(cipherAlgorithm).orElse(DEFAULT_CIPHER_ALGORITHM));
            cipher.init(1, this.key);
            this.password = new SealedObject((Serializable)((Object)password), cipher);
        }
        catch (Throwable cause) {
            logger.debug("Failed to create password object: " + cause.getMessage(), cause);
            throw new LauncherRuntimeException(Error.Type.PASSWORD_ENCRYPTION_ERROR.toError(new Object[0]), cause);
        }
    }

    public static Password create(String password) {
        return Password.create(password, null, null, null);
    }

    static Password create(String password, String keyGeneratorAlgorithm, Integer keySize, String cipherAlgorithm) {
        return new Password(password, keyGeneratorAlgorithm, keySize, cipherAlgorithm);
    }

    String unseal() {
        try {
            return (String)this.password.getObject(this.key);
        }
        catch (Throwable cause) {
            logger.debug("Failed to unseal password: " + cause.getMessage(), cause);
            throw new LauncherRuntimeException(Error.Type.PASSWORD_DECRYPTION_ERROR.toError(new Object[0]), cause);
        }
    }

    String encode() {
        try {
            return BASE64.encode((byte[])this.unseal().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException cause) {
            logger.debug("Failed to encode password: " + cause.getMessage(), (Throwable)cause);
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Password password = (Password)o;
        return Objects.equals(this.encode(), password.encode());
    }

    public int hashCode() {
        return Objects.hash(this.encode());
    }
}

