/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.AuthenticatorFactory;
import com.sas.launcher.client.ClientFactory;
import com.sas.launcher.client.FileStreamFactory;
import com.sas.launcher.client.KerberosNegotiator;
import com.sas.launcher.client.LauncherClientConfiguration;
import com.sas.launcher.client.SSLObjectFactory;
import com.sas.launcher.client.SSLObjectUtils;
import com.sas.launcher.client.SSLSocketFactoryBuilder;
import com.sas.launcher.client.ServerFactory;
import com.sas.launcher.client.SocketFactory;
import com.sas.launcher.client.Supplier;
import com.sas.launcher.client.TKClientFactory;

class ObjectManager {
    private final ClientFactory clientFactory;
    private final ServerFactory serverFactory;

    private ObjectManager(LauncherClientConfiguration launcherClientConfiguration) {
        Supplier<javax.net.SocketFactory> socketFactorySupplier = new Supplier<javax.net.SocketFactory>(){

            @Override
            public javax.net.SocketFactory get() {
                return javax.net.SocketFactory.getDefault();
            }
        };
        SSLObjectFactory sslObjectFactory = SSLObjectFactory.create();
        SSLObjectUtils sslObjectUtils = SSLObjectUtils.create();
        FileStreamFactory fileStreamFactory = FileStreamFactory.create();
        KerberosNegotiator.ObjectFactory kerberosNegotiatorObjectFactory = KerberosNegotiator.ObjectFactory.create();
        this.serverFactory = ServerFactory.create();
        SSLSocketFactoryBuilder sslSocketFactoryBuilder = SSLSocketFactoryBuilder.create(sslObjectFactory, sslObjectUtils, fileStreamFactory);
        SocketFactory socketFactory = SocketFactory.create(launcherClientConfiguration, socketFactorySupplier, sslSocketFactoryBuilder);
        KerberosNegotiator kerberosNegotiator = KerberosNegotiator.create(kerberosNegotiatorObjectFactory);
        AuthenticatorFactory authenticatorFactory = AuthenticatorFactory.create(kerberosNegotiator);
        this.clientFactory = TKClientFactory.create(socketFactory, authenticatorFactory);
    }

    static ObjectManager create() {
        return ObjectManager.create(LauncherClientConfiguration.create());
    }

    static ObjectManager create(LauncherClientConfiguration launcherClientConfiguration) {
        return new ObjectManager(launcherClientConfiguration);
    }

    ClientFactory getClientFactory() {
        return this.clientFactory;
    }

    ServerFactory getServerFactory() {
        return this.serverFactory;
    }
}

