/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Client;
import com.sas.launcher.client.Host;
import com.sas.launcher.client.LaunchRequest;
import com.sas.launcher.client.LauncherClientDisconnectedException;
import com.sas.launcher.client.LauncherProcessTerminatedException;
import com.sas.launcher.client.ObjectManager;
import com.sas.launcher.client.OperatingSystem;
import com.sas.launcher.client.Password;
import com.sas.launcher.client.Port;
import com.sas.launcher.client.Process;
import com.sas.launcher.client.Product;
import com.sas.launcher.client.ProductInfoRequest;
import com.sas.launcher.client.Server;
import com.sas.launcher.client.ServerFactory;
import com.sas.launcher.client.UserPassCredential;

public class LauncherClient {
    private final ServerFactory serverFactory;
    private final Client client;

    private LauncherClient(ObjectManager objectManager) {
        this.serverFactory = objectManager.getServerFactory();
        this.client = objectManager.getClientFactory().create();
    }

    public static LauncherClient create() {
        return LauncherClient.create(ObjectManager.create());
    }

    static LauncherClient create(ObjectManager objectManager) {
        return new LauncherClient(objectManager);
    }

    public void connect(String host, Integer port, Boolean sslEnabled, String username, Password password) {
        Server server = this.serverFactory.create(Host.create(host), Port.create(port), sslEnabled);
        UserPassCredential userPassCredential = UserPassCredential.create(username, password);
        this.client.connect(server, userPassCredential);
    }

    public void disconnect() {
        this.client.disconnect();
    }

    public Process launch(LaunchRequest launchRequest) throws LauncherClientDisconnectedException {
        return this.client.launch(launchRequest);
    }

    public Process status(Process process) throws LauncherClientDisconnectedException {
        return this.client.status(process);
    }

    public void kill(Process process) throws LauncherClientDisconnectedException, LauncherProcessTerminatedException {
        this.client.kill(process);
    }

    public void delete(Process process) throws LauncherClientDisconnectedException {
        this.client.delete(process);
    }

    public OperatingSystem getServerOperatingSystem() throws LauncherClientDisconnectedException {
        return this.client.serverInfo().getOperatingSystem();
    }

    public Product productInfo(ProductInfoRequest productInfoRequest) throws LauncherClientDisconnectedException {
        return this.client.productInfo(productInfoRequest);
    }
}

