/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Command;
import com.sas.launcher.client.DirectLaunchPacket;
import com.sas.launcher.client.Environment;
import com.sas.launcher.client.GridLaunchPacket;
import com.sas.launcher.client.LaunchType;
import com.sas.launcher.client.Packet;
import com.sas.launcher.client.ServerProperties;

abstract class LaunchPacket
extends Packet {
    LaunchPacket() {
    }

    static Builder builder(LaunchType launchType) {
        return new Builder(launchType);
    }

    static final class Builder {
        private final LaunchType launchType;
        private Command command;
        private Environment environment;
        private ServerProperties properties;

        private Builder(LaunchType launchType) {
            this.launchType = launchType;
        }

        Builder command(Command command) {
            this.command = command;
            return this;
        }

        Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        Builder properties(ServerProperties properties) {
            this.properties = properties;
            return this;
        }

        LaunchPacket build() {
            if (this.launchType.isGrid()) {
                return GridLaunchPacket.builder().command(this.command).environment(this.environment).properties(this.properties).build();
            }
            return DirectLaunchPacket.builder().command(this.command).environment(this.environment).properties(this.properties).build();
        }
    }
}

