/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Error;
import com.sas.launcher.client.Function;
import com.sas.launcher.client.Host;
import com.sas.launcher.client.LauncherRuntimeException;
import com.sas.launcher.client.Objects;
import com.sas.launcher.client.Optional;
import com.sas.launcher.client.StringBuilder;
import com.sas.launcher.client.Supplier;
import org.apache.commons.lang3.StringUtils;

class KerberosSPN {
    private final String value;

    private KerberosSPN(final String value) {
        this.value = Optional.ofNullable(StringUtils.trimToNull((String)value)).orElseThrow(new Supplier<LauncherRuntimeException>(){

            @Override
            public LauncherRuntimeException get() {
                return new LauncherRuntimeException(Error.Type.INVALID_SERVICE_PRINCIPAL_NAME.toError(value));
            }
        });
    }

    private KerberosSPN(final String serviceClass, final Host host, String realm) {
        this.value = StringBuilder.getInstance().delimiter("@").add(StringBuilder.getInstance().delimiter("/").add(Optional.ofNullable(StringUtils.trimToNull((String)serviceClass)).orElseThrow(new Supplier<LauncherRuntimeException>(){

            @Override
            public LauncherRuntimeException get() {
                return new LauncherRuntimeException(Error.Type.INVALID_SERVICE_PRINCIPAL_NAME_SERVICE_CLASS.toError(serviceClass));
            }
        })).add(Optional.ofNullable(host).map(new Function<Host, String>(){

            @Override
            public String apply(Host host) {
                return host.getName();
            }
        }).orElseThrow(new Supplier<LauncherRuntimeException>(){

            @Override
            public LauncherRuntimeException get() {
                return new LauncherRuntimeException(Error.Type.INVALID_SERVICE_PRINCIPAL_NAME_HOST.toError(host));
            }
        })).build()).add(Optional.ofNullable(realm).map(new Function<String, String>(){

            @Override
            public String apply(String realm) {
                return StringUtils.upperCase((String)realm);
            }
        }).orElse(null)).build();
    }

    public static KerberosSPN create(String value) {
        return new KerberosSPN(value);
    }

    public static KerberosSPN create(String serviceClass, Host host) {
        return new KerberosSPN(serviceClass, host, null);
    }

    public static KerberosSPN create(String serviceClass, Host host, String realm) {
        return new KerberosSPN(serviceClass, host, realm);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "ServicePrincipalName{value='" + this.value + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KerberosSPN that = (KerberosSPN)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

