/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Error;
import com.sas.launcher.client.LauncherRuntimeException;
import com.sas.launcher.client.Objects;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Host {
    private static final Logger logger = LoggerFactory.getLogger(Host.class);
    private final InetAddress address;

    private Host(String hostname) {
        try {
            this.address = InetAddress.getByName(hostname);
        }
        catch (UnknownHostException cause) {
            logger.debug("Failed to create host object: " + cause.getMessage(), (Throwable)cause);
            throw new LauncherRuntimeException(Error.Type.INVALID_HOSTNAME.toError(hostname), (Throwable)cause);
        }
    }

    static Host create(String hostname) {
        return new Host(hostname);
    }

    String getAddress() {
        return this.address.getHostAddress();
    }

    String getName() {
        return this.address.getHostName();
    }

    public String toString() {
        return "Host{address=" + this.address + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Host host = (Host)o;
        return Objects.equals(this.address, host.address);
    }

    public int hashCode() {
        return Objects.hash(this.address);
    }
}

