/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Error;
import com.sas.launcher.client.LauncherRuntimeException;
import org.apache.commons.lang3.StringUtils;

public enum GridProvider {
    PLATFORM("platform", 0),
    YARN("yarn", 1);

    private final String name;
    private final Integer getId;

    private GridProvider(String name, int getId) {
        this.name = name;
        this.getId = getId;
    }

    static GridProvider fromString(String value) {
        for (GridProvider gridProvider : GridProvider.values()) {
            if (!gridProvider.getName().equals(value) && !gridProvider.getCanonicalName().equals(value)) continue;
            return gridProvider;
        }
        throw new LauncherRuntimeException(Error.Type.INVALID_GRID_PROVIDER.toError(value));
    }

    String getName() {
        return this.name;
    }

    public String toString() {
        return "GridProvider{name='" + this.name + '\'' + ", getId=" + this.getId + '}';
    }

    String getCanonicalName() {
        return StringUtils.capitalize((String)this.getName());
    }

    Integer getId() {
        return this.getId;
    }
}

