/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Packet;
import com.sas.launcher.client.ServerProperties;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;

final class GridInfoRequestPacket
extends Packet {
    private static final Charset charset = Charset.forName("UTF-8");
    private final ByteBuffer payload;

    private GridInfoRequestPacket(ServerProperties serverProperties) {
        ByteBuffer properties = this.writeMap(serverProperties.toMap());
        ByteBuffer payload = ByteBuffer.allocate(8 + properties.limit());
        payload.putInt(serverProperties.count());
        payload.putInt(properties.limit());
        payload.put(properties.array(), 0, properties.limit());
        this.payload = payload;
    }

    static GridInfoRequestPacket create(ServerProperties properties) {
        return new GridInfoRequestPacket(properties);
    }

    private ByteBuffer writeMap(Map<String, String> map) {
        Integer totalSize = 0;
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            ByteBuffer key = charset.encode(entry.getKey());
            ByteBuffer value = charset.encode(entry.getValue());
            Integer size = 8 + key.limit() + value.limit();
            ByteBuffer data = ByteBuffer.allocate(size);
            data.putInt(key.limit());
            data.putInt(value.limit());
            data.put(key.array(), 0, key.limit());
            data.put(value.array(), 0, value.limit());
            data.clear();
            buffers.add(data);
            totalSize = totalSize + size;
        }
        ByteBuffer result = ByteBuffer.allocate(totalSize);
        for (ByteBuffer buffer : buffers) {
            result.put(buffer.array(), 0, buffer.limit());
        }
        result.clear();
        return result;
    }

    @Override
    public ByteBuffer getPayload() {
        ByteBuffer payload = ByteBuffer.allocate(this.payload.limit());
        payload.put(this.payload.array(), 0, this.payload.limit());
        payload.clear();
        return payload.asReadOnlyBuffer();
    }

    public String toString() {
        return "GridInfoRequestPacket{payload=" + this.payload + '}';
    }
}

