/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Error;
import com.sas.launcher.client.Function;
import com.sas.launcher.client.GridArmCorrelator;
import com.sas.launcher.client.GridFlags;
import com.sas.launcher.client.GridHostList;
import com.sas.launcher.client.GridInitOptions;
import com.sas.launcher.client.GridJobName;
import com.sas.launcher.client.GridJobOptions;
import com.sas.launcher.client.GridProvider;
import com.sas.launcher.client.GridResources;
import com.sas.launcher.client.Host;
import com.sas.launcher.client.LauncherRuntimeException;
import com.sas.launcher.client.Optional;
import com.sas.launcher.client.Port;
import com.sas.launcher.client.Predicate;
import com.sas.launcher.client.ServerProperties;
import com.sas.launcher.client.Supplier;

public class GridInfoRequest {
    private final GridProvider gridProvider;
    private final Host gridServerHost;
    private final Port gridServerPort;
    private final GridInitOptions gridInitOptions;
    private final GridJobOptions gridJobOptions;
    private final GridResources gridResources;
    private final GridJobName gridJobName;
    private final GridArmCorrelator gridArmCorrelator;
    private final GridHostList gridHostList;
    private final GridFlags gridFlags;

    private GridInfoRequest(Builder builder) {
        this.gridProvider = builder.gridProvider;
        this.gridServerHost = builder.gridServerHost;
        this.gridServerPort = builder.gridServerPort;
        this.gridInitOptions = builder.gridInitOptions;
        this.gridJobOptions = builder.gridJobOptions;
        this.gridResources = builder.gridResources;
        this.gridJobName = builder.gridJobName;
        this.gridArmCorrelator = builder.gridArmCorrelator;
        this.gridHostList = builder.gridHostList;
        this.gridFlags = Optional.ofNullable(builder.gridFlagsBuilder).map(new Function<GridFlags.Builder, GridFlags>(){

            @Override
            public GridFlags apply(GridFlags.Builder builder) {
                return builder.build();
            }
        }).orElse(null);
    }

    public static Builder builder(GridProvider provider) {
        return new Builder(provider);
    }

    public static GridInfoRequest create(GridProvider provider) {
        return GridInfoRequest.builder(provider).build();
    }

    ServerProperties getServerProperties() {
        return ServerProperties.builder().grid(this.getProvider().orElse(null)).serverHost(this.getServerHost().orElse(null)).serverPort(this.getServerPort().orElse(null)).initOptions(this.getInitOptions().orElse(null)).jobOptions(this.getJobOptions().orElse(null)).jobName(this.getJobName().orElse(null)).resources(this.getResources().orElse(null)).armCorrelator(this.getArmCorrelator().orElse(null)).hostList(this.getHostList().orElse(null)).batchJob(Optional.of(this.isBatchJob()).filter(new Predicate<Boolean>(){

            @Override
            public boolean test(Boolean isGridBatchJob) {
                return isGridBatchJob;
            }
        }).orElse(null)).restartable(Optional.of(this.isRestartable()).filter(new Predicate<Boolean>(){

            @Override
            public boolean test(Boolean isGridRestartable) {
                return isGridRestartable;
            }
        }).orElse(null)).build();
    }

    private Optional<GridProvider> getProvider() {
        return Optional.ofNullable(this.gridProvider);
    }

    private Optional<Host> getServerHost() {
        return Optional.ofNullable(this.gridServerHost);
    }

    private Optional<Port> getServerPort() {
        return Optional.ofNullable(this.gridServerPort);
    }

    private Optional<GridInitOptions> getInitOptions() {
        return Optional.ofNullable(this.gridInitOptions);
    }

    private Optional<GridJobOptions> getJobOptions() {
        return Optional.ofNullable(this.gridJobOptions);
    }

    private Optional<GridResources> getResources() {
        return Optional.ofNullable(this.gridResources);
    }

    private Optional<GridJobName> getJobName() {
        return Optional.ofNullable(this.gridJobName);
    }

    private Optional<GridArmCorrelator> getArmCorrelator() {
        return Optional.ofNullable(this.gridArmCorrelator);
    }

    private Optional<GridHostList> getHostList() {
        return Optional.ofNullable(this.gridHostList);
    }

    private Boolean isBatchJob() {
        return Optional.ofNullable(this.gridFlags).map(new Function<GridFlags, Boolean>(){

            @Override
            public Boolean apply(GridFlags gridFlags) {
                return gridFlags.isBatchJob();
            }
        }).orElse(false);
    }

    private Boolean isRestartable() {
        return Optional.ofNullable(this.gridFlags).map(new Function<GridFlags, Boolean>(){

            @Override
            public Boolean apply(GridFlags gridFlags) {
                return gridFlags.isRestartable();
            }
        }).orElse(false);
    }

    public static class Builder {
        private final GridProvider gridProvider;
        private final GridFlags.Builder gridFlagsBuilder;
        private Host gridServerHost;
        private Port gridServerPort;
        private GridInitOptions gridInitOptions;
        private GridJobOptions gridJobOptions;
        private GridResources gridResources;
        private GridJobName gridJobName;
        private GridArmCorrelator gridArmCorrelator;
        private GridHostList gridHostList;

        private Builder(final GridProvider gridProvider) {
            this.gridProvider = Optional.ofNullable(gridProvider).orElseThrow(new Supplier<LauncherRuntimeException>(){

                @Override
                public LauncherRuntimeException get() {
                    return new LauncherRuntimeException(Error.Type.INVALID_GRID_PROVIDER.toError(new Object[]{gridProvider}));
                }
            });
            this.gridFlagsBuilder = GridFlags.builder();
        }

        public Builder serverHost(String gridServerHost) {
            this.gridServerHost = Host.create(gridServerHost);
            return this;
        }

        public Builder serverPort(Integer gridServerPort) {
            this.gridServerPort = Port.create(gridServerPort);
            return this;
        }

        public Builder initOptions(String gridInitOptions) {
            this.gridInitOptions = GridInitOptions.create(gridInitOptions);
            return this;
        }

        public Builder jobOptions(String gridJobOptions) {
            this.gridJobOptions = GridJobOptions.create(gridJobOptions);
            return this;
        }

        public Builder resources(String gridResources) {
            this.gridResources = GridResources.create(gridResources);
            return this;
        }

        public Builder jobName(String gridJobName) {
            this.gridJobName = GridJobName.create(gridJobName);
            return this;
        }

        public Builder armCorrelator(String gridArmCorrelator) {
            this.gridArmCorrelator = GridArmCorrelator.create(gridArmCorrelator);
            return this;
        }

        public Builder hostList(String gridHostList) {
            this.gridHostList = GridHostList.create(gridHostList);
            return this;
        }

        public Builder batchJob(Boolean gridBatchJob) {
            this.gridFlagsBuilder.batchJob(gridBatchJob);
            return this;
        }

        public Builder restartable(Boolean gridRestartable) {
            this.gridFlagsBuilder.restartable(gridRestartable);
            return this;
        }

        public GridInfoRequest build() {
            return new GridInfoRequest(this);
        }
    }
}

