/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Error;
import com.sas.launcher.client.LauncherRuntimeException;
import com.sas.launcher.client.Packet;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GridInfoPacket
extends Packet {
    private static final Logger logger = LoggerFactory.getLogger(GridInfoPacket.class);
    private final List<String> hosts;
    private final Integer maxProcessingUnits;
    private final ByteBuffer payload;

    private GridInfoPacket(InputStream stream) {
        try {
            DataInputStream dataStream = new DataInputStream(stream);
            Integer payloadSize = dataStream.readInt();
            byte[] data = new byte[payloadSize.intValue()];
            dataStream.read(data, 0, payloadSize);
            ByteBuffer buffer = ByteBuffer.wrap(data);
            String hosts = StringUtils.deleteWhitespace((String)GridInfoPacket.readString(buffer));
            Integer maxProcessingUnits = buffer.getInt();
            this.hosts = new ArrayList<String>();
            Collections.addAll(this.hosts, hosts.split(","));
            this.maxProcessingUnits = maxProcessingUnits;
            buffer.clear();
            this.payload = buffer;
        }
        catch (IOException cause) {
            logger.debug("Failed to read Grid info packet: " + cause.getMessage(), (Throwable)cause);
            throw new LauncherRuntimeException(Error.Type.PACKET_READ_ERROR.toError(new Object[0]), (Throwable)cause);
        }
    }

    static GridInfoPacket fromPacketPayload(InputStream stream) {
        return new GridInfoPacket(stream);
    }

    private static String readString(ByteBuffer buffer) {
        Integer stringSize = buffer.getInt();
        byte[] string = new byte[stringSize.intValue()];
        buffer.get(string, 0, stringSize);
        return new String(string);
    }

    List<String> getHosts() {
        return Collections.unmodifiableList(this.hosts);
    }

    Integer getMaxProcessingUnits() {
        return this.maxProcessingUnits;
    }

    @Override
    ByteBuffer getPayload() {
        return this.payload.asReadOnlyBuffer();
    }

    public String toString() {
        return "GridInfoPacket{hosts=" + this.hosts + ", maxProcessingUnits=" + this.maxProcessingUnits + ", payload=" + this.payload + '}';
    }
}

