/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Objects;
import com.sas.launcher.client.Optional;

class GridFlags {
    private final Boolean batchJob;
    private final Boolean restartable;

    private GridFlags() {
        this.batchJob = false;
        this.restartable = false;
    }

    private GridFlags(Builder builder) {
        this.batchJob = Optional.ofNullable(builder.batchJob).orElse(false);
        this.restartable = Optional.ofNullable(builder.restartable).orElse(false);
    }

    static GridFlags create() {
        return new GridFlags();
    }

    static Builder builder() {
        return new Builder();
    }

    Boolean isBatchJob() {
        return this.batchJob;
    }

    Boolean isRestartable() {
        return this.restartable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridFlags gridFlags = (GridFlags)o;
        return Objects.equals(this.batchJob, gridFlags.batchJob) && Objects.equals(this.restartable, gridFlags.restartable);
    }

    public int hashCode() {
        return Objects.hash(this.batchJob, this.restartable);
    }

    public String toString() {
        return "GridFlags{batchJob=" + this.batchJob + ", restartable=" + this.restartable + '}';
    }

    static class Builder {
        private Boolean batchJob = false;
        private Boolean restartable = false;

        private Builder() {
        }

        Builder batchJob(Boolean batchJob) {
            this.batchJob = batchJob;
            return this;
        }

        Builder restartable(Boolean restartable) {
            this.restartable = restartable;
            return this;
        }

        GridFlags build() {
            return new GridFlags(this);
        }
    }
}

